<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (c) 2010 DeltaXML Ltd.  All rights reserved. -->
<!-- This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License version 3 only,
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License version 3 for more details
    (a copy is included in the LICENSE-LGPL.txt file that accompanied this code).

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> -->
<!-- $Id: schematron-coverage.xsl 6811 2010-07-23 16:57:28Z nigelw $ -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xs="http://www.w3.org/2001/XMLSchema" 
                
                xmlns:sch="http://purl.oclc.org/dsdl/schematron"
                xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                
                exclude-result-prefixes="xs"
                version="2.0">
  
  <xsl:output indent="yes"/>
  
  <xsl:variable name="svrl-reports" select="collection('../test?select=*.svrl;recurse=yes')"/>
  
  <xsl:template match="/">
    <!--<xsl:message>SVRL files:</xsl:message>
    <xsl:for-each select="$svrl-reports">
      <xsl:message><xsl:value-of select="document-uri(.)"/></xsl:message>
    </xsl:for-each>-->
    <schematron-coverage>
      <xsl:for-each select="//sch:rule">
        <xsl:variable name="id" select="./@id"/>
        <xsl:if test="normalize-space($id) eq ''">
          <xsl:message>*** WARNING: Schematron rule with context '<xsl:value-of select="@context"/>' has no id</xsl:message>
        </xsl:if>
        
        <xsl:variable name="trigger-counts" as="xs:integer*">
          <xsl:for-each select="$svrl-reports">
            <xsl:value-of select="count(.//svrl:fired-rule[@id eq $id])"/>
          </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="total-count" select="sum($trigger-counts)"/>
        <xsl:if test="not(normalize-space($id) eq '') and $total-count eq 0">
          <xsl:message>*** WARNING: Rule <xsl:value-of select="$id"/> is never triggered</xsl:message>
        </xsl:if>
<!--        <xsl:message>Trigger counts: <xsl:copy-of select="$trigger-counts" copy-namespaces="no"/></xsl:message>-->
<!--        <xsl:message>Found Rule with <xsl:value-of select="if (normalize-space($id) = '') then 'no ' else ''"/>id <xsl:value-of select="$id"/></xsl:message>-->
        <rule>
          <xsl:copy-of select="@id"/>
          <xsl:attribute name="trigger-count" select="$total-count"/>
        </rule>
      </xsl:for-each>
    </schematron-coverage>
  </xsl:template>
  
  
</xsl:stylesheet>
