<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (c) 2010 DeltaXML Ltd.  All rights reserved. -->
<!-- This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License version 3 only,
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License version 3 for more details
    (a copy is included in the LICENSE-LGPL.txt file that accompanied this code).

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> -->
<!-- $Id: odf-zip-to-single-file.xsl 6811 2010-07-23 16:57:28Z nigelw $ -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                
                xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" 
                xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0"
                xmlns:style="urn:oasis:names:tc:opendocument:xmlns:style:1.0"
                xmlns:table="urn:oasis:names:tc:opendocument:xmlns:table:1.0"
                xmlns:ooo="http://openoffice.org/2004/office" 
                xmlns:form="urn:oasis:names:tc:opendocument:xmlns:form:1.0" 
                xmlns:script="urn:oasis:names:tc:opendocument:xmlns:script:1.0" 
                xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
                xmlns:chart="urn:oasis:names:tc:opendocument:xmlns:chart:1.0" 
                xmlns:math="http://www.w3.org/1998/Math/MathML" 
                xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" 
                xmlns:draw="urn:oasis:names:tc:opendocument:xmlns:drawing:1.0"
                xmlns:dom="http://www.w3.org/2001/xml-events" 
                xmlns:dr3d="urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0"  
                xmlns:xforms="http://www.w3.org/2002/xforms" 
                xmlns:svg="urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0" 
                xmlns:ooow="http://openoffice.org/2004/writer" 
                xmlns:number="urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0" 
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
                xmlns:oooc="http://openoffice.org/2004/calc" 
                xmlns:fo="urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0" 
                xmlns:xlink="http://www.w3.org/1999/xlink" 
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:rpt="http://openoffice.org/2005/report"
                xmlns:of="urn:oasis:names:tc:opendocument:xmlns:of:1.2"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:field="urn:openoffice:names:experimental:ooo-ms-interop:xmlns:field:1.0"
                xmlns:delta="http://www.deltaxml.com/ns/track-changes/delta-namespace"
                xmlns:ac="http://www.deltaxml.com/ns/track-changes/attribute-change-namespace"
                
                version="2.0">
  
  <xsl:variable name="content-doc" select="/*"/> <!-- we don't need this one but use it for consistency -->
  <xsl:variable name="styles-doc" select="document('styles.xml', /*)"/>
  <xsl:variable name="meta-doc" select="document('meta.xml', /*)"/>
  <xsl:variable name="settings-doc" select="document('settings.xml', /*)"/>
  <xsl:variable name="base-uri" select="base-uri()"/>

  <xsl:param name="mimetype" select="''"/> <!-- this needs to be passed in as a parameter because loading an unparsed text file doesn't seem to use the specified URIResolver -->

  <xsl:output indent="yes"/>

  <!-- identity transform -->
  <xsl:template match="node() | @*" mode="#all">
    <xsl:copy>
      <xsl:apply-templates select="@* | node()" mode="#current"/>
    </xsl:copy>
  </xsl:template>
  
  <!-- from content.xml, create a single file format by merging contents of all content.xml, styles.xml, meta.xml and settings.xml -->
  <xsl:template match="/">
    <office:document>
      <xsl:attribute name="office:mimetype" select="$mimetype"/>
      <xsl:apply-templates select="$content-doc/office:document-content/@*, 
                                   $styles-doc/office:document-styles/@*, 
                                   $meta-doc/office:document-meta/@*, 
                                   $settings-doc/office:document-settings/@*"/>
      <xsl:copy-of select="$meta-doc//office:meta"/>
      <xsl:copy-of select="$settings-doc//office:settings"/>
      <xsl:copy-of select="$content-doc//office:scripts"/>
      <office:font-face-decls>
        <xsl:variable name="font-names" select="distinct-values($content-doc//office:font-face-decls/style:font-face/@style:name)"/>
        <xsl:for-each select="$font-names">
          <xsl:choose>
            <xsl:when test="exists($content-doc//office:font-face-decls/style:font-face[@style:name = current()])">
              <xsl:copy-of select="$content-doc//office:font-face-decls/style:font-face[@style:name = current()]"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:copy-of select="$styles-doc//office:font-face-decls/style:font-face[@style:name = current()]"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </office:font-face-decls>
      <xsl:copy-of select="$styles-doc//office:styles"/>
      <office:automatic-styles>
        <xsl:variable name="content-auto-styles" select="$content-doc//office:automatic-styles/style:style"/>
        <xsl:variable name="content-auto-list-styles" select="$content-doc//office:automatic-styles/text:list-style"/>
        <xsl:variable name="content-auto-number-styles" select="$content-doc//office:automatic-styles/number:number-style"/>
        <xsl:variable name="content-auto-currency-styles" select="$content-doc//office:automatic-styles/number:currency-style"/>
        <xsl:variable name="content-auto-percentage-styles" select="$content-doc//office:automatic-styles/number:percentage-style"/>
        <xsl:variable name="content-auto-date-styles" select="$content-doc//office:automatic-styles/number:date-style"/>
        <xsl:variable name="content-auto-time-styles" select="$content-doc//office:automatic-styles/number:time-style"/>
        <xsl:variable name="content-auto-boolean-styles" select="$content-doc//office:automatic-styles/number:boolean-style"/>
        <xsl:variable name="content-auto-text-styles" select="$content-doc//office:automatic-styles/number:text-style"/>
        <xsl:variable name="content-auto-page-layouts" select="$content-doc//office:automatic-styles/style:page-layout"/>
        
        <!-- style:style elements -->
        <xsl:copy-of select="$content-auto-styles"/>
        <xsl:for-each select="$styles-doc//office:automatic-styles/style:style">
          <xsl:if test="not(exists($content-auto-styles[@style:name=current()/@style:name and 
                                                        @style:family=current()/@style:family]))">
            <xsl:copy-of select="current()"/>
          </xsl:if>
        </xsl:for-each>
        
        <!-- text:list-style elements -->
        <xsl:copy-of select="$content-auto-list-styles"/>
        <xsl:for-each select="$styles-doc//office:automatic-styles/text:list-style">
          <xsl:if test="not(exists($content-auto-list-styles[@style:name=current()/@style:name]))">
            <xsl:copy-of select="current()"/>
          </xsl:if>
        </xsl:for-each>
        
        <!-- number:number-style elements -->
        <xsl:copy-of select="$content-auto-number-styles"/>
        <xsl:for-each select="$styles-doc//office:automatic-styles/number:number-style">
          <xsl:if test="not(exists($content-auto-number-styles[@style:name=current()/@style:name]))">
            <xsl:copy-of select="current()"/>
          </xsl:if>
        </xsl:for-each>
        
        <!-- number:currency-style elements -->
        <xsl:copy-of select="$content-auto-currency-styles"/>
        <xsl:for-each select="$styles-doc//office:automatic-styles/number:currency-style">
          <xsl:if test="not(exists($content-auto-currency-styles[@style:name=current()/@style:name]))">
            <xsl:copy-of select="current()"/>
          </xsl:if>
        </xsl:for-each>
        
        <!-- number:percentage-style elements -->
        <xsl:copy-of select="$content-auto-percentage-styles"/>
        <xsl:for-each select="$styles-doc//office:automatic-styles/number:percentage-style">
          <xsl:if test="not(exists($content-auto-percentage-styles[@style:name=current()/@style:name]))">
            <xsl:copy-of select="current()"/>
          </xsl:if>
        </xsl:for-each>
        
        <!-- number:date-style elements -->
        <xsl:copy-of select="$content-auto-date-styles"/>
        <xsl:for-each select="$styles-doc//office:automatic-styles/number:date-style">
          <xsl:if test="not(exists($content-auto-date-styles[@style:name=current()/@style:name]))">
            <xsl:copy-of select="current()"/>
          </xsl:if>
        </xsl:for-each>
        
        <!-- number:time-style elements -->
        <xsl:copy-of select="$content-auto-time-styles"/>
        <xsl:for-each select="$styles-doc//office:automatic-styles/number:time-style">
          <xsl:if test="not(exists($content-auto-time-styles[@style:name=current()/@style:name]))">
            <xsl:copy-of select="current()"/>
          </xsl:if>
        </xsl:for-each>
        
        <!-- number:boolean-style elements -->
        <xsl:copy-of select="$content-auto-boolean-styles"/>
        <xsl:for-each select="$styles-doc//office:automatic-styles/number:boolean-style">
          <xsl:if test="not(exists($content-auto-boolean-styles[@style:name=current()/@style:name]))">
            <xsl:copy-of select="current()"/>
          </xsl:if>
        </xsl:for-each>
        
        <!-- number:text-style elements -->
        <xsl:copy-of select="$content-auto-text-styles"/>
        <xsl:for-each select="$styles-doc//office:automatic-styles/number:text-style">
          <xsl:if test="not(exists($content-auto-text-styles[@style:name=current()/@style:name]))">
            <xsl:copy-of select="current()"/>
          </xsl:if>
        </xsl:for-each>
        
        <!-- style:page-layout elements -->
        <xsl:copy-of select="$content-auto-page-layouts"/>
        <xsl:for-each select="$styles-doc//office:automatic-styles/style:page-layout">
          <xsl:if test="not(exists($content-auto-page-layouts[@style:name=current()/@style:name]))">
            <xsl:copy-of select="current()"/>
          </xsl:if>
        </xsl:for-each>
        
      </office:automatic-styles>
      <xsl:copy-of select="$styles-doc//office:master-styles"/>
      <xsl:copy-of select="$content-doc//office:body"/>
    </office:document>
  </xsl:template>
  
  
</xsl:stylesheet>
