/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.driver.textui;

import com.sun.msv.driver.textui.Driver;
import com.sun.msv.reader.GrammarReaderController;
import java.io.IOException;
import java.io.PrintStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DebugController
implements GrammarReaderController {
    private boolean displayWarning;
    private boolean warningReported = false;
    public EntityResolver externalEntityResolver;
    protected PrintStream out;

    public DebugController(boolean displayWarning) {
        this(displayWarning, false);
    }

    public DebugController(boolean displayWarning, boolean quiet) {
        this(displayWarning, quiet, System.out);
    }

    public DebugController(boolean displayWarning, boolean quiet, EntityResolver externalEntityResolver) {
        this(displayWarning, quiet, System.out, externalEntityResolver);
    }

    public DebugController(boolean displayWarning, boolean quiet, PrintStream outDevice) {
        this(displayWarning, quiet, outDevice, null);
    }

    public DebugController(boolean displayWarning, boolean quiet, PrintStream outDevice, EntityResolver externalEntityResolver) {
        this.out = outDevice;
        this.displayWarning = displayWarning;
        this.warningReported = quiet;
        this.externalEntityResolver = externalEntityResolver;
    }

    @Override
    public void warning(Locator[] loc, String errorMessage) {
        if (!this.displayWarning) {
            if (!this.warningReported) {
                this.out.println(Driver.localize("Driver.WarningFound"));
            }
            this.warningReported = true;
            return;
        }
        this.out.println(errorMessage);
        if (loc == null || loc.length == 0) {
            this.out.println("  location unknown");
        } else {
            for (int i = 0; i < loc.length; ++i) {
                this.printLocation(loc[i]);
            }
        }
    }

    @Override
    public void error(Locator[] loc, String errorMessage, Exception nestedException) {
        if (nestedException instanceof SAXException) {
            this.out.println("SAXException: " + nestedException.getLocalizedMessage());
            SAXException se = (SAXException)nestedException;
            if (se.getException() != null) {
                this.out.println("  nested exception: " + se.getException().getLocalizedMessage());
                se.getException().printStackTrace(System.out);
            }
        } else {
            this.out.println(errorMessage);
            if (nestedException != null) {
                System.out.println(nestedException);
            }
        }
        if (loc == null || loc.length == 0) {
            this.out.println("  location unknown");
        } else {
            for (int i = 0; i < loc.length; ++i) {
                this.printLocation(loc[i]);
            }
        }
    }

    private void printLocation(Locator loc) {
        String col = "";
        if (loc.getColumnNumber() >= 0) {
            col = ":" + loc.getColumnNumber();
        }
        this.out.println("  " + loc.getLineNumber() + col + "@" + loc.getSystemId());
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (this.externalEntityResolver != null) {
            return this.externalEntityResolver.resolveEntity(publicId, systemId);
        }
        return null;
    }
}

