//  2004 Monsell EDM Ltd.    All rights reserved.
// $Id: StreamString.java,v 1.2 2004/11/15 01:40:46 nigelw Exp $

import com.deltaxml.api.DeltaXMLProcessingException;
import com.deltaxml.api.XMLComparator;
import com.deltaxml.api.XMLComparatorConfigurationException;
import com.deltaxml.api.XMLComparatorFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import java.io.StringReader;
import java.io.StringWriter;

/**
 * Shows how java Strings can be read and written by a pipeline.
 * Such Strings could be produced more dynamically than in this
 * example, for example from a GUI widget or a database.
 */
public class StreamString
{

    // Our examle XML fragments as Strings
    static final String tree1= "<root><a><b attr='42'/></a></root>";
    static final String tree2= "<root><a><b attr='12'/><c/></a></root>";
    static final String tree3= "<root><a><b attr='12'/><c></a></root>";  // not well-formed

    public static void main(String[] args)
    {  
        XMLComparator comparator;
        try {
            comparator= XMLComparatorFactory.newInstance().newXMLComparator();
        } catch (XMLComparatorConfigurationException xcce) {
            throw new Error("Cannot create comparator", xcce);
        }
        StringWriter resultBuffer= new StringWriter();
        try {
            // more rigourous code would do argument checking
            System.out.println("Comparing tree1 and tree2 strings...");
            comparator.compare(new StreamSource(new StringReader(tree1), "string:tree1"),
                               new StreamSource(new StringReader(tree2), "string:tree2"),
                               new StreamResult(resultBuffer));
            System.out.println("The result tree was: " + resultBuffer.toString());
            // The following demonstates the advantages of setting a system id,
            // the error message will indicate which input contains the error
            System.out.println("Comparing tree1 and tree3 strings...");
            comparator.compare(new StreamSource(new StringReader(tree1), "string:tree1"),
                               new StreamSource(new StringReader(tree3), "string:tree3"),
                               new StreamResult(resultBuffer));
        } catch (DeltaXMLProcessingException dxpe) {
            throw new Error("Problem during comparsion", dxpe);
        }
    }
}
