//  2004 Monsell EDM Ltd.    All rights reserved.
// $Id: StreamFile.java,v 1.2 2004/11/15 01:41:53 nigelw Exp $

import com.deltaxml.api.DeltaXMLProcessingException;
import com.deltaxml.api.XMLComparator;
import com.deltaxml.api.XMLComparatorConfigurationException;
import com.deltaxml.api.XMLComparatorFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import java.io.File;

/**
 * Demonstrates how a very simple DeltaXML pipeline can be
 * constructed using JAXP Stream arguments and File objects.
 */
public class StreamFile
{
    public static void main(String[] args)
    {  
        XMLComparator comparator;
        try {
            comparator= XMLComparatorFactory.newInstance().newXMLComparator();
        } catch (XMLComparatorConfigurationException xcce) {
            throw new Error("Cannot create comparator", xcce);
        }
        try {
            // more rigourous code would do argument checking
            comparator.compare(new StreamSource(new File(args[0])),
                               new StreamSource(new File(args[1])),
                               new StreamResult(new File(args[2])));
        } catch (DeltaXMLProcessingException dxpe) {
            throw new Error("Problem during comparsion", dxpe);
        }
    }
}
