//  2004 Monsell EDM Ltd.    All rights reserved.
// $Id: ParserControl.java,v 1.2 2004/11/15 01:49:10 nigelw Exp $

import com.deltaxml.api.DeltaXMLProcessingException;
import com.deltaxml.api.XMLComparator;
import com.deltaxml.api.XMLComparatorConfigurationException;
import com.deltaxml.api.XMLComparatorFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.xml.sax.XMLReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXException;

public class ParserControl
{
    public static void main(String[] args)
    {  
        XMLComparator comparator;
        try {
            comparator= XMLComparatorFactory.newInstance().newXMLComparator();
        } catch (XMLComparatorConfigurationException xcce) {
            throw new Error("Cannot create comparator", xcce);
        }
        XMLReader reader1, reader2;
        try {
            SAXParserFactory spf= SAXParserFactory.newInstance();
            reader1= spf.newSAXParser().getXMLReader();
            reader2= spf.newSAXParser().getXMLReader();
            reader1.setFeature("http://xml.org/sax/features/validation", true);
            reader2.setFeature("http://xml.org/sax/features/validation", true);
        } catch (ParserConfigurationException pce) {
            throw new Error("Cannot configure parsers", pce);
        } catch (SAXNotRecognizedException snre) {
            throw new Error("The validation feature is not recognized by this (limited) parser", snre);
        } catch (SAXNotSupportedException snse) {
            throw new Error("The validation feature is not supported by this (limited) parser", snse);
        } catch (SAXException se) {
            throw new Error("Cannot get an XMLReader", se);
        }
        try {
            // more rigourous code would do argument checking
            comparator.compare(new SAXSource(reader1, new InputSource(args[0])),
                               new SAXSource(reader2, new InputSource(args[1])),
                               new StreamResult(new File(args[2])));
        } catch (DeltaXMLProcessingException dxpe) {
            throw new Error("Problem during comparsion", dxpe);
        }
    }
}
