// $Id: OutputControl.java,v 1.2 2004/11/15 01:46:46 nigelw Exp $
//  Monsell EDM Ltd. All rights reserved.
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;

/**
 * An example which shows how the final stage of a pipeline can be
 * configured to control formatting features such as indentation
 * at runtime (rather than perhaps statically using <xsl:output .../>).
 */
public class OutputControl {

    /**
     * Applies a 3 stage pipeline.
     * args[0] is the input file
     * args[1] is the output file
     */
    public static void main(String[] args)
        throws TransformerException, TransformerConfigurationException
    {
    
        TransformerFactory tf= TransformerFactory.newInstance();
        if (!tf.getFeature(SAXSource.FEATURE) ||
            !tf.getFeature(SAXResult.FEATURE) ||
            !tf.getFeature(SAXTransformerFactory.FEATURE))
            throw new Error("SAXTransformerFactory not supported");
        SAXTransformerFactory stf= (SAXTransformerFactory) tf;

        // Stage 1 of our pipeline is an triggered XSLT transformer
        // Stage 2 is an XSLT transformer used in push-mode (a TransformerHandler)
        Transformer stage1= stf.newTransformer(new StreamSource("stage1.xsl"));
        TransformerHandler stage2= stf.newTransformerHandler(new StreamSource("stage2.xsl"));
        
        stage2.setResult(new StreamResult(args[1]));
        // The stage 2 output needs configuring before the pipeline is triggered
        if (args.length >= 3 && args[2].equalsIgnoreCase("yes")) {
            stage2.getTransformer().setOutputProperty(OutputKeys.INDENT, "yes");
            // The following 3 properties are processor specific and control
            // the indentation size used by various XSLT processors
            stage2.getTransformer().setOutputProperty("{http://icl.com/saxon}indent-spaces", "2");
            stage2.getTransformer().setOutputProperty("{http://saxon.sf.net/}indent-spaces", "2");
            stage2.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        } else {
            stage2.getTransformer().setOutputProperty(OutputKeys.INDENT, "no");
        }
        stage1.transform(new StreamSource(args[0]),
                         new SAXResult(stage2));
    }
}
