// $Id: FiveStages.java,v 1.2 2004/11/15 01:50:07 nigelw Exp $
//  2004 Monsell EDM Ltd.  All rights reserved

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;
import org.xml.sax.XMLFilter;
import org.xml.sax.InputSource;

/**
 * Demonstrates the construction of a 5 stage pipeline.
 * The middle (third) stage is triggered and this stage
 * is preceeded by 2 pull mode stages and then there are
 * 2 push mode stages.
 */

public class FiveStages {

    /**
     * Applies a 5 stage pipeline.
     * args[0] is the input file
     * args[1] is the output file
     */
    public static void main(String[] args)
        throws TransformerException, TransformerConfigurationException
    {
    
        TransformerFactory tf= TransformerFactory.newInstance();
        if (!tf.getFeature(SAXSource.FEATURE) ||
            !tf.getFeature(SAXResult.FEATURE) ||
            !tf.getFeature(SAXTransformerFactory.FEATURE) ||
            !tf.getFeature(SAXTransformerFactory.FEATURE_XMLFILTER))
            throw new Error("SAXTransformerFactory not supported");
        SAXTransformerFactory stf= (SAXTransformerFactory) tf;

        // Instantiate objects corresponding to the 5 stages
        XMLFilter stage1= stf.newXMLFilter(new StreamSource("stage1.xsl"));
        XMLFilter stage2= stf.newXMLFilter(new StreamSource("stage2.xsl"));
        Transformer stage3= stf.newTransformer(new StreamSource("stage3.xsl"));
        TransformerHandler stage4= stf.newTransformerHandler(new StreamSource("stage4.xsl"));
        TransformerHandler stage5= stf.newTransformerHandler(new StreamSource("stage5.xsl"));
       
	// Hook the stages together and finally trigger the pipeline
	// stage1 does not explicitly set a parent, in such cases the default action
	// is to create and use a SAXParser using the factory defaults as the parent
        stage2.setParent(stage1);
        stage4.setResult(new SAXResult(stage5));
        stage5.setResult(new StreamResult(args[1]));
        stage3.transform(new SAXSource(stage2, new InputSource(args[0])),
                         new SAXResult(stage4));
    }
}
