import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.*;
import java.io.File;

public class FiveStagesS9Multi {

    /**
     * Applies a 5 stage pipeline.
     * args[0] is the input file
     * args[1] is the output file
     */
  public static void main(String[] args)
  throws SaxonApiException
  {
    Processor proc = new Processor(false);
    XsltCompiler comp = proc.newXsltCompiler();
    XdmNode in= proc.newDocumentBuilder().build(new StreamSource(new File(args[0])));
    Serializer out= new Serializer();
    out.setOutputFile(new File(args[1]));
    XsltTransformer stage1 = comp.compile(new StreamSource(new File("stage1.xsl"))).load();
    XsltTransformer stage2 = comp.compile(new StreamSource(new File("stage2.xsl"))).load();
    XsltTransformer stage3 = comp.compile(new StreamSource(new File("stage3.xsl"))).load();
    XsltTransformer stage4 = comp.compile(new StreamSource(new File("stage4.xsl"))).load();
    XsltTransformer stage5 = comp.compile(new StreamSource(new File("stage5.xsl"))).load();

    XdmDestination stage1result= new XdmDestination();
    stage1.setDestination(stage1result);
    stage1.setInitialContextNode(in);
    stage1.transform();

    in= null;
    XdmDestination stage2result= new XdmDestination();
    stage2.setDestination(stage2result);
    stage2.setInitialContextNode(stage1result.getXdmNode());
    stage2.transform();

    stage1result= null; stage1= null;
    XdmDestination stage3result= new XdmDestination();
    stage3.setDestination(stage3result);
    stage3.setInitialContextNode(stage2result.getXdmNode());
    stage3.transform();

    stage2result= null; stage2= null;
    XdmDestination stage4result= new XdmDestination();
    stage4.setDestination(stage4result);
    stage4.setInitialContextNode(stage3result.getXdmNode());
    stage4.transform();

    stage3result= null; stage3= null;
    XdmDestination stage5result= new XdmDestination();
    stage5.setDestination(out);
    stage5.setInitialContextNode(stage4result.getXdmNode());
    stage5.transform();

    stage4result= null; stage4= null;
    stage5result= null; stage5= null;
    }
}
