import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.*;
import java.io.File;

public class FiveStagesS9 {

    /**
     * Applies a 5 stage pipeline.
     * args[0] is the input file
     * args[1] is the output file
     */
    public static void main(String[] args)
      throws SaxonApiException
    {
    
      Processor proc = new Processor(false);
      XsltCompiler comp = proc.newXsltCompiler();
        XdmNode in= proc.newDocumentBuilder().build(new StreamSource(new File(args[0])));
        Serializer out= new Serializer();
        out.setOutputFile(new File(args[1]));
        XsltTransformer stage1 = comp.compile(new StreamSource(new File("stage1.xsl"))).load();
        XsltTransformer stage2 = comp.compile(new StreamSource(new File("stage2.xsl"))).load();
        XsltTransformer stage3 = comp.compile(new StreamSource(new File("stage3.xsl"))).load();
        XsltTransformer stage4 = comp.compile(new StreamSource(new File("stage4.xsl"))).load();
        XsltTransformer stage5 = comp.compile(new StreamSource(new File("stage5.xsl"))).load();
        stage1.setDestination(stage2);
        stage2.setDestination(stage3);
        stage3.setDestination(stage4);
        stage4.setDestination(stage5);
        stage5.setDestination(out);
        stage1.setInitialContextNode(in);
        stage1.transform();
    }
}
