// $Id$
//  2004 Monsell EDM Ltd.  All rights reserved

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;
import org.xml.sax.XMLFilter;
import org.xml.sax.InputSource;

/**
 * Demonstrates the construction of a 5 stage pipeline.
 * The middle (third) stage is triggered and this stage
 * is preceeded by 2 pull mode stages and then there are
 * 2 push mode stages.
 */

public class FifteenStages {

    /**
     * Applies a 5 stage pipeline.
     * args[0] is the input file
     * args[1] is the output file
     */
    public static void main(String[] args)
	throws TransformerException, TransformerConfigurationException
    {
    
	TransformerFactory tf= TransformerFactory.newInstance();
	if (!tf.getFeature(SAXSource.FEATURE) ||
	    !tf.getFeature(SAXResult.FEATURE) ||
	    !tf.getFeature(SAXTransformerFactory.FEATURE) ||
	    !tf.getFeature(SAXTransformerFactory.FEATURE_XMLFILTER))
	    throw new Error("SAXTransformerFactory not supported");
	SAXTransformerFactory stf= (SAXTransformerFactory) tf;
	
	XMLFilter stage1= stf.newXMLFilter(new StreamSource("stage1.xsl"));
	XMLFilter stage2= stf.newXMLFilter(new StreamSource("stage2.xsl"));
	Transformer stage3= stf.newTransformer(new StreamSource("stage3.xsl"));
	TransformerHandler stage4= stf.newTransformerHandler(new StreamSource("stage4.xsl"));
	TransformerHandler stage5= stf.newTransformerHandler(new StreamSource("stage5.xsl"));
	TransformerHandler stage6= stf.newTransformerHandler(new StreamSource("stage6.xsl"));
	TransformerHandler stage7= stf.newTransformerHandler(new StreamSource("stage7.xsl"));
	TransformerHandler stage8= stf.newTransformerHandler(new StreamSource("stage8.xsl"));
	TransformerHandler stage9= stf.newTransformerHandler(new StreamSource("stage9.xsl"));
	TransformerHandler stage10= stf.newTransformerHandler(new StreamSource("stage10.xsl"));
	TransformerHandler stage11= stf.newTransformerHandler(new StreamSource("stage11.xsl"));
	TransformerHandler stage12= stf.newTransformerHandler(new StreamSource("stage12.xsl"));
	TransformerHandler stage13= stf.newTransformerHandler(new StreamSource("stage13.xsl"));
	TransformerHandler stage14= stf.newTransformerHandler(new StreamSource("stage14.xsl"));
	TransformerHandler stage15= stf.newTransformerHandler(new StreamSource("stage15.xsl"));
	
	stage2.setParent(stage1);
	stage4.setResult(new SAXResult(stage5));
	stage5.setResult(new SAXResult(stage6));
	stage6.setResult(new SAXResult(stage7));
	stage7.setResult(new SAXResult(stage8));
	stage8.setResult(new SAXResult(stage9));
	stage9.setResult(new SAXResult(stage10));
	stage10.setResult(new SAXResult(stage11));
	stage11.setResult(new SAXResult(stage12));
	stage12.setResult(new SAXResult(stage13));
	stage13.setResult(new SAXResult(stage14));
	stage14.setResult(new SAXResult(stage15));
	stage15.setResult(new StreamResult(args[1]));
// 	stage5.setResult(new StreamResult(args[1]));
	stage3.transform(new SAXSource(stage2, new InputSource(args[0])),
			 new SAXResult(stage4));
    }
}
