<?xml version="1.0" encoding="UTF-8"?>
<!-- $Id: fo-changebar-optimizer.xsl 5556 2010-03-22 12:06:29Z nigelw $ -->
<!-- Copyright (c) 2010 DeltaXML Ltd.  All rights reserved. -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="2.0"
  xmlns:saxon="http://saxon.sf.net/"
  xmlns:fo="http://www.w3.org/1999/XSL/Format" extension-element-prefixes="saxon">
  
  <!--
    Yes saxon:assign is cheating - doing non-functional XSLT, but this is both simpler
    and faster than the approach based on grouping and counting previous siblings.
    
    This code assumes change-bars are well-formed - ie they nest properly - as they should
      if produced by regular XSLT code such as docbook-xsl with our customization layer.
  -->
  <xsl:variable name="changebar-nesting-level" as="xs:integer" select='0' saxon:assignable='yes'/>

  <xsl:template match="fo:change-bar-begin">
    <saxon:assign name="changebar-nesting-level" select="$changebar-nesting-level + 1"/>
    <xsl:if test="$changebar-nesting-level le 1">
      <xsl:copy>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates select="node()" mode="#current"/>
      </xsl:copy>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="fo:change-bar-end">
    <xsl:if test="$changebar-nesting-level le 1">
      <xsl:copy>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates select="node()" mode="#current"/>
      </xsl:copy>
    </xsl:if>
    <saxon:assign name="changebar-nesting-level" select="$changebar-nesting-level - 1"/>
  </xsl:template>
  
  <xsl:template match="node()" mode="#all">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="node()" mode="#current"/>
    </xsl:copy>
  </xsl:template>
</xsl:stylesheet>
