<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html"/>
  
  <xsl:template match="/" name="vendorSelectionForm">
    <xsl:param name="vendorCount">
      <xsl:value-of select="extensions:getVendorList($selectedVendor, 'xslt/vendorCount.xsl')" disable-output-escaping="yes" />
    </xsl:param>
    
    <xsl:if test="$vendorCount>1">
      <xsl:choose>
        <xsl:when test="$licenseTab!='floating'">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>form action="/dashboard<xsl:if test="$compliance508='TRUE'">?compliance508=TRUE</xsl:if>" method="post" name="vendorselectionform"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>form action="/dashboard?licenseTab=floating<xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" method="post" name="vendorselectionform"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="extensions:getVendorList($selectedVendor, 'xslt/vendorSelectionDropDown.xsl')" disable-output-escaping="yes" />
      <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Select" value="<xsl:value-of select="extensions:getString('IDS_SELECT_VENDOR_DAEMON_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" style="width: 100px;" onClick="submitVendorForm('/vendor', 'start')" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/form<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
    </xsl:if>
    <xsl:if test="$vendorCount=1"><div class="largerText"><xsl:value-of select="extensions:getString('IDS_VENDOR_DAEMON_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="$selectedVendor"/></div></xsl:if>
  </xsl:template>

  <xsl:template match="fnplm:vendors">
      <select name="vendor">
        <xsl:apply-templates select="fnplm:vendor"/>
      </select>
  </xsl:template>
  
  <xsl:template match="fnplm:vendor">
     <xsl:text disable-output-escaping="yes">&lt;</xsl:text>option value="<xsl:value-of select="./@name"/>"<xsl:if test="./@name=$selectedVendor">SELECTED</xsl:if><xsl:text disable-output-escaping="yes">&gt;</xsl:text>
     <xsl:value-of select="./@name"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/option<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
  </xsl:template>
</xsl:stylesheet>

