 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
    <xsl:template name="localTable"> 
      <div class="widgetTableDiv">
       <script language="javascript">
        function submitUserListForm(id, first, last, privilege, passwordExpired, event, type) {
         if (event=='delete') {
          if (!confirm("<xsl:value-of select="extensions:getString('IDS_CONFIRM_USER_DELETE')" disable-output-escaping="yes"/>")) {
            return;
          }
         }
         document.userlistform.elements["userName"].value = id;
         document.userlistform.elements["firstName"].value = first;
         document.userlistform.elements["lastName"].value = last;
         document.userlistform.elements["accountType"].value = privilege;
         document.userlistform.elements["passwordExpired"].value = passwordExpired;
         document.userlistform.elements["event"].value = event;
         document.userlistform.elements["userType"].value = type;
         document.userlistform.submit();
        }
       </script>
       <form action="/users" method="post" name="userlistform">
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="checksum" value="<xsl:value-of select="extensions:setChecksum('userlistform')"/>" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <input type="hidden" name="userName"/>
        <input type="hidden" name="firstName"/>
        <input type="hidden" name="lastName"/>
        <input type="hidden" name="accountType"/>
        <input type="hidden" name="passwordExpired"/>
        <input type="hidden" name="event"/>
        <input type="hidden" name="userType"/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="licenseTab" value="<xsl:value-of select="$licenseTab"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="selected" value="<xsl:value-of select="$selected"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="compliance508" value="<xsl:value-of select="$compliance508" />"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <table id="myTable">
          <thead>
            <tr>
              <td style="visibility:hidden"></td>
              <td><xsl:value-of select="extensions:getString('IDS_USER_NAME_HEADER')" disable-output-escaping="yes"/></td>
              <td><xsl:value-of select="extensions:getString('IDS_FIRST_NAME_HEADER')" disable-output-escaping="yes"/></td>
              <td><xsl:value-of select="extensions:getString('IDS_LAST_NAME_HEADER')" disable-output-escaping="yes"/></td>
              <td><xsl:value-of select="extensions:getString('IDS_ROLE_HEADER')" disable-output-escaping="yes"/></td>
              <td><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
              <td><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
            </tr>
          </thead>
          <tbody class="scrollingContent">
            <xsl:variable name="userStatusReturn">
              <xsl:value-of select="extensions:getUserList('xslt/usersList.xsl')" disable-output-escaping="yes" />
            </xsl:variable>
            <xsl:choose>
              <xsl:when test="starts-with($userStatusReturn, 'ERROR_EXPIRED_SESSION:')">
                <xsl:call-template name="sessionTimeout"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:copy-of select="$userStatusReturn"/>
              </xsl:otherwise>
            </xsl:choose>
          </tbody>
        </table>
       </form>
      </div>

      <script type="text/javascript">
        initTableWidget('myTable',845,430,Array(true,'S','S1','S1','S1','S1',true, true), true);
      </script>

    </xsl:template>
  </xsl:stylesheet>
  