 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
    <xsl:template name="importedUserTable"> 

      <div class="widgetTableDiv">
       <script language="javascript">
        function tSubmitUserListForm(id, first, last, privilege, passwordExpired, event, type) {
         if (event=='delete') {
          if (!confirm("<xsl:value-of select="extensions:getString('IDS_CONFIRM_USER_DELETE')" disable-output-escaping="yes"/>")) {
            return;
          }
         }
         document.importedUserlistform.elements["userName"].value = id;
         document.importedUserlistform.elements["firstName"].value = first;
         document.importedUserlistform.elements["lastName"].value = last;
         document.importedUserlistform.elements["accountType"].value = privilege;
         document.importedUserlistform.elements["passwordExpired"].value = passwordExpired;
         document.importedUserlistform.elements["event"].value = event;
         document.importedUserlistform.elements["userType"].value = type;
         document.importedUserlistform.submit();
        }
       </script>
       <form action="/users" method="post" name="importedUserlistform">
       <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="checksum" value="<xsl:value-of select="extensions:setChecksum('importedUserlistform')"/>" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
       <input type="hidden" name="userName"/>
       <input type="hidden" name="firstName"/>
       <input type="hidden" name="lastName"/>
       <input type="hidden" name="accountType"/>
       <input type="hidden" name="passwordExpired"/>
       <input type="hidden" name="event"/>
       <input type="hidden" name="userType"/>
       <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="licenseTab" value="<xsl:value-of select="$licenseTab"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
       <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="selected" value="<xsl:value-of select="$selected"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
       <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="compliance508" value="<xsl:value-of select="$compliance508" />"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>

        <table id="importedTable">
          <thead>
            <tr>
              <td style="visibility:hidden"></td>
              <td><xsl:value-of select="extensions:getString('IDS_USER_NAME_HEADER')" disable-output-escaping="yes"/></td>
              <td> User Type </td>
              <td><xsl:value-of select="extensions:getString('IDS_ROLE_HEADER')" disable-output-escaping="yes"/></td>
              <td><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
              <td><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
            </tr>
          </thead>
          <tbody class="scrollingContent">
            <xsl:variable name="importedUserStatusReturn">
              <xsl:value-of select="extensions:getUserList('xslt/importedUsersList.xsl')" disable-output-escaping="yes" />
            </xsl:variable>
            <xsl:choose>
              <xsl:when test="starts-with($importedUserStatusReturn, 'ERROR_EXPIRED_SESSION:')">
                <xsl:call-template name="sessionTimeout"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:copy-of select="$importedUserStatusReturn"/>
              </xsl:otherwise>
            </xsl:choose>
          </tbody>
        </table>
      </form>
     </div>
      <script type="text/javascript">
        initTableWidget('importedTable',845,430,Array(false,'S','S1','S1','S1','S1',false, false), true);
      </script>
    </xsl:template>
  </xsl:stylesheet>