<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html" version="4.01" encoding="UTF-8"/>
  
  <xsl:variable name="resultCount" select="count(//fnplm:result)"/>
  
  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="count(//fnplm:result)=1">SINGLE_RESULT:</xsl:when>
      <xsl:when test="count(//fnplm:result)>1">MULTIPLE_RESULTS:</xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates select="//fnplm:importResults"/>
    <xsl:apply-templates select="//fnplm:uploadResults"/>
  </xsl:template>
  
  <xsl:template name="results" match="//fnplm:importResults">    
    <xsl:if test="//fnplm:result[@type='info']">
      <xsl:if test="$resultCount > 1"><strong><xsl:value-of select="extensions:getString('IDS_INFO_HEADER')" disable-output-escaping="yes"/></strong></xsl:if>
      <div id="importInfo">
        <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
          <xsl:apply-templates select="//fnplm:result[@type='info']"/>
        <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
      </div>
    </xsl:if>
    
    <xsl:if test="//fnplm:result[@type='error']">
      <xsl:if test="$resultCount > 1"><strong><xsl:value-of select="extensions:getString('IDS_ERROR_HEADER')" disable-output-escaping="yes"/></strong></xsl:if>
      <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
        <xsl:apply-templates select="//fnplm:result[@type='error']"/>
      <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
    </xsl:if>
    
    <xsl:if test="//fnplm:result[@type='warning']">
      <xsl:if test="$resultCount > 1"><strong><xsl:value-of select="extensions:getString('IDS_WARNING_HEADER')" disable-output-escaping="yes"/></strong></xsl:if>
      <div id="importWarning">
        <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
          <xsl:apply-templates select="//fnplm:result[@type='warning']"/>
        <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
      </div>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="uploadResults" match="//fnplm:uploadResults">    
    <xsl:if test="//fnplm:result[@type='info']">
      <xsl:if test="$resultCount > 1"><strong><xsl:value-of select="extensions:getString('IDS_INFO_HEADER')" disable-output-escaping="yes"/></strong></xsl:if>
      <div id="importInfo">
        <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
          <xsl:apply-templates select="//fnplm:result[@type='info']"/>
        <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
      </div>
    </xsl:if>
    
    <xsl:if test="//fnplm:result[@type='error']">
      <xsl:if test="$resultCount > 1"><strong><xsl:value-of select="extensions:getString('IDS_ERROR_HEADER')" disable-output-escaping="yes"/></strong></xsl:if>
      <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
        <xsl:apply-templates select="//fnplm:result[@type='error']"/>
      <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
    </xsl:if>
    
    <xsl:if test="//fnplm:result[@type='warning']">
      <xsl:if test="$resultCount > 1"><strong><xsl:value-of select="extensions:getString('IDS_WARNING_HEADER')" disable-output-escaping="yes"/></strong></xsl:if>
      <div id="importWarning">
        <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
          <xsl:apply-templates select="//fnplm:result[@type='warning']"/>
        <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
      </div>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="error" match="fnplm:result[@type='error']">
    <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>li<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
      <b><span class="errorText"><xsl:value-of select="./@message"/></span></b>
    <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/li<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
  </xsl:template>
  
  <xsl:template name="warning" match="fnplm:result[@type='warning']">
    <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>li<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
      <b><span class="warningText"><xsl:value-of select="./@message"/></span></b>
    <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/li<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
  </xsl:template>
  
  <xsl:template name="info" match="fnplm:result[@type='info']">
    <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>li<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
      <b><span class="infoText"><xsl:value-of select="./@message"/></span></b>
    <xsl:if test="$resultCount > 1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/li<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
  </xsl:template>
</xsl:stylesheet>

