<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:param name="compliance508"><xsl:value-of select="extensions:getEnv('compliance508')" disable-output-escaping="yes"/></xsl:param>
  
  <xsl:template match="/" name="host">
    <a href="javascript:history.back()" class="textLink"><xsl:value-of select="extensions:getString('IDS_RETURN_LINK')" disable-output-escaping="yes"/></a>
		<p></p>
    <xsl:apply-templates select="xml/fnplm:host" />
  </xsl:template>
  
  <xsl:template match="fnplm:host">
    <h2><xsl:value-of select="extensions:getString('IDS_HOST_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="./@hostname"/></h2>
    <div class="divider"></div>
    <xsl:apply-templates select="fnplm:detail"/>
  </xsl:template>
  
  <xsl:template match="fnplm:detail">
    <div class="Column30Percent"><xsl:value-of select="extensions:getString('IDS_VENDOR_LABEL')" disable-output-escaping="yes"/></div>
    <div class="Column69Percent"><xsl:value-of select="./@vendorname"/></div><br />
    <div class="Column30Percent"><xsl:value-of select="extensions:getString('IDS_PRODUCT_NAME_LABEL')" disable-output-escaping="yes"/></div>
    <div class="Column69Percent"><xsl:value-of select="./@productname"/></div><br />
    <div class="Column30Percent"><xsl:value-of select="extensions:getString('IDS_PRODUCT_VERSION_LABEL')" disable-output-escaping="yes"/></div>
    <div class="Column69Percent"><xsl:value-of select="./@productversion"/></div><br />
    <div class="Column30Percent"><xsl:value-of select="extensions:getString('IDS_FULFILLMENT_ID_LABEL')" disable-output-escaping="yes"/></div>
    <div class="Column69Percent"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="fulfillments?vendor=<xsl:value-of select="./@vendorname"/>&amp;productId=<xsl:value-of select="./@productid"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="./@fulfillmentrecordid"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div><br />
    <div class="divider"></div>
  </xsl:template>
</xsl:stylesheet>


