<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  
  <xsl:param name="expiredPassword"><xsl:value-of select="//fnplm:input/@expiredPassword"/></xsl:param>
  <xsl:template name="header">

    <title><xsl:value-of select="extensions:getString('IDS_APPLICATION_TITLE')" disable-output-escaping="yes"/></title>
    
      <xsl:choose>
        <xsl:when test="$compliance508!='TRUE'">
          <style> html{display : none ; } </style>
          <script>
              if( self == top ) {
                  document.documentElement.style.display = 'block' ; 
              } else {
                  top.location = self.location ; 
              }
          </script>
          <link rel="stylesheet" type="text/css" href="resources/content.css" media="screen"/>
          <link rel="stylesheet" type="text/css" href="resources/structure.css"/>
          <link rel="stylesheet" type="text/css" href="resources/veneer.css"/>
        </xsl:when>
        <xsl:otherwise>
          <link rel="stylesheet" type="text/css" href="resources/508/content.css"/>
          <link rel="stylesheet" type="text/css" href="resources/508/structure.css"/>
          <link rel="stylesheet" type="text/css" href="resources/508/veneer.css"/>
          <link rel="stylesheet" type="text/css" href="resources/508/veneerPopup.css"/>
        </xsl:otherwise>
      </xsl:choose>

      <script type="text/javascript" src="resources/standard.js"/>
      <xsl:if test="$login!='TRUE'">
        <script type="text/javascript" src="resources/prototype.js"/>
        <script type="text/javascript" src="resources/moo.fx.js"/>
        <script type="text/javascript" src="resources/moo.fx.pack.js"/>
      </xsl:if>
      <script type="text/javascript" src="resources/tableSorter.js"/>
      <script type="text/javascript" src="resources/ajax.js"/>
      <script type="text/javascript" src="resources/popup.js"/>
      <script type="text/javascript" src="resources/drag.js"/>
      <script type="text/javascript" src="resources/yahoofiles/yp_files/yahoo.js"/>
      <script type="text/javascript" src="resources/yahoofiles/yp_files/event.js"/>
      <script type="text/javascript" src="resources/yahoofiles/yp_files/dom.js"/>
      <script type="text/javascript" src="resources/yahoofiles/yp_files/dragdrop.js"/>
      <script type="text/javascript" src="resources/yahoofiles/yp_files/animation.js"/>
      <script type="text/javascript" src="resources/yahoofiles/yp_files/container.js"/>
      <!-- NEW CODE BEGIN -->
      <script language="javascript">AC_FL_RunContent = 0;</script>
      <script type="text/javascript" src="resources/AC_RunActiveContent.js"></script>
      <!-- NEW CODE END -->
	  
	  <!-- Form text filed should not accept %<>()"'-->
	  <script type="text/javascript">
		String.prototype.isStringentSet = function () {return /[%;&lt;&gt;&quot;()&apos;]/.test(this)}
		String.prototype.isLooseSet = function () {return /[%;&lt;&gt;&quot;&apos;]/.test(this)}

		function stringentCheck () {
			if (this.value.isStringentSet()) {
				alert ('<xsl:value-of select="extensions:getString('IDS_RESERVED_CHAR_ERROR')" disable-output-escaping="yes"/>');
				this.value = '';
				this.focus();
			}
		}

		function looseCheck () {
			if (this.value.isLooseSet())  {
				alert ('<xsl:value-of select="extensions:getString('IDS_RESERVED_CHAR_ERROR')" disable-output-escaping="yes"/>');
				this.value = '';
				this.focus();
			}
		}
		
		if (document.getElementById) onload = function () {
			var e, i;
			var checkType;
			if (document.forms.length > 0)  {
				checkType = document.forms[0].getAttribute('id');
				for (i = 0; e = document.forms[0].elements[i]; i++) {
					if (e.type == 'text')  {
						if (checkType == 'looseCheck') e.onchange = looseCheck
						else e.onchange = stringentCheck
						
					}
				}
			}
		}		
	</script>

      <script type="text/javascript">
        var GB_ANIMATION = false;
        var GB_IMG_DIR = "images/popup/";
        var GB_overlay_click_close = false;

        function initializePasswordWindow() {
          mypanelPassword = new YAHOO.widget.Panel("winPassword", { effect:null, width:"376px", fixedcenter: true, constraintoviewport: true, underlay:"none", close:false, visible:false, draggable:false, modal:true} );
          mypanelPassword.render();
          
          <xsl:if test="$expiredPassword='true' and  $compliance508!='TRUE'">
            mypanelPassword.show();
            return GB_show('password', 'password?expiredPassword=true', 270, 328);
          </xsl:if>
        }

        function initializeSigninWindow() {
          mypanelSignin = new YAHOO.widget.Panel("winSignin", { effect:null, width:"376px", fixedcenter: true, constraintoviewport: true, underlay:"none", close:false, visible:false, draggable:false, modal:true} );
          
          <xsl:if test="$login='TRUE' and $compliance508!='TRUE'">
            <xsl:variable name="adminParameters">
              <xsl:if test="$dashboard!='TRUE'">admin=true</xsl:if>
            </xsl:variable>
            
            mypanelSignin.render();
            mypanelSignin.show();
              
            <xsl:choose>
              <xsl:when test="$test=''">
                <xsl:choose>
                  <xsl:when test="$failed=''">
                    return GB_show('signin', 'signin?<xsl:value-of select="$adminParameters"/>&amp;location=<xsl:value-of select="$location"/>&amp;vendor=<xsl:value-of select="$vendorEnv"/>&amp;licenseTab=<xsl:value-of select="$licenseTabEnv"/>&amp;selected=<xsl:value-of select="$selectedEnv"/>', 280, 328);
                  </xsl:when>
                  <xsl:otherwise>
                    return GB_show('signin', 'signin?failed=<xsl:copy-of select="$failed" />&amp;<xsl:value-of select="$adminParameters"/>&amp;location=<xsl:value-of select="$location"/>&amp;vendor=<xsl:value-of select="$vendorEnv"/>&amp;licenseTab=<xsl:value-of select="$licenseTabEnv"/>&amp;selected=<xsl:value-of select="$selectedEnv"/>', 280, 328);
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                return GB_show('signin', 'signin?test=true', 280, 328);
              </xsl:otherwise>
            </xsl:choose>
          </xsl:if>
        }

        YAHOO.util.Event.addListener(window,"load",initializeSigninWindow);
        YAHOO.util.Event.addListener(window,"load",initializePasswordWindow);
      </script>
      
      <meta http-equiv="Cache-Control" content="no-cache"/>
      <meta http-equiv="Pragma" content="no-cache"/>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
  </xsl:template>
</xsl:stylesheet>

