<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="text" encoding="UTF-8"/>
  <xsl:include href="sessionTimeout.xsl"/>
  <xsl:param name="vendor"><xsl:value-of select="//fnplm:input/@vendor"/></xsl:param>
  <xsl:param name="productId"><xsl:value-of select="//fnplm:input/@productId"/></xsl:param>
  <xsl:param name="feature"><xsl:value-of select="//fnplm:input/@feature"/></xsl:param>
  <xsl:param name="version"><xsl:value-of select="//fnplm:input/@version"/></xsl:param>
  <xsl:param name="host"><xsl:value-of select="//fnplm:input/@host"/></xsl:param>
  <xsl:param name="details"><xsl:value-of select="//fnplm:input/@details"/></xsl:param>
  
  <xsl:template match="/">
    <xsl:param name="detailsReturn">
      <xsl:choose>
        <xsl:when test="$details='HOSTS'">
          <xsl:value-of select="extensions:getHostSummary($vendor, $productId, '-1', '@name', 'descending', 'xslt/hostsExport.xsl')" disable-output-escaping="yes" />
        </xsl:when>
        <xsl:when test="$details='FULFILLMENTS'">
          <xsl:value-of select="extensions:getFulfillmentSummary($vendor, $productId, '-1', '@fulfillmentid', 'descending', 'xslt/fulfillmentsExport.xsl')" disable-output-escaping="yes" />
        </xsl:when>
        <xsl:when test="$details='CONCURRENT_HOSTS'">
          <xsl:value-of select="extensions:getUserSummary($vendor, $feature, $version, '@hostname', 'descending', '-1', 'xslt/concurrentHostsExport.xsl')" disable-output-escaping="yes" />
        </xsl:when>
        <xsl:when test="$details='HOST'">
          <xsl:value-of select="extensions:getHost($vendor, $host, 'xslt/hostExport.xsl')" disable-output-escaping="yes" />
        </xsl:when>
      </xsl:choose>
    </xsl:param>
    
    <xsl:choose>
      <xsl:when test="starts-with($detailsReturn, 'ERROR_EXPIRED_SESSION:')">
        <xsl:call-template name="sessionTimeout"/>
      </xsl:when>
      <xsl:when test="$detailsReturn != ''">
        <xsl:copy-of select="$detailsReturn"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="$detailsReturn"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>

