<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html" version="4.01" encoding="UTF-8"/>
  <xsl:include href="commonAdmin.xsl"/>
  <xsl:include href="sessionTimeout.xsl"/>
  <xsl:variable name="help_id">HELP_IDS_ALERTS</xsl:variable>

  <xsl:param name="admin" select="'ALERTS'"/>
  <xsl:variable name="alertEvent">
    <xsl:choose>
      <xsl:when test="$event='save'">Save</xsl:when>
      <xsl:otherwise><xsl:value-of select="//fnplm:input/@Save"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:param name="compliance508"><xsl:value-of select="//fnplm:input/@compliance508"/></xsl:param>
  
  <xsl:param name="eventResult">
    <xsl:choose>
      <xsl:when test="$alertEvent!=''">
        <xsl:variable name="inXML" select="//xml/*"/>
        <xsl:value-of select="extensions:setAlertsConfig($inXML)"/>
      </xsl:when>
    </xsl:choose>
  </xsl:param>
    
  <xsl:param name="message">
    <xsl:choose>
      <xsl:when test="$alertEvent!='' and $eventResult=''">SAVE_OK</xsl:when>
      <xsl:when test="substring-after($eventResult, ':')!=''">
        <xsl:value-of select="substring-after($eventResult, ':')"/>
      </xsl:when>
      <xsl:otherwise><xsl:value-of select="$eventResult"/></xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:template match="/">
    <xsl:if test="starts-with($eventResult, 'ERROR_EXPIRED_SESSION:')">
      <xsl:call-template name="sessionTimeout"/>
    </xsl:if>
    <xsl:call-template name="admin"/>
  </xsl:template>
</xsl:stylesheet>

