<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html"/>
  <xsl:param name="compliance508"><xsl:value-of select="extensions:getEnv('compliance508')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="licenseTabEnv"><xsl:value-of select="extensions:getEnv('licenseTab')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="adminTabEnv"><xsl:value-of select="extensions:getEnv('admin')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="vendorEnvTemp"><xsl:value-of select="extensions:getEnv('vendor')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="vendorEnv"><xsl:value-of select="extensions:getVendorList($vendorEnvTemp, 'xslt/testVendorParameter.xsl')" disable-output-escaping="yes" /></xsl:param>
  <xsl:param name="selectedEnv"><xsl:value-of select="extensions:getEnv('selected')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="selected">
    <xsl:choose>
      <xsl:when test="$selectedEnv!=''">
        <xsl:value-of select="$selectedEnv"/>
      </xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:variable name="critical" select="count(//fnplm:alert[@level='CRITICAL'])"/>
  <xsl:variable name="important" select="count(//fnplm:alert[@level='IMPORTANT'])"/>
  <xsl:variable name="minor" select="count(//fnplm:alert[@level='MINOR'])"/>
  <xsl:param name="isAdmin"><xsl:value-of select="extensions:hasPrivilege('admin')" disable-output-escaping="yes" /></xsl:param>
  
  <xsl:template match="/" name="alertSummary">
    <div class="contentSpacer">
      <h1><xsl:value-of select="extensions:getString('IDS_ALERT_HEADER')" disable-output-escaping="yes"/></h1>
      <p></p>
      
      <!-- NEW CODE BEGIN -->
      <div id="alertMenu">
        <div class="alertBlockButton">
          <xsl:variable name="criticalImagePath">
            <xsl:choose>
              <xsl:when test="$selected='0'">images/icons/48criticalSel.png</xsl:when>
              <xsl:otherwise>images/icons/48criticalUn.png</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="dashboard?vendor=<xsl:value-of select="$vendorEnv"/>&amp;licenseTab=<xsl:value-of select="$licenseTabEnv"/>&amp;admin=<xsl:value-of select="$adminTabEnv"/>&amp;selected=0<xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" onmouseover="rollover('critical','images/icons/48criticalSel.png');" onmouseout="rollover('critical','<xsl:value-of select="$criticalImagePath"/>');"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>img src="<xsl:value-of select="$criticalImagePath"/>" name="critical"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br/><div class="alertTextCritical"><xsl:value-of select="$critical"/></div>
        </div>
        <div class="alertBlockButton">
          <xsl:variable name="importantImagePath">
            <xsl:choose>
              <xsl:when test="$selected='1'">images/icons/48importantSel.png</xsl:when>
              <xsl:otherwise>images/icons/48importantUn.png</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="dashboard?vendor=<xsl:value-of select="$vendorEnv"/>&amp;licenseTab=<xsl:value-of select="$licenseTabEnv"/>&amp;admin=<xsl:value-of select="$adminTabEnv"/>&amp;selected=1<xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" onmouseover="rollover('important','images/icons/48importantSel.png');" onmouseout="rollover('important','<xsl:value-of select="$importantImagePath"/>');"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>img src="<xsl:value-of select="$importantImagePath"/>" name="important"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br/><div class="alertTextImportant"><xsl:value-of select="$important"/></div>
        </div>   
      </div>
      <!--script type="text/javascript" >
        var selection = 0;
        var selectionCookie = readCookie("selection");
          if (selectionCookie == "a1") {
            selection = 1;
          } else if (selectionCookie == "a2") {
            selection = 2;
          }
          
        AC_FL_RunContent('codebase',
          'http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,19,0',
          'width', '280', 'height', '95', 'align', 'middle', 'src',
          'images/controls/alerts?Critical=<xsl:value-of select="$critical"/>&amp;Important=<xsl:value-of select="$important"/>&amp;Minor=<xsl:value-of select="$minor"/>&amp;Selected=' + selection + '&amp;Categories=7',
          'quality', 'high', 'bgcolor', '#eeeeee', 'name', 'alerts', 'allowscriptaccess', 'sameDomain', 'pluginspage',
          'http://www.macromedia.com/go/getflashplayer', 'movie',
          'images/controls/alerts?Critical=<xsl:value-of select="$critical"/>&amp;Important=<xsl:value-of select="$important"/>&amp;Minor=<xsl:value-of select="$minor"/>&amp;Selected=' + selection + '&amp;Categories=7' );
      </script> 
      
      <noscript>
        <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444558540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0" width="280" height="95" id="alerts" align="middle">
          <param name="allowScriptAccess" value="sameDomain" />
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>param name="movie" value="images/controls/alerts.swf?Critical=<xsl:value-of select="$critical"/>&amp;Important=<xsl:value-of select="$important"/>&amp;Minor=<xsl:value-of select="$minor"/>&amp;Selected=<xsl:value-of select="$selected"/>&amp;Categories=7&amp;Message=" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          <param name="quality" value="high" />
          <param name="wmode" value="transparent"/>
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>embed src="images/controls/alerts.swf?Critical=<xsl:value-of select="$critical"/>&amp;Important=<xsl:value-of select="$important"/>&amp;Minor=<xsl:value-of select="$minor"/>&amp;Selected=<xsl:value-of select="$selected"/>&amp;Categories=7&amp;Message=" quality="high" bgcolor="#eeeeee" width="280" height="95" name="alerts" align="middle" allowScriptAccess="sameDomain" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" wmode="transparent"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </object>
      </noscript-->
      <!-- NEW CODE END -->
      <p></p>
      <div class="scrollerSmall">
        <div id="a0"	>
          <div class="alertDashboardHeader">
            <div class="alertTextCritical"><xsl:value-of select="$critical"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="extensions:getString('IDS_CRITICAL_HEADER')" disable-output-escaping="yes"/></div>
          </div>
          
          <xsl:if test="$compliance508!='TRUE'">
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div class="scrollerLarge"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:if>
          <div id="showCritical">
            <xsl:apply-templates select="//fnplm:alert[@level='CRITICAL']"/>
          </div>
          <xsl:if test="$compliance508!='TRUE'">
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:if>
        </div>
      </div>
      
      <div id="a1" style="Display: none;">
        <div class="alertDashboardHeader">
          <div class="alertTextImportant"><xsl:value-of select="$important"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="extensions:getString('IDS_IMPORTANT_HEADER')" disable-output-escaping="yes"/></div>
        </div>

        <xsl:if test="$compliance508!='TRUE'">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div class="scrollerLarge"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:if>
        <div id="showImportant">
          <xsl:apply-templates select="//fnplm:alert[@level='IMPORTANT']"/>
        </div>
        <xsl:if test="$compliance508!='TRUE'">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:if>
      </div>
      
      <div id="a2" style="Display: none;">
        <div class="alertDashboardHeader">
          <div class="alertTextMinor"><xsl:value-of select="$minor"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="extensions:getString('IDS_MINOR_HEADER')" disable-output-escaping="yes"/></div>
        </div>

        <xsl:if test="$compliance508!='TRUE'">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div class="scrollerLarge"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:if>
        <div id="showMinor">
          <xsl:apply-templates select="//fnplm:alert[@level='MINOR']"/>
        </div>
        <xsl:if test="$compliance508!='TRUE'">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:if>
      </div>
    </div>
    
    <script language="javascript">
      <xsl:choose>
        <!--xsl:when test="$selected='0'">
          showAlert('a0','1');
          showAlert('a1','0');
          showAlert('a2','0');
        </xsl:when-->
        <xsl:when test="$selected='1'">
          showAlert('a0','0');
          showAlert('a1','1');
          showAlert('a2','0');
        </xsl:when>
        <xsl:when test="$selected='2'">
          showAlert('a0','0');
          showAlert('a1','0');
          showAlert('a2','1');
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </script>
  </xsl:template>
  
  <xsl:template name="criticalItem" match="//fnplm:alert[@level='CRITICAL']">
    <xsl:variable name="linkClass">
      <xsl:if test="$isAdmin!='' and ./@type='VENDOR_DAEMON_DOWN' or $isAdmin!='' and ./@type='VENDOR_DAEMON_COULD_NOT_START'">NoLink</xsl:if>
    </xsl:variable>
    
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div class="alertContainer<xsl:value-of select="$linkClass" />"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:choose>
        <xsl:when test="$isAdmin='' and ./@type='VENDOR_DAEMON_DOWN' or $isAdmin='' and ./@type='VENDOR_DAEMON_COULD_NOT_START'">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/vendor<xsl:if test="$compliance508='TRUE'">?compliance508=TRUE</xsl:if>" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:when>
        <xsl:when test="$compliance508!='TRUE'">
          <xsl:choose>
            <xsl:when test="starts-with(./@type, 'ACTIVATION') or starts-with(./@type, 'OVERDRAFT')">
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a onclick="javascript:NewWindow('fulfillments?vendor=<xsl:value-of select="./@vendor"/>&amp;productId=<xsl:value-of select="./@entitlementID"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>', 'FlexNet', '650','600','yes','yes');" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            </xsl:when>
            <xsl:when test="starts-with(./@type, 'CONCURRENT')">
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a onclick="javascript:NewWindow('concurrenthosts?vendor=<xsl:value-of select="./@vendor"/>&amp;feature=<xsl:value-of select="./@feature"/>&amp;version=<xsl:value-of select="./@version"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>', 'FlexNet', '650','600','yes','yes');" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="starts-with(./@type, 'ACTIVATION')">
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/fulfillments?vendor=<xsl:value-of select="./@vendor"/>&amp;productId=<xsl:value-of select="./@entitlementID"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" target="_blank" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:when>
          <xsl:when test="starts-with(./@type, 'CONCURRENT')">
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/concurrenthosts?vendor=<xsl:value-of select="./@vendor"/>&amp;feature=<xsl:value-of select="./@feature"/>&amp;version=<xsl:value-of select="./@version"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" target="_blank" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            </xsl:when>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>

      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div class="alertContainerText<xsl:value-of select="$linkClass" />"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:value-of select="./@title" disable-output-escaping="yes"/><br/>
        <div class="time"><xsl:value-of select="./@timestamp"/></div>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:choose>
        <xsl:when test="$isAdmin='' and ./@type='VENDOR_DAEMON_DOWN' or $isAdmin='' and ./@type='VENDOR_DAEMON_COULD_NOT_START'">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:when>
        <xsl:when test="starts-with(./@type, 'ACTIVATION') or starts-with(./@type, 'OVERDRAFT')">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:when>
        <xsl:when test="starts-with(./@type, 'CONCURRENT')">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:when>
      </xsl:choose>
      <div class="alertContainerDelete"><xsl:if test="$isAdmin=''"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/dashboard?event=dismiss&amp;id=<xsl:value-of select="./@id"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"><xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:if test="$compliance508='TRUE'"><xsl:value-of select="extensions:getString('IDS_DELETE_LINK')" disable-output-escaping="yes"/></xsl:if><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if></div>
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
  </xsl:template>
  
  <xsl:template name="importantItem" match="//fnplm:alert[@level='IMPORTANT']">
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div class="alertContainer<xsl:if test="./@type='CONCURRENT_EXPIRE_THRESHOLD' or ./@type='CONCURRENT_VERSION_EXPIRE'">NoLink</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:choose>
        <xsl:when test="$compliance508!='TRUE'">
          <xsl:choose>
            <xsl:when test="./@type='CONCURRENT_EXPIRE_THRESHOLD' or ./@type='CONCURRENT_VERSION_EXPIRE'"></xsl:when>
            <xsl:when test="starts-with(./@type, 'ACTIVATION') or starts-with(./@type, 'OVERDRAFT')">
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a onclick="javascript:NewWindow('fulfillments?vendor=<xsl:value-of select="./@vendor"/>&amp;productId=<xsl:value-of select="./@entitlementID"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>', 'FlexNet', '650','600','yes','yes');" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            </xsl:when>
            <xsl:when test="starts-with(./@type, 'CONCURRENT')">
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a onclick="javascript:NewWindow('concurrenthosts?vendor=<xsl:value-of select="./@vendor"/>&amp;feature=<xsl:value-of select="./@feature"/>&amp;version=<xsl:value-of select="./@version"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>', 'FlexNet', '650','600','yes','yes');" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            </xsl:when>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="./@type='CONCURRENT_EXPIRE_THRESHOLD' or ./@type='CONCURRENT_VERSION_EXPIRE'"></xsl:when>
            <xsl:when test="starts-with(./@type, 'ACTIVATION')">
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/fulfillments?vendor=<xsl:value-of select="./@vendor"/>&amp;productId=<xsl:value-of select="./@entitlementID"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" target="_blank" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            </xsl:when>
            <xsl:when test="starts-with(./@type, 'CONCURRENT')">
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/concurrenthosts?vendor=<xsl:value-of select="./@vendor"/>&amp;feature=<xsl:value-of select="./@feature"/>&amp;version=<xsl:value-of select="./@version"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" target="_blank" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            </xsl:when>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div class="alertContainerText<xsl:if test="./@type='CONCURRENT_EXPIRE_THRESHOLD' or ./@type='CONCURRENT_VERSION_EXPIRE'">NoLink</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:value-of select="./@title" disable-output-escaping="yes"/><br/>
        <div class="time"><xsl:value-of select="./@timestamp"/></div>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:choose>
        <xsl:when test="./@type='CONCURRENT_EXPIRE_THRESHOLD' or ./@type='CONCURRENT_VERSION_EXPIRE'"></xsl:when>
        <xsl:otherwise><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:otherwise>
      </xsl:choose>
      <div class="alertContainerDelete"><xsl:if test="$isAdmin=''"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/dashboard?event=dismiss&amp;id=<xsl:value-of select="./@id"/>&amp;selected=1<xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"><xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:if test="$compliance508='TRUE'"><xsl:value-of select="extensions:getString('IDS_DELETE_LINK')" disable-output-escaping="yes"/></xsl:if><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if></div>
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
  </xsl:template>
  
  <xsl:template name="minorItem" match="//fnplm:alert[@level='MINOR']">
    <div class="alertContainer">
      <xsl:choose>
        <xsl:when test="$compliance508!='TRUE'">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a onclick="javascript:NewWindow('fulfillments?vendor=<xsl:value-of select="./@vendor"/>&amp;productId=<xsl:value-of select="./@entitlementID"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>', 'FlexNet', '650','600','yes','yes');" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/fulfillments?vendor=<xsl:value-of select="./@vendor"/>&amp;productId=<xsl:value-of select="./@entitlementID"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" target="_blank" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      <div class="alertContainerText">
        <xsl:value-of select="/@title" disable-output-escaping="yes"/><br/>
        <div class="time"><xsl:value-of select="./@timestamp"/></div>
      </div>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <div class="alertContainerDelete"><xsl:if test="$isAdmin=''"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/dashboard?event=dismiss&amp;id=<xsl:value-of select="./@id"/>&amp;selected=2<xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"><xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:if test="$compliance508='TRUE'"><xsl:value-of select="extensions:getString('IDS_DELETE_LINK')" disable-output-escaping="yes"/></xsl:if><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if></div>
    </div>
  </xsl:template>
</xsl:stylesheet>
