<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:include href="localUserTable.xsl"/>
  <xsl:include href="importedUserTable.xsl" />
  
  <xsl:param name="userName"><xsl:value-of select="//fnplm:input/@userName"/></xsl:param>
  <xsl:param name="firstName"><xsl:value-of select="//fnplm:input/@firstName"/></xsl:param>
  <xsl:param name="lastName"><xsl:value-of select="//fnplm:input/@lastName"/></xsl:param>
  <xsl:param name="password"><xsl:value-of select="//fnplm:input/@password2"/></xsl:param>
  <xsl:param name="confirm"><xsl:value-of select="//fnplm:input/@confirm"/></xsl:param>
  <xsl:param name="accountType"><xsl:value-of select="//fnplm:input/@accountType"/></xsl:param>
  <xsl:param name="originalAccountType"><xsl:value-of select="//fnplm:input/@originalAccountType"/></xsl:param>
  <xsl:param name="save"><xsl:value-of select="//fnplm:input/@Save"/></xsl:param>
  <xsl:param name="create"><xsl:value-of select="//fnplm:input/@Create"/></xsl:param>
  <xsl:param name="event"><xsl:value-of select="//fnplm:input/@event"/></xsl:param>
  <xsl:param name="passwordExpired"><xsl:value-of select="//fnplm:input/@passwordExpired"/></xsl:param>
  <xsl:param name="userType"><xsl:value-of select="//fnplm:input/@userType"/></xsl:param>
  <xsl:param name="checksum"><xsl:value-of select="//fnplm:input/@checksum"/></xsl:param>
  <xsl:param name="licenseTab"><xsl:value-of select="extensions:getEnv('licenseTab')" disable-output-escaping="yes" /></xsl:param>
  <xsl:param name="selected"><xsl:value-of select="extensions:getEnv('selected')" disable-output-escaping="yes" /></xsl:param>
  <xsl:variable name="noMatch">
    <xsl:if test="$password!=$confirm">TRUE</xsl:if>
  </xsl:variable>

  <xsl:template name="adminUsers">
    <link rel="stylesheet" href="resources/tabber.css" TYPE="text/css" MEDIA="screen"/>
    <script type="text/javascript">
        /*==================================================
        Set the tabber options (must do this before including tabber.js)
        ==================================================*/
        var tabberOptions = {

          'cookie':"user_type_lmgrd", /* Name to use for the cookie */

          'onLoad': function(argsObj)
          {
            var t = argsObj.tabber;
            var i;

            /* If a cookie was previously set, restore the active tab */
            i = parseInt(getCookie(t.cookie));
            if (isNaN(i)) { return; }
            t.tabShow(i);
          },

          'onClick':function(argsObj)
          {
            var c = argsObj.tabber.cookie;
            var i = argsObj.index;
            setCookie(c, i);
          }
        };

        /*==================================================
        Cookie functions
        ==================================================*/
        function setCookie(name, value, expires, path, domain, secure) {
            document.cookie= name + "=" + escape(value) +
                ((expires) ? "; expires=" + expires.toGMTString() : "") +
                ((path) ? "; path=" + path : "") +
                ((domain) ? "; domain=" + domain : "");
        }

        function getCookie(name) {
            var dc = document.cookie;
            var prefix = name + "=";
            var begin = dc.indexOf("; " + prefix);
            if (begin == -1) {
                begin = dc.indexOf(prefix);
                if (begin != 0) return null;
            } else {
                begin += 2;
            }
            var end = document.cookie.indexOf(";", begin);
            if (end == -1) {
                end = dc.length;
            }
            return unescape(dc.substring(begin + prefix.length, end));
        }
		
        function deleteCookie(name, path, domain) {
            if (getCookie(name)) {
                document.cookie = name + "=" +
                    ((path) ? "; path=" + path : "") +
                    ((domain) ? "; domain=" + domain : "") +
                    "; expires=Thu, 01-Jan-70 00:00:01 GMT";
            }
        }
    </script>
    <script type="text/javascript" src="resources/tabber.js"></script>
    
    <xsl:variable name="protectDashboard">
       <xsl:value-of select="extensions:getPreference('protectDashboard')" disable-output-escaping="yes"/>
    </xsl:variable>
    <xsl:variable name="message">
      <xsl:choose>
        <xsl:when test="$event='delete'">
          <xsl:variable name="removeReturn">
            <xsl:value-of select="extensions:removeUser($userName, $checksum)" disable-output-escaping="yes" />
          </xsl:variable>
          
          <xsl:choose>
            <xsl:when test="starts-with($removeReturn, 'ERROR_EXPIRED_SESSION:')">ERROR_EXPIRED_SESSION</xsl:when>
            <xsl:when test="$removeReturn=''">USER_DELETED</xsl:when>
            <xsl:when test="substring-after($removeReturn, ':')!=''">
              <xsl:value-of select="substring-after($removeReturn, ':')"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="$removeReturn"/></xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="$save!=''">
          <xsl:variable name="setReturn">
            <xsl:choose>
              <xsl:when test="$noMatch!='TRUE'">
                <xsl:value-of select="extensions:setUserNames($userName, $firstName, $lastName, $checksum)" disable-output-escaping="yes" />
              </xsl:when>
              <xsl:otherwise>IDS_PASSWORD_MISMATCH_ERROR</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
        
          <xsl:variable name="updateReturn">
            <xsl:if test="$setReturn=''">
              <xsl:if test="$password!=''">
                <xsl:value-of select="extensions:setUserPassword($userName, $password, $checksum)" disable-output-escaping="yes" />
              </xsl:if>
              <xsl:value-of select="extensions:addUserPrivilege($userName, $accountType, $userType, $checksum)" disable-output-escaping="yes" />
              
              <xsl:if test="$accountType != $originalAccountType">
                <xsl:choose>
                  <xsl:when test="$accountType='admin'">
                    <xsl:value-of select="extensions:removeUserPrivilege($userName, 'admin.readonly', $checksum)" disable-output-escaping="yes" />
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="extensions:removeUserPrivilege($userName, 'admin', $checksum)" disable-output-escaping="yes" />
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
            </xsl:if>
          </xsl:variable>
          
          <xsl:variable name="setUserPasswordExpiredReturn">
            <xsl:if test="$setReturn='' and $updateReturn=''">
              <xsl:choose>
                <xsl:when test="$passwordExpired='true'">
                  <xsl:value-of select="extensions:setUserPasswordExpired($userName, 'true', $checksum)" disable-output-escaping="yes" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="extensions:setUserPasswordExpired($userName, 'false', $checksum)" disable-output-escaping="yes" />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
          </xsl:variable>
        
          <xsl:choose>
            <xsl:when test="substring-after($setReturn, ':')!=''">
              <xsl:value-of select="substring-after($setReturn, ':')"/>
            </xsl:when>
            <xsl:when test="substring-after($updateReturn, ':')!=''">
              <xsl:value-of select="substring-after($updateReturn, ':')"/>
            </xsl:when>
            <xsl:when test="substring-after($setUserPasswordExpiredReturn, ':')!=''">
              <xsl:value-of select="substring-after($setUserPasswordExpiredReturn, ':')"/>
            </xsl:when>
            <xsl:when test="$setReturn='IDS_PASSWORD_MISMATCH_ERROR'"><L10>IDS_PASSWORD_MISMATCH_ERROR</L10></xsl:when>
            <xsl:when test="$setReturn!=''">
              <xsl:value-of select="$setReturn"/>
            </xsl:when>
            <xsl:when test="$updateReturn!=''">
              <xsl:value-of select="$updateReturn"/>
            </xsl:when>
            <xsl:when test="$setUserPasswordExpiredReturn!=''">
              <xsl:value-of select="$setUserPasswordExpiredReturn"/>
            </xsl:when>
            <xsl:otherwise>USER_UPDATED</xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="$create!=''">
          <xsl:variable name="addReturn">
              <xsl:value-of select="extensions:addUser($userName, $password, $firstName, $lastName, $userType, $checksum)" disable-output-escaping="yes" />
          </xsl:variable>
          
          <xsl:if test="$addReturn=''"> 
              <xsl:value-of select="extensions:addUserPrivilege($userName, $accountType, $userType, $checksum)" disable-output-escaping="yes" />
              <xsl:choose>
                <xsl:when  test="$passwordExpired='true'">
                  <xsl:value-of select="extensions:setUserPasswordExpired($userName, 'true', $checksum)" disable-output-escaping="yes" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="extensions:setUserPasswordExpired($userName, 'false', $checksum)" disable-output-escaping="yes" />
                </xsl:otherwise>
              </xsl:choose>
          </xsl:if>
        
          <xsl:choose>
            <xsl:when test="substring-after($addReturn, ':')!=''">
              <xsl:value-of select="substring-after($addReturn, ':')"/>
            </xsl:when>
            <xsl:when test="$addReturn=''">USER_ADDED</xsl:when>
            <xsl:otherwise><xsl:value-of select="$addReturn"/></xsl:otherwise>
          </xsl:choose>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="$message='ERROR_EXPIRED_SESSION'">
      <xsl:call-template name="sessionTimeout"/>
    </xsl:if>
    
    <xsl:if test="$event!='edit' and $event!='create'">
      <h1><xsl:value-of select="extensions:getString('IDS_USERS_HEADER')" disable-output-escaping="yes"/></h1>
      <xsl:choose>
        <xsl:when test="$message='USER_ADDED'">
          <font color="#6CBE06"><b>
            <xsl:value-of select="extensions:getString('IDS_USER_ADDED')" disable-output-escaping="yes"/>
          </b></font>
        </xsl:when>
        <xsl:when test="$message='USER_UPDATED'">
          <font color="#6CBE06"><b>
            <xsl:value-of select="extensions:getString('IDS_USER_UPDATED')" disable-output-escaping="yes"/>
          </b></font>
        </xsl:when>
        <xsl:when test="$message='USER_DELETED'">
          <font color="#6CBE06"><b>
            <xsl:value-of select="extensions:getString('IDS_USER_DELETED')" disable-output-escaping="yes"/>
          </b></font>
        </xsl:when>
        <xsl:when test="$message!=''">
          <font color="#CC0000"><b>
            <xsl:copy-of select="$message" />
          </b></font>
        </xsl:when>
        <xsl:otherwise><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></xsl:otherwise>
      </xsl:choose>
      <div class="giveBorder">
        <div class="columnBlockClick">
          <div class="columnBlockButton" >
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a onmouseover="rollover('addUser','images/icons/60addUserOver.gif');" onmouseout="rollover('addUser','images/icons/60addUserOut.gif');" href="/users?event=create&amp;licenseTab=<xsl:value-of select="$licenseTab"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
              <img src="images/icons/60addUserOut.gif" name="addUser" />
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            <br />
            <div class="largerText"><strong><xsl:value-of select="extensions:getString('IDS_NEW_USER_LABEL')" disable-output-escaping="yes"/></strong></div>
          </div>
        </div>
      </div>
      <br/>

      <div class="tabber">
        <xsl:variable name="userCount">
            <xsl:value-of select="extensions:getUserList('xslt/localUserCount.xsl')" disable-output-escaping="yes" />
        </xsl:variable>
        <xsl:if test="$userCount > 0">
            <div class="tabbertab">
            <h3 class="display">
                <xsl:value-of select="extensions:getString('IDS_LOCALLY_MANAGED_USERS_LIST')" disable-output-escaping="yes"/>
            </h3>
            <xsl:call-template name="localTable"/>
            </div>
        </xsl:if>
        <xsl:variable name="importedUserCount">
            <xsl:value-of select="extensions:getUserList('xslt/importedUserCount.xsl')" disable-output-escaping="yes" />
        </xsl:variable>
        <xsl:if test="$importedUserCount > 0">

            <div class="tabbertab">
            <h3 class="display">
                    <xsl:value-of select="extensions:getString('IDS_DOMAIN_USERS_LIST')" disable-output-escaping="yes"/>
            </h3>
            <xsl:call-template name="importedUserTable"/>
            </div>
        </xsl:if>
    </div>
   </xsl:if>
  
    <xsl:if test="$event='edit' or $event='create'">
      <h1>
        <xsl:choose>
          <xsl:when test="$event='edit'"><xsl:value-of select="extensions:getString('IDS_EDIT_USER_NAME_LABEL')" disable-output-escaping="yes"/></xsl:when>
          <xsl:otherwise><xsl:value-of select="extensions:getString('IDS_CREATE_USER_NAME_LABEL')" disable-output-escaping="yes"/></xsl:otherwise>
        </xsl:choose>
      </h1>    
      <script type="text/javascript">
            function selectMenu() {              
                var listValue = document.userform.userType.value;
                if (listValue=="local-user" || listValue=="local-admin") {
                    document.getElementById("UserField").style.visibility="visible";
                    document.getElementById("OtherField").style.visibility="visible";
                }
                if (listValue=="domain-user" || listValue=="domain-user-group" || listValue=="domain-admin" || listValue=="domain-admin-group") {
                    document.getElementById("UserField").style.visibility="visible";
                    document.getElementById("OtherField").style.visibility="hidden";
                }
                if (listValue=="local-user" || listValue=="domain-user" || listValue=="domain-user-group" )  {
                    document.userform.accountType.value = "admin.readonly";
                }
                else if (listValue=="local-admin" || listValue=="domain-admin" || listValue=="domain-admin-group")   {
                    document.userform.accountType.value = "admin";
                }                 
            }
      </script>
      <script type="text/javascript">
            function startup(type, mode, protectDash) {    
                if (mode=='edit')  {
                     document.userform.userType.value = type;
                }
                else if (mode=="create")  {
                    if (protectDash=='false')  {
                        document.userform.accountType.value = "admin";
                    }
                    else  {
                        document.userform.accountType.value = "admin.readonly";
                    }
                }
                if (type == "local-user" || type=="local-admin") {
                    document.getElementById("UserField").style.visibility="visible";
                    document.getElementById("OtherField").style.visibility="visible";
                }
                if (type=="domain-user" || type=="domain-user-group" || type=="domain-admin" || type=="domain-admin-group") {
                    document.getElementById("UserField").style.visibility="visible";
                    document.getElementById("OtherField").style.visibility="hidden";
                }
           }
      </script>
      <script language="javascript">
          function checkPassword(create) {            
            var errors = false;
            var errorString;
            var userType = document.userform.userType.value;
            var userName = document.userform.elements.userName.value.trim();
            if (create) {
              errorString =  "<xsl:value-of select="extensions:getString('IDS_USER_CREATE_ERRORS')" disable-output-escaping="yes"/>";
            } else {
              errorString =  "<xsl:value-of select="extensions:getString('IDS_USER_SAVE_ERRORS')" disable-output-escaping="yes"/>";
            }
            if (userType == "local-user" || userType == "local-admin") {   
                if (userName == "") {
                  errorString += "\n - <xsl:value-of select="extensions:getString('IDS_CREATE_USER_NAME_BLANK_ERROR')" disable-output-escaping="yes"/>";
                  errors = true;
                }          
                var passw_pattern =  /(?=.*).{8,}/;
                if (document.userform.elements["password2"].value == "" &amp;&amp; create) {
                  errorString += "\n - <xsl:value-of select="extensions:getString('IDS_CREATE_PASSWORD_BLANK_ERROR')" disable-output-escaping="yes"/>";
                  errors = true;
                } else if (!passw_pattern.test(document.userform.elements["password2"].value)) {
                  errorString += "\n - <xsl:value-of select="extensions:getString('IDS_NEW_PASSWORD_PATTERN_MISMATCH_ERROR')" disable-output-escaping="yes"/>";
                  errors = true;
                } else if (document.userform.elements["password2"].value.toUpperCase() == userName.toUpperCase() ) {
                  errorString += "\n - <xsl:value-of select="extensions:getString('IDS_PASSWORD_SAME_AS_USER_ERROR')" disable-output-escaping="yes"/>";
                  errors = true;
                } else if (document.userform.elements["password2"].value !=
                  document.userform.elements["confirm"].value) {
                  errorString += "\n - <xsl:value-of select="extensions:getString('IDS_CREATE_PASSWORD_MISMATCH_ERROR')" disable-output-escaping="yes"/>";
                  errors = true;
                }
                if (userName.indexOf("\\") != -1)
                {
                  errorString += "\n - <xsl:value-of select="extensions:getString('IDS_CREATE_USER_NAME_BACKSLASH_ERROR')" disable-output-escaping="yes"/>";
                  errors = true;
                }
                setCookie('user_type_lmgrd', 0);
            }
            else {
                document.userform.elements.userName.value = userName.toUpperCase();
                if (userName.indexOf("\\") == -1)  {
                    errorString += "\n - <xsl:value-of select="extensions:getString('IDS_USER_TYPE_DOMAIN_USER_ERROR')" disable-output-escaping="yes"/>";
                    errors = true;
                }
                setCookie('user_type_lmgrd', 1);
            }
            if (errors) {
              alert(errorString);
              return false;
            }         
            return true;
          }
      </script>
      <form action="/users" method="post" name="userform">
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="licenseTab" value="<xsl:value-of select="$licenseTab"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="selected" value="<xsl:value-of select="$selected"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>

        <br></br>
        <xsl:if test="$compliance508='TRUE'">
          <input type="hidden" name="compliance508" value="TRUE"/>
        </xsl:if>
        <table><tr><td>

        <div class="Container840">
           <div class="asterisk">*</div>
           <xsl:value-of select="extensions:getString('IDS_ACCOUNT_TYPE_LABEL')" disable-output-escaping="yes"/><br />
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>select name = userType onfocus="startup('<xsl:value-of select="$userType"/>', '<xsl:value-of select="$event"/>', '<xsl:value-of select="$protectDashboard"/>')" onChange="selectMenu()"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <xsl:if test="$protectDashboard='true'">
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>optgroup label="<xsl:value-of select="extensions:getString('IDS_DASHBOARD_LABEL')" disable-output-escaping="yes"/>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>option value = local-user<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_USER_TYPE_LOCAL_USER')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/option<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>option value = domain-user<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_USER_TYPE_DOMIAIN_USER')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/option<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>option value = domain-user-group<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_USER_TYPE_DOMIAIN_USER_GROUP')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/option<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/optgroup<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>optgroup label="<xsl:value-of select="extensions:getString('IDS_ADMIN_LABEL')" disable-output-escaping="yes"/>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                </xsl:if>
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>option value = local-admin<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_USER_TYPE_LOCAL_ADMIN')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/option<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>option value = domain-admin<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_USER_TYPE_DOMIAIN_ADMIN')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/option<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>option value = domain-admin-group<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_USER_TYPE_DOMIAIN_ADMIN_GROUP')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/option<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                <xsl:if test="$protectDashboard='true'">
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/optgroup<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                </xsl:if>
           <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/select<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br /><br/>
           <span id="UserField">
           <div class="asterisk">*</div>
            <label for="user"><xsl:value-of select="extensions:getString('IDS_USER_NAME_LABEL')" disable-output-escaping="yes"/></label><br />
            <xsl:choose>
              <xsl:when test="$event='edit'">
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="user" value="<xsl:value-of select="$userName"/>" class="textField" DISABLED /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br />
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="userName" value="<xsl:value-of select="$userName"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="user" name="userName" value="" class="textField" maxlength="64" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br />
              </xsl:otherwise>
            </xsl:choose>
            </span>
            <span id="OtherField">
            <div class="divider"><NBAP/></div><br />
            <label for="first"><xsl:value-of select="extensions:getString('IDS_FIRST_NAME_LABEL')" disable-output-escaping="yes"/></label><br />
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="first" name="firstName" value="<xsl:if test="$event='edit'"><xsl:value-of select="$firstName"/></xsl:if>" class="textField" maxlength="32" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br />
            <div class="divider"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
            <label for="last"><xsl:value-of select="extensions:getString('IDS_LAST_NAME_LABEL')" disable-output-escaping="yes"/></label><br />
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="last" name="lastName" value="<xsl:if test="$event='edit'"><xsl:value-of select="$lastName"/></xsl:if>" class="textField" maxlength="32" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br />
            <div class="divider"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
            <div class="asterisk">*</div><label for="pass"><xsl:value-of select="extensions:getString('IDS_PASSWORD_LABEL')" disable-output-escaping="yes"/></label><br />
            <input type="password" size="20" id="pass" name="password2" value="" class="textField" maxlength="32" /><br />
            <div class="asterisk">*</div><label for="confirm"><xsl:value-of select="extensions:getString('IDS_CONFIRM_PASSWORD_LABEL')" disable-output-escaping="yes"/></label><br />
            <input type="password" size="20" id="confirm" name="confirm" value="" class="textField" maxlength="32" /><br />
            <div class="divider"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="accountType" value="<xsl:value-of select="$accountType"/>" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="passwordExpired" <xsl:if test="$passwordExpired='true'">CHECKED</xsl:if> value="true"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_PASSWORD_EXPIRED_LABEL')" disable-output-escaping="yes"/><br />
             <div class="divider"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
            </span>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="checksum" value="<xsl:value-of select="extensions:setChecksum('userform')"/>"  /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            <div id="buttons" style="float: right;">
              <xsl:choose>
                <xsl:when test="$event!='edit'">
                  <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Create" value="<xsl:value-of select="extensions:getString('IDS_CREATE_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" onClick="return checkPassword(true)" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Save" value="<xsl:value-of select="extensions:getString('IDS_SAVE_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'"  onClick="return checkPassword(false)"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Cancel" value="<xsl:value-of select="extensions:getString('IDS_CANCEL_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            </div>
          </div>
        </td></tr></table>
      </form>
    </xsl:if>
    
    <xsl:if test="$event='edit'">
      <script type="text/javascript">
        document.userform.userType.focus();
      </script>
    </xsl:if>

    <xsl:if test="$event='create'">
      <script type="text/javascript">
        document.userform.userType.focus();
      </script>
    </xsl:if>
 
  </xsl:template>
</xsl:stylesheet>
