<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
	<xsl:param name="compliance508">
		<xsl:value-of select="extensions:getEnv('compliance508')" disable-output-escaping="yes"/>
	</xsl:param>
	<xsl:param name="licenseTab">
		<xsl:value-of select="extensions:getEnv('licenseTab')" disable-output-escaping="yes"/>
	</xsl:param>
	<xsl:param name="selected">
		<xsl:value-of select="extensions:getEnv('selected')" disable-output-escaping="yes"/>
	</xsl:param>
	<xsl:param name="webSecurePort">
		<xsl:value-of select="//fnplm:input/@websecureport"/>
	</xsl:param>
	<xsl:param name="httpsEnabled">
	  <xsl:choose>
	    <xsl:when test="$webSecurePort > 0">true</xsl:when>
	    <xsl:otherwise>false</xsl:otherwise>
	  </xsl:choose>
	</xsl:param>
	<xsl:template match="/" name="adminSystemForm">
		<script language="javascript">
      function submitSystemConfigForm(formAction, eventParam) {
        if (eventParam == 'stop') {
          if (!confirm("<xsl:value-of select="extensions:getString('IDS_CONFIRM_STOP')" disable-output-escaping="yes"/>")) {
            return false;
          }
        }
      
        if (eventParam == 'update') {
        
          var errors = false;
          var errorString =  "<xsl:value-of select="extensions:getString('IDS_CONFIG_ERRORS')" disable-output-escaping="yes"/>";
        
          if (!document.savelicconfig.webport.value.match(/^\d+$/) || document.savelicconfig.webport.value <xsl:text disable-output-escaping="yes">&gt;</xsl:text> 65535 ||
              document.savelicconfig.webport.value <xsl:text disable-output-escaping="yes">&lt;</xsl:text> 0) {
            errorString += "\n - <xsl:value-of select="extensions:getString('IDS_HTTP_PORT_INVALID')" disable-output-escaping="yes"/>";
            errors = true;
          }  
        
          if (!document.savelicconfig.webmaxthreads.value.match(/^\d+$/) || document.savelicconfig.webmaxthreads.value <xsl:text disable-output-escaping="yes">&lt;</xsl:text> 1) {
            errorString += "\n - <xsl:value-of select="extensions:getString('IDS_MAX_WEB_THREADS_INVALID')" disable-output-escaping="yes"/>";
            errors = true;
          }
        
          if (!document.savelicconfig.sessiontimeout.value.match(/^\d+$/) || document.savelicconfig.sessiontimeout.value <xsl:text disable-output-escaping="yes">&lt;</xsl:text> 1) {
            errorString += "\n - <xsl:value-of select="extensions:getString('IDS_SESSION_TIMEOUT_INVALID')" disable-output-escaping="yes"/>";
            errors = true;
          }
          
          if ((!document.savelicconfig.port.value.match(/^\d+$/) || document.savelicconfig.port.value <xsl:text disable-output-escaping="yes">&gt;</xsl:text> 65535 ||
              document.savelicconfig.port.value <xsl:text disable-output-escaping="yes">&lt;</xsl:text> 1) <xsl:text disable-output-escaping="yes">&amp;&amp;</xsl:text> document.savelicconfig.defaultPort[1].checked) {
            errorString += "\n - <xsl:value-of select="extensions:getString('IDS_PORT_INVALID')" disable-output-escaping="yes"/>";
            errors = true;
          }
        
          if (!document.savelicconfig.maxprocessthreads.value.match(/^\d+$/) || document.savelicconfig.maxprocessthreads.value <xsl:text disable-output-escaping="yes">&lt;</xsl:text> 1) {
            errorString += "\n - <xsl:value-of select="extensions:getString('IDS_MAX_THREADS_INVALID')" disable-output-escaping="yes"/>";
            errors = true;
          }
        
          if (!document.savelicconfig.maxreceivethreads.value.match(/^\d+$/) || document.savelicconfig.maxreceivethreads.value <xsl:text disable-output-escaping="yes">&lt;</xsl:text> 1) {
            errorString += "\n - <xsl:value-of select="extensions:getString('IDS_MAX_RECEIVE_THREADS_INVALID')" disable-output-escaping="yes"/>";
            errors = true;
          }
        
          if (document.savelicconfig.port.value == document.savelicconfig.webport.value <xsl:text disable-output-escaping="yes">&amp;&amp;</xsl:text> document.savelicconfig.defaultPort[1].checked) {
            errorString += "\n - <xsl:value-of select="extensions:getString('IDS_HTTP_LMRD_PORT_CONFLICT')" disable-output-escaping="yes"/>";
            errors = true;
          }
        
          if (typeof document.savelicconfig.websecureport == "undefined") {
            if (document.savelicconfig.webport.value <xsl:text disable-output-escaping="yes">&lt;</xsl:text> 1) {
              errorString += "\n - <xsl:value-of select="extensions:getString('IDS_NO_WEB_PORT')" disable-output-escaping="yes"/>";
              errors = true;
            }
          }
          else {
            if (document.savelicconfig.webport.value <xsl:text disable-output-escaping="yes">&lt;</xsl:text> 1 <xsl:text disable-output-escaping="yes">&amp;&amp;</xsl:text> !document.savelicconfig.websecureportenabled.checked) {
              errorString += "\n - <xsl:value-of select="extensions:getString('IDS_NO_WEB_PORT')" disable-output-escaping="yes"/>";
              errors = true;
            }

            if ((!document.savelicconfig.websecureport.value.match(/^\d+$/) || document.savelicconfig.websecureport.value <xsl:text disable-output-escaping="yes">&gt;</xsl:text> 65535 ||
                document.savelicconfig.websecureport.value <xsl:text disable-output-escaping="yes">&lt;</xsl:text> 1) <xsl:text disable-output-escaping="yes">&amp;&amp;</xsl:text> document.savelicconfig.websecureportenabled.checked) {
              errorString += "\n - <xsl:value-of select="extensions:getString('IDS_HTTPS_PORT_INVALID')" disable-output-escaping="yes"/>";
              errors = true;
            }

            if (document.savelicconfig.port.value == document.savelicconfig.websecureport.value <xsl:text disable-output-escaping="yes">&amp;&amp;</xsl:text> document.savelicconfig.defaultPort[1].checked <xsl:text disable-output-escaping="yes">&amp;&amp;</xsl:text> document.savelicconfig.websecureportenabled.checked) {
              errorString += "\n - <xsl:value-of select="extensions:getString('IDS_HTTPS_LMRD_PORT_CONFLICT')" disable-output-escaping="yes"/>";
              errors = true;
            }

            if (document.savelicconfig.webport.value == document.savelicconfig.websecureport.value <xsl:text disable-output-escaping="yes">&amp;&amp;</xsl:text> document.savelicconfig.websecureportenabled.checked) {
              errorString += "\n - <xsl:value-of select="extensions:getString('IDS_HTTP_HTTPS_PORT_CONFLICT')" disable-output-escaping="yes"/>";
              errors = true;
            }

            if (document.savelicconfig.websecureportenabled.checked <xsl:text disable-output-escaping="yes">&amp;&amp;</xsl:text> 
                document.savelicconfig.webcertfile.value.trim() == '') {
              errorString += "\n - <xsl:value-of select="extensions:getString('IDS_CERTIFICATE_FILE_REQUIRED')" disable-output-escaping="yes"/>";
              errors = true;
            }

            if (document.savelicconfig.websecureportenabled.checked <xsl:text disable-output-escaping="yes">&amp;&amp;</xsl:text> 
                document.savelicconfig.webcertkeyfile.value.trim() == '') {
              errorString += "\n - <xsl:value-of select="extensions:getString('IDS_CERTIFICATE_KEY_FILE_REQUIRED')" disable-output-escaping="yes"/>";
              errors = true;
            }
          }
        
          if (errors) {
            alert(errorString);
            return false;
          }
        }
        
        document.savelicconfig.elements["event"].value = eventParam;
        if (formAction != "") {
          document.savelicconfig.action = formAction;
        }
        
        document.savelicconfig.submit();
        
        return false;	
      }
      
      function toggleHTTPSFields() {
	    var disabled = true;
        if (document.savelicconfig.websecureportenabled.checked) {
          disabled = false;
        }
        document.savelicconfig.websecureport.disabled = disabled ;
        document.savelicconfig.webcertfile.disabled  = disabled ;
        document.savelicconfig.webcertkeyfile.disabled  = disabled ;
        document.savelicconfig.webcertchainfile.disabled  = disabled ;
        document.savelicconfig.webredirecthttp.disabled = disabled;
      }
    </script>
		<form action="/savelicconfig" method="post" name="savelicconfig" enctype="multipart/form-data" id='looseCheck'>
			<input type="hidden" name="event"/>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="checksum" value="<xsl:value-of select="extensions:setChecksum('savelicconfig')"/>" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="licenseTab" value="<xsl:value-of select="$licenseTab"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="selected" value="<xsl:value-of select="$selected"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
			<xsl:if test="$compliance508='TRUE'">
				<input type="hidden" name="compliance508" value="TRUE"/>
			</xsl:if>
			<xsl:if test="//fnplm:input/@showStopServer='true'">
				<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="button" name="StopServer" value="<xsl:value-of select="extensions:getString('IDS_STOP_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" style="width: 100px;" onClick="return submitSystemConfigForm('/savelicconfig', 'stop')" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
			</xsl:if>
      <xsl:if test="$httpsEnabled='true'">
        <input type="hidden" name="waswebsecureportenabled" value="TRUE"/>
      </xsl:if>
			<br/>
			<br/>
			<table cellpadding="0" width="850" height="460">
				<tr valign="top">
					<td>
						<div id="accordionContent">
							<h3 class="display">
								<a href="#General">
									<xsl:value-of select="extensions:getString('IDS_GENERAL_HEADER')" disable-output-escaping="yes"/>
								</a>
							</h3>
							<div class="stretcher">
								<div class="dividerEmpty">
									<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								</div>
								<strong>
									<div class="asterisk">*</div>
									<label for="http">
										<xsl:value-of select="extensions:getString('IDS_HTTP_PORT_LABEL')" disable-output-escaping="yes"/>
									</label>
								</strong>
								<br/>
								<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="http" name="webport" value="<xsl:value-of select="//fnplm:input/@webport"/>" class="textField" maxlength="5" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
								<br/>
								<div class="divider">
									<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								</div>
								<strong>
									<div class="asterisk">*</div>
									<label for="webmaxthreads">
										<xsl:value-of select="extensions:getString('IDS_WEB_MAX_THREADS_LABEL')" disable-output-escaping="yes"/>
									</label>
								</strong>
								<br/>
								<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="webmaxthreads" name="webmaxthreads" value="<xsl:value-of select="//fnplm:input/@webmaxthreads"/>" class="textField" maxlength="3" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
								<br/>
								<div class="divider">
									<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								</div>
								<strong>
									<div class="asterisk">*</div>
									<label for="session">
										<xsl:value-of select="extensions:getString('IDS_SESSION_TIMEOUT_LABEL')" disable-output-escaping="yes"/>
									</label>
								</strong>
								<br/>
								<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="session" name="sessiontimeout" value="<xsl:value-of select="//fnplm:input/@sessiontimeout"/>" class="textField" maxlength="5" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
								<br/>
							</div>
							<xsl:if test="$webSecurePort!=''">
								<h3 class="display">
									<a href="#HTTPS">
										<xsl:value-of select="extensions:getString('IDS_HTTPS_HEADER')" disable-output-escaping="yes"/>
									</a>
								</h3>
								<div class="stretcher">
									<div class="dividerEmpty">
										<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
									</div>
									<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" id="websecureportenabled" name="websecureportenabled" <xsl:if test="$httpsEnabled='true'">CHECKED </xsl:if>onClick="toggleHTTPSFields();" value="true"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
									<xsl:value-of select="extensions:getString('IDS_HTTPS_ENABLED_LABEL')" disable-output-escaping="yes"/>
									<br/>
									<div class="divider">
										<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
									</div>
									<strong>
										<div class="asterisk">*</div>
										<label for="websecureport">
											<xsl:value-of select="extensions:getString('IDS_HTTPS_PORT_LABEL')" disable-output-escaping="yes"/>
										</label>
									</strong>
									<br/>
									<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="websecureport" name="websecureport" value="<xsl:value-of select="//fnplm:input/@websecureport"/>" class="textField" <xsl:if test="$httpsEnabled!='true' and $compliance508!='TRUE'">DISABLED </xsl:if> maxlength="5" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
									<br/>
									<div class="divider">
										<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
									</div>
									<strong>
										<div class="asterisk">*</div>
										<label for="webcertfile">
											<xsl:value-of select="extensions:getString('IDS_CERTIFICATE_PATH_LABEL')" disable-output-escaping="yes"/>
										</label>
									</strong>
									<br/>
									<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="webcertfile" name="webcertfile" value="<xsl:value-of select="extensions:xssEscape(//fnplm:input/@webcertfile)" disable-output-escaping="yes" />" class="textField" <xsl:if test="$httpsEnabled!='true' and $compliance508!='TRUE'">DISABLED </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
									<br/>
									<div class="divider">
										<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
									</div>
									<strong>
										<div class="asterisk">*</div>
										<label for="webcertkeyfile">
											<xsl:value-of select="extensions:getString('IDS_CERTIFICATE_KEY_PATH_LABEL')" disable-output-escaping="yes"/>
										</label>
									</strong>
									<br/>
									<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="webcertkeyfile" name="webcertkeyfile" value="<xsl:value-of select="extensions:xssEscape(//fnplm:input/@webcertkeyfile)" disable-output-escaping="yes" />" class="textField" <xsl:if test="$httpsEnabled!='true' and $compliance508!='TRUE'">DISABLED </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
									<br/>
									<div class="divider">
										<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
									</div>
									<strong>
										<label for="webcertchainfile">
											<xsl:value-of select="extensions:getString('IDS_CERTIFICATE_CHAIN_PATH_LABEL')" disable-output-escaping="yes"/>
										</label>
									</strong>
									<br/>
									<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="webcertchainfile" name="webcertchainfile" value="<xsl:value-of select="extensions:xssEscape(//fnplm:input/@webcertchainfile)" disable-output-escaping="yes" />" class="textField" <xsl:if test="$httpsEnabled!='true' and $compliance508!='TRUE'">DISABLED </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
									<br/>
                  
									<div class="divider"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
                  
									<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" id="webredirecthttp" name="webredirecthttp" <xsl:if test="//fnplm:input/@webredirecthttp='true'">CHECKED </xsl:if> value="true"  <xsl:if test="$httpsEnabled!='true' and $compliance508!='TRUE'">DISABLED </xsl:if><xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_REDIRECT_HTTP_LABEL')" disable-output-escaping="yes"/><br/>
								</div>
							</xsl:if>
							<h3 class="display">
								<a href="#ServerConfiguration">
									<xsl:value-of select="extensions:getString('IDS_LICENSE_SERVER_CONFIGURATION_HEADER')" disable-output-escaping="yes"/>
								</a>
							</h3>
							<div class="stretcher">
								<div class="dividerEmpty">
									<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								</div>
								<xsl:variable name="licPortValue">
									<xsl:value-of select="//fnplm:input/@port"/>
								</xsl:variable>
								<strong>
									<label>
										<xsl:value-of select="extensions:getString('IDS_LICENSE_PORT_LABEL')" disable-output-escaping="yes"/>
									</label>
								</strong>
								<br/>
								<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="radio" id="defaultPort" name="defaultPort" value="true"<xsl:if test="$licPortValue = 0"> checked</xsl:if>
								<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
								<xsl:value-of select="extensions:getString('IDS_LICENSE_PORT_DEFAULT_OPTION')" disable-output-escaping="yes"/>
								<br/>
								<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="radio" id="customPort" name="defaultPort" value="false"<xsl:if test="$licPortValue != 0"> checked</xsl:if>
								<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
								<xsl:value-of select="extensions:getString('IDS_LICENSE_PORT_OPTION')" disable-output-escaping="yes"/>
								<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="5" name="port" value="<xsl:value-of select="//fnplm:input/@port"/>" class="textField" maxlength="5" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
								<br/>
								<div class="divider">
									<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								</div>
								<strong>
									<div class="asterisk">*</div>
									<label for="maxprocessthreads">
										<xsl:value-of select="extensions:getString('IDS_LICENSE_MAX_THREADS_LABEL')" disable-output-escaping="yes"/>
									</label>
								</strong>
								<br/>
								<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="maxprocessthreads" name="maxprocessthreads" value="<xsl:value-of select="//fnplm:input/@maxprocessthreads"/>" class="textField" maxlength="3" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
								<br/>
								<span class="divider">
									<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								</span>
								<strong>
									<div class="asterisk">*</div>
									<label for="maxreceivethreads">
										<xsl:value-of select="extensions:getString('IDS_LICENSE_MAX_RECEIVE_THREADS_LABEL')" disable-output-escaping="yes"/>
									</label>
								</strong>
								<br/>
								<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="maxreceivethreads" name="maxreceivethreads" value="<xsl:value-of select="//fnplm:input/@maxreceivethreads"/>" class="textField" maxlength="3" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
								<br/>
							</div>
							<h3 class="display">
								<a href="#LOGGING">
									<xsl:value-of select="extensions:getString('IDS_LOGGING_CONFIG_LABEL')" disable-output-escaping="yes"/>
								</a>
							</h3>
							<div class="stretcher">
								<div class="dividerEmpty">
									<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								</div>
								<strong>
									<label for="session">
										<xsl:value-of select="extensions:getString('IDS_LOGGING_LEVEL_LABEL')" disable-output-escaping="yes"/>
									</label>
								</strong>
								<br/>
								<xsl:value-of select="extensions:getLogConfig('root', 'xslt/serverLogLevelDropDown.xsl')" disable-output-escaping="yes"/>
								<br/>
								<xsl:choose>
									<xsl:when test="$compliance508!='TRUE'">
										<xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="#" onclick="javascript:NewWindow('display?log=root', 'FlexNet', '650','600','yes','yes');" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
										<xsl:value-of select="extensions:getString('IDS_VIEW_FILE_EXTERNALLY_LABEL')" disable-output-escaping="yes"/>
										<xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/display?log=root" class="textLink" target="_blank"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
										<xsl:value-of select="extensions:getString('IDS_VIEW_FILE_EXTERNALLY_LABEL')" disable-output-escaping="yes"/>
										<xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
								<div class="dividerEmpty">
									<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								</div>
							</div>
							<h3 class="display">
								<a href="#UI">
									<xsl:value-of select="extensions:getString('IDS_USER_INTERFACE_HEADER')" disable-output-escaping="yes"/>
								</a>
							</h3>
							<div class="stretcher">
								<xsl:variable name="visibleLicenseValue">
									<xsl:variable name="temp">
										<xsl:value-of select="extensions:getPreference('visibleLicense')" disable-output-escaping="yes"/>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="$temp=''">3</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$temp"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<div class="dividerEmpty">
									<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								</div>
								<strong>
									<label>
										<xsl:value-of select="extensions:getString('IDS_LICENSE_TYPE_LABEL')" disable-output-escaping="yes"/>
									</label>
								</strong>
								<br/>
								<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="radio" id="licType" name="visibleLicense" value="1"<xsl:if test="$visibleLicenseValue = 1"> checked</xsl:if>
								<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
								<xsl:value-of select="extensions:getString('IDS_LICENSE_TYPE_LOCKED_OPTION')" disable-output-escaping="yes"/>
								<br/>
								<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="radio" id="licType" name="visibleLicense" value="2"<xsl:if test="$visibleLicenseValue = 2"> checked</xsl:if>
								<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
								<xsl:value-of select="extensions:getString('IDS_LICENSE_TYPE_FLOATING_OPTION')" disable-output-escaping="yes"/>
								<br/>
								<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="radio" id="licType" name="visibleLicense" value="3"<xsl:if test="$visibleLicenseValue = 3"> checked</xsl:if>
								<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
								<xsl:value-of select="extensions:getString('IDS_LICENSE_TYPE_BOTH_OPTION')" disable-output-escaping="yes"/>
								<br/>
								<div class="divider">
									<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
								</div>
								<xsl:variable name="protectDashboardValue">
									<xsl:variable name="temp">
										<xsl:value-of select="extensions:getPreference('protectDashboard')"/>
									</xsl:variable>
									<xsl:choose>
										<xsl:when test="$temp=''">true</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$temp"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="protectDashboard" <xsl:if test="$protectDashboardValue='true'">CHECKED </xsl:if> value="true"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
								<xsl:value-of select="extensions:getString('IDS_PROTECT_DASHBOARD_LABEL')" disable-output-escaping="yes"/>
								<xsl:variable name="localeCount">
									<xsl:value-of select="extensions:getLocaleList('xslt/localeCount.xsl')" disable-output-escaping="yes"/>
								</xsl:variable>
								<xsl:if test="$localeCount > 1">
									<div class="divider">
										<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
									</div>
									<strong>
										<label for="defaultLocale">
											<xsl:value-of select="extensions:getString('IDS_DEFAULT_LOCALE_LABEL')" disable-output-escaping="yes"/>
										</label>
									</strong>
									<br/>
									<xsl:value-of select="extensions:getLocaleList('xslt/localeDefaultDropDown.xsl')" disable-output-escaping="yes"/>
									<script type="text/javascript">
                    for (i = 0; i <xsl:text disable-output-escaping="yes">&lt;</xsl:text> document.savelicconfig.defaultLocale.options.length; i++) {
                      if ("<xsl:value-of select="extensions:getPreference('defaultLocale')"/>" == document.savelicconfig.defaultLocale.options[i].value) {
                        document.savelicconfig.defaultLocale.options[i].selected = true;
                      }
                    }
                  </script>
								</xsl:if>
							</div>
						</div>
						<div align="right">
							<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Save" value="<xsl:value-of select="extensions:getString('IDS_SAVE_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" onClick="return submitSystemConfigForm('/savelicconfig', 'update')" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
							<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
							<xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="button" name="Cancel" value="<xsl:value-of select="extensions:getString('IDS_CANCEL_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" onClick="return submitSystemConfigForm('/savelicconfig', 'cancel')" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
						</div>
					</td>
				</tr>
			</table>
		</form>
	</xsl:template>
</xsl:stylesheet>
