<?xml version="1.0" encoding="UTF-8" ?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:extensions="urn:fnplm:lmadmin" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
<xsl:output method="xml" version="4.01" encoding="UTF-8" omit-xml-declaration="yes"/>
<xsl:output indent="yes"/>

<xsl:param name="entitlementid" select="''"/>
<xsl:param name="pageOffset" select="'-1'"/>
<xsl:param name="sortAttr" select="'@fulfillmentid'"/>
<xsl:param name="pageSize" select="'20'"/>
<xsl:param name="sortDir" select="'ascending'"/>

<xsl:template match="/">
<xsl:variable name="unsortedrows">
    <xsl:apply-templates/>
</xsl:variable>

<xsl:variable name="totalRecords" select="count(exsl:node-set($unsortedrows)/xml/fnplm:fulfillments/fnplm:fulfillment)"/>

<xml>
<xsl:for-each select="exsl:node-set($unsortedrows)/xml/*[name()='fnplm:fulfillments']">
    <fnplm:fulfillments>
        <xsl:copy-of select="@*"/>
        <xsl:for-each select="exsl:node-set($unsortedrows)/xml/fnplm:fulfillments/fnplm:fulfillment">
            <xsl:sort select="xalan:evaluate($sortAttr)" order="{$sortDir}"/>
            <xsl:choose>
                <xsl:when test="$pageOffset='-1'">
                    <xsl:copy>
                        <xsl:copy-of select="@*"/>
                    </xsl:copy>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="position() &gt; $pageSize * number($pageOffset) and position() &lt;= number($pageSize * number($pageOffset) + $pageSize)">
                        <xsl:copy>
                            <xsl:copy-of select="@*"/>
                        </xsl:copy>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
     </fnplm:fulfillments>
</xsl:for-each>

<fnplm:input> 
  <xsl:attribute name="pageOffset">
       <xsl:value-of select="$pageOffset"/>
  </xsl:attribute>
  <xsl:attribute name="pageSize">
       <xsl:value-of select="$pageSize"/> 
  </xsl:attribute>
  <xsl:attribute name="totalRecords">
       <xsl:value-of select="$totalRecords"/> 
  </xsl:attribute>
  <xsl:attribute name="sortAttr">
       <xsl:value-of select="substring($sortAttr, 2)"/> 
  </xsl:attribute>
  <xsl:attribute name="sortDir">
       <xsl:value-of select="$sortDir"/> 
  </xsl:attribute>
</fnplm:input> 

</xml>
</xsl:template>


<xsl:template match="xml">
<xml>
<xsl:apply-templates select="fnplm:products"/>
<xsl:apply-templates select="fnplm:env"/>
</xml>
</xsl:template>

<xsl:template match="fnplm:fulfillments">
    <xsl:param name="vendorname"/>
    <fnplm:fulfillments>
        <xsl:copy-of select="@*"/>
        <xsl:attribute name="vendorname">
           <xsl:value-of select="$vendorname"/>
        </xsl:attribute>
        <xsl:apply-templates select="fnplm:fulfillment"/>
    </fnplm:fulfillments>
</xsl:template>

<xsl:template match="fnplm:fulfillment">
<fnplm:fulfillment>
    <xsl:variable name="features" select="@lines"/>
   <xsl:copy-of select="@*"/>
   <fnplm:features>
       <xsl:call-template name="convertfeaturelines">
           <xsl:with-param name="featurelines" select="@lines"/>
       </xsl:call-template>
   </fnplm:features>
</fnplm:fulfillment>
</xsl:template>

<xsl:template match="fnplm:env">
<xsl:copy>
    <xsl:copy-of select="@*"/>
</xsl:copy>
</xsl:template>
 
<xsl:template name="convertfeaturelines">
    <xsl:param name="featurelines"/>
    <xsl:variable name="string">
      <xsl:call-template name="replacestring">
          <xsl:with-param name="string" select="$featurelines"/>
          <xsl:with-param name="from" select="'&#x5C;&#xA;'"/>
          <xsl:with-param name="to" select="'&#x5C;'"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:call-template name="generatefeaturelines">
        <xsl:with-param name="string" select="$string"/>
    </xsl:call-template>
</xsl:template>

<xsl:template name="generatefeaturelines">
    <xsl:param name="string"/>
    <xsl:choose>
        <xsl:when test="contains($string,'&#10;')">
            <fnplm:feature>
                <xsl:attribute name="name">
                    <xsl:value-of select="substring-before($string,'&#10;')"/>
                </xsl:attribute>
            </fnplm:feature>
            <xsl:call-template name="generatefeaturelines">
                <xsl:with-param name="string" select="substring-after($string,'&#10;')"/>
            </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
            <fnplm:feature>
                <xsl:attribute name="name">
                    <xsl:value-of select="$string"/>
                </xsl:attribute>
            </fnplm:feature>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="replacestring">
    <xsl:param name="string"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:choose>
        <xsl:when test="contains($string,$from)">
            <xsl:value-of select="substring-before($string,$from)"/>
            <xsl:value-of select="$to"/>
            <xsl:call-template name="replacestring">
                <xsl:with-param name="string" select="substring-after($string,$from)"/>
                <xsl:with-param name="from" select="$from"/>
                <xsl:with-param name="to" select="$to"/>
            </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
           <xsl:value-of select="$string"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="fnplm:products">
   <xsl:apply-templates select="fnplm:fulfillments[@entitlementid=$entitlementid]">
      <xsl:with-param name="vendorname" select="@vendorname"/>
   </xsl:apply-templates>
</xsl:template>

</xsl:stylesheet>

