var GB_WINDOW = null;
var GB_IFRAME = null;
var GB_OVERLAY = null;
var GB_TIMEOUT = null;
var GB_URL;
var GB_HEIGHT = 400;
var GB_WIDTH = 400;
var GB_caption = null;
var GB_last_win_url = null;

function GB_show(caption, url /* optional */, height, width, return_win) {


  if(height != 'undefined')
    GB_HEIGHT = height;
  if(width != 'undefined')
    GB_WIDTH = width;

  initIfNeeded();

  GB_caption.innerHTML = caption;

  GB_setPosition();
  if(GB_ANIMATION) {
    positionRightVertically(GB_WINDOW, -(GB_HEIGHT+82));
  }

  AJS.showElement(GB_OVERLAY);
  AJS.showElement(GB_WINDOW);

  GB_setWidth();

  if(GB_ANIMATION) {
  	var array_page_size = GB_getWindowSize();
  	var theCenter = (array_page_size[1]+300)/2;
    GB_animateOut(-theCenter);
    GB_URL = url;
  }
  else {
    GB_IFRAME.src = url;
    GB_IFRAME.opener = this;
  }
  return false;
}

function GB_hide() {
  GB_IFRAME.src = GB_IMG_DIR + "blank.html";
  AJS.hideElement(GB_WINDOW);
  AJS.hideElement(GB_OVERLAY);
  mypanelSysReq.hide(); 
  mypanelPassword.hide(); 
  mypanelEula.hide(); 
 }
 
function GB_hideEula() {
  GB_IFRAME.src = GB_IMG_DIR + "blank.html";
  AJS.hideElement(GB_WINDOW);
  AJS.hideElement(GB_OVERLAY);
  mypanelEula.hide(); 
 }
 
function GB_hidePassword() {
  GB_IFRAME.src = GB_IMG_DIR + "blank.html";
  AJS.hideElement(GB_WINDOW);
  AJS.hideElement(GB_OVERLAY);
  mypanelPassword.hide(); 
 }
 
function GB_hideSysReq() {
  GB_IFRAME.src = GB_IMG_DIR + "blank.html";
  AJS.hideElement(GB_WINDOW);
  AJS.hideElement(GB_OVERLAY);
  mypanelSysReq.hide(); 
 }
 
function GB_hideActivation() {
  GB_IFRAME.src = GB_IMG_DIR + "blank.html";
  AJS.hideElement(GB_WINDOW);
  AJS.hideElement(GB_OVERLAY);
  mypanelActivation.hide(); 
 }
 
function GB_hideAssign() {
  GB_IFRAME.src = GB_IMG_DIR + "blank.html";
  AJS.hideElement(GB_WINDOW);
  AJS.hideElement(GB_OVERLAY);
  mypanelAssign.hide(); 
 }
 
 function GB_hideSignin() {
  GB_IFRAME.src = GB_IMG_DIR + "blank.html";
  AJS.hideElement(GB_WINDOW);
  AJS.hideElement(GB_OVERLAY);
  mypanelSignin.hide(); 
}

function GB_setPosition() {
  var array_page_size = GB_getWindowSize();
  var yCenter = (array_page_size[1]-GB_HEIGHT)/2;
  var xCenter = (array_page_size[0]-GB_WIDTH)/2;
  positionRightVertically(GB_WINDOW, yCenter);
  positionRightHorizontally(GB_WINDOW, xCenter);
}

function GB_animateOut(top) {
  var array_page_size = GB_getWindowSize();
  var theCenter = (array_page_size[1]-200)/2;
  
  if(top+getScrollTop() < 0) {
    positionRightVertically(GB_WINDOW, top+theCenter);
    GB_TIMEOUT = window.setTimeout(function() { GB_animateOut(top+40); }, 1);
  }
  else {
    GB_IFRAME.src = GB_URL;
    GB_IFRAME.opener = this;
    GB_WINDOW.style.top = getScrollTop()+theCenter+"px";
    clearTimeout(GB_TIMEOUT);
  }
}

function GB_setWidth() {
  var array_page_size = GB_getWindowSize();

  //Set size
  GB_WINDOW.style.width = GB_WIDTH + "px";
  GB_IFRAME.style.width = (GB_WIDTH - 10) + "px"; //Reducing the frame size by 10 pixels to get rid of overlap with the panel.

  GB_WINDOW.style.height = GB_HEIGHT + "px";
  GB_IFRAME.style.height = (GB_HEIGHT - 10) + "px";

  if((navigator.userAgent.toLowerCase().indexOf("firefox") != -1))
    GB_OVERLAY.style.width = "100%";
  else
    GB_OVERLAY.style.width = array_page_size[0] + "px";

  var max_height = Math.max(getScrollTop()+array_page_size[1], getScrollTop()+GB_HEIGHT+30);
  GB_OVERLAY.style.height = max_height + "px";

}

function GB_init() {
  GB_OVERLAY = AJS.DIV({'id': 'GB_overlay'});


  if(GB_overlay_click_close)
    GB_OVERLAY.onclick = GB_hide;

  AJS.getBody().insertBefore(GB_OVERLAY, AJS.getBody().firstChild);

  GB_WINDOW = AJS.DIV({'id': 'GB_window'});
  GB_caption = AJS.DIV({'id': 'GB_caption'}, "");


  AJS.getBody().insertBefore(GB_WINDOW, GB_OVERLAY.nextSibling);

}

function initIfNeeded() {
  if(GB_OVERLAY == null) {
    GB_init();
    GB_addOnWinResize(GB_setWidth);
    GB_addOnWinResize(GB_setPosition);
    window.onscroll = function() { GB_setPosition(); GB_setWidth(); };
  } 

  var new_frame = AJS.IFRAME({'id': 'GB_frame', 'name': 'GB_frame'});
  if (GB_IFRAME != null)
    AJS.removeElement(GB_IFRAME);
  AJS.appendChildNodes(GB_WINDOW, new_frame);
  GB_IFRAME = new_frame;
}

function GB_getWindowSize(){
	var window_width, window_height;
	if (self.innerHeight) {	// all except Explorer
		window_width = self.innerWidth;
		window_height = self.innerHeight;
	} else if (document.documentElement && document.documentElement.clientHeight) { // Explorer 6 Strict Mode
		window_width = document.documentElement.clientWidth;
		window_height = document.documentElement.clientHeight;
	} else if (document.body) { // other Explorers
		window_width = document.body.clientWidth;
		window_height = document.body.clientHeight;
	}	
	return [window_width, window_height];
}

function GB_addOnWinResize(func) {
  var oldonrezise = window.onresize;
  if (typeof window.onresize != 'function')
    window.onresize = func;
  else {
    window.onresize = function() {
      oldonrezise();
      func();
    }
  }
}

function positionRightVertically(elm, value) {
  elm.style.top = getScrollTop()+value+"px";
}

function positionRightHorizontally(elm, value) {
  elm.style.left = getScrollLeft()+value+"px";
 } 

function getScrollTop() {
  var theTop;
  if (document.documentElement && document.documentElement.scrollTop)
      theTop = document.documentElement.scrollTop;
  else if (document.body)
      theTop = document.body.scrollTop;
  return theTop;
}

function getScrollLeft() {
  var theLeft;
  if (document.documentElement && document.documentElement.scrollLeft)
      theLeft = document.documentElement.scrollLeft;
  else if (document.body)
      theLeft = document.body.scrollLeft;
  return theLeft;
}
