/*
 * Decompiled with CFR 0.152.
 */
package alerter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class Persist {
    private Properties properties = new Properties();
    private File file;

    public Persist(String string) {
        this.file = new File(string);
        this.load();
    }

    public String getLastId() {
        return this.properties.getProperty("lastAlert", "0");
    }

    public void setLastId(String string) {
        this.properties.setProperty("lastAlert", string);
        this.save();
    }

    private void load() {
        if (this.file.exists()) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
                this.properties.load(bufferedInputStream);
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                System.out.print("Error loading " + this.file.getPath() + ": " + exception);
            }
        }
    }

    private void save() {
        this.file.getParentFile().mkdirs();
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));
            this.properties.store(bufferedOutputStream, "Alerter State");
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            System.out.print("Error saving " + this.file.getPath() + ": " + exception);
        }
    }
}

