<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html"/>
  <xsl:param name="compliance508"><xsl:value-of select="extensions:getEnv('compliance508')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="vendorEnv"><xsl:value-of select="extensions:getEnv('vendor')" disable-output-escaping="yes"/></xsl:param>
  
  <xsl:template match="/">
    <xsl:apply-templates select="//fnplm:configuration"/>
  </xsl:template>
  
  <xsl:template match="fnplm:configuration">
    <div id="accordionContent">
      <h3 class="display"><a href="#Vendor"><xsl:value-of select="extensions:getString('IDS_GENERAL_VENDOR_HEADER')" disable-output-escaping="yes"/></a></h3>
      <div class="stretcher">
        <div class="dividerEmpty"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
        
        <strong><div class="asterisk">*</div><label for="license"><xsl:value-of select="extensions:getString('IDS_LICENSE_FILE_LABEL')" disable-output-escaping="yes"/></label></strong><br/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>textarea rows="4" cols="92" id="license" name="license" class="textField"><xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:xssEscape(./@license)" disable-output-escaping="yes"/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/textarea<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="oldLicense" value="<xsl:value-of select="extensions:xssEscape(./@license)" disable-output-escaping="yes"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>        
        
        <div class="divider"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
        
        <strong><label for="executable"><xsl:value-of select="extensions:getString('IDS_VENDOR_DAEMON_LOCATION_LABEL')" disable-output-escaping="yes"/></label></strong><br/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="92" id="executable" name="executable" value="<xsl:value-of select="extensions:xssEscape(./@executable)" disable-output-escaping="yes" />" class="textField"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br/>
        
        <!--div class="divider"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
        
        <strong><label for="optpath"><xsl:value-of select="extensions:getString('IDS_OPTIONS_FILE_LOCATION_LABEL')" disable-output-escaping="yes"/></label></strong><br/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="optpath" name="optpath" value="<xsl:value-of select="//fnplm:input/@optpath"/>" class="textField"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br/-->
        
        <div class="divider"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
        
        <xsl:variable name="vendorPortValue">
          <xsl:value-of select="./@port"/>
        </xsl:variable>
        
        <strong><div class="asterisk">*</div><label for="vendorport"><xsl:value-of select="extensions:getString('IDS_VENDOR_PORT_LABEL')" disable-output-escaping="yes"/></label></strong><br/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="radio" id="defaultPort" name="defaultPort" value="true"<xsl:if test="$vendorPortValue = 0"> checked</xsl:if><xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_VENDOR_PORT_DEFAULT_OPTION')" disable-output-escaping="yes"/><br/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="radio" id="customPort" name="defaultPort" value="false"<xsl:if test="$vendorPortValue != 0"> checked</xsl:if><xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_VENDOR_PORT_OPTION')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="5" name="port" value="<xsl:value-of select="./@port"/>" class="textField" maxlength="5" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br/>
        
        <div class="divider"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
        
        <strong><div class="asterisk">*</div><label for="restartRetries"><xsl:value-of select="extensions:getString('IDS_RESTART_RETRIES_LABEL')" disable-output-escaping="yes"/></label></strong><br/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="restartRetries" name="restartRetries" value="<xsl:value-of select="./@restartRetries"/>" class="textField" maxlength="3" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br/>
        
        <div class="divider"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
        
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="dateBasedVersion" <xsl:if test="./@dateBasedVersion='true'">CHECKED</xsl:if> value="true"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_DATE_BASED_VERSION_LABEL')" disable-output-escaping="yes"/><br/><br/>
        
      </div>
      
      <h3 class="display"><a href="#Debugging"><xsl:value-of select="extensions:getString('IDS_DEBUGGING_HEADER')" disable-output-escaping="yes"/></a></h3>
      <div class="stretcher">
        <div class="dividerEmpty"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
        
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="logOverwrite" <xsl:if test="./@logOverwrite='true'">CHECKED</xsl:if> value="true"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_OVERWRITE_DEBUG_LOG_LABEL')" disable-output-escaping="yes"/><br/><br/>
        
        <strong><label for="logFile"><xsl:value-of select="extensions:getString('IDS_DEBUG_LOG_LOCATION_LABEL')" disable-output-escaping="yes"/></label></strong><br/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="40" id="logFile" name="logFile" value="<xsl:value-of select="extensions:xssEscape(./@logFile)" disable-output-escaping="yes" />" class="textField"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><br/><br/>
        
        <xsl:choose>
          <xsl:when test="$compliance508!='TRUE'">
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="#" onclick="javascript:NewWindow('display?log=<xsl:value-of select="$vendorEnv"/>', 'FlexNet', '650','600','yes','yes');" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_VIEW_FILE_EXTERNALLY_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/display?log=<xsl:value-of select="$vendorEnv"/>" class="textLink" target="_blank"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_VIEW_FILE_EXTERNALLY_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        
        <div class="dividerEmpty"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
      </div>
    </div>
  </xsl:template> 
</xsl:stylesheet>
