<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html" version="4.01" encoding="UTF-8"/>
  <xsl:param name="compliance508"><xsl:value-of select="//fnplm:input/@compliance508"/></xsl:param>
  <xsl:include href="sessionTimeout.xsl"/>
  
  <xsl:variable name="result">
    <xsl:value-of select="extensions:invalidateSession()" disable-output-escaping="yes"/>
  </xsl:variable>
  
  <xsl:template match="/" name="signout">
    <xsl:if test="starts-with($result, 'ERROR_EXPIRED_SESSION:')">
      <xsl:call-template name="sessionTimeout"/>
    </xsl:if>
    
    <html>
      <head>
        <script language="javascript">
          createCookie('selection', '0');
        </script>
        
        <xsl:choose>
          <xsl:when test="$compliance508!='TRUE'">
            <meta http-equiv="refresh" content="0; url=login"/>
          </xsl:when>
          <xsl:otherwise>
            <meta http-equiv="refresh" content="0; url=login508"/>
          </xsl:otherwise>
        </xsl:choose>
      </head>
    </html>
  </xsl:template>
</xsl:stylesheet>

