<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
  
  <xsl:param name="admin"><xsl:value-of select="//fnplm:input/@admin"/></xsl:param>
  <xsl:param name="userLocale"><xsl:value-of select="//fnplm:input/@userlocale"/></xsl:param>
  <xsl:variable name="save"><xsl:value-of select="//fnplm:input/@Save"/></xsl:variable>
  <xsl:param name="cancel"><xsl:value-of select="//fnplm:input/@Cancel"/></xsl:param>
  <xsl:variable name="compliance508"><xsl:value-of select="//fnplm:input/@compliance508"/></xsl:variable>
  <xsl:variable name="location"><xsl:value-of select="//fnplm:input/@location"/></xsl:variable>
  
  <xsl:variable name="changeLocaleReturn">
    <xsl:if test="$userLocale!='' and $save!=''">
      <xsl:value-of select="extensions:setLocale($userLocale)" disable-output-escaping="yes"/>
    </xsl:if>
  </xsl:variable>
  
  <xsl:template match="/">
    <html>
      <head>
        <xsl:choose>
          <xsl:when test="$compliance508!='TRUE'">
            <link rel="stylesheet" type="text/css" href="resources/content.css"/>
            <link rel="stylesheet" type="text/css" href="resources/structure.css"/>
            <link rel="stylesheet" type="text/css" href="resources/veneer.css"/>
            <link rel="stylesheet" type="text/css" href="resources/veneerPopup.css"/>
          </xsl:when>
          <xsl:otherwise>
            <link rel="stylesheet" type="text/css" href="resources/508/content.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/structure.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/veneer.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/veneerPopup.css"/>
          </xsl:otherwise>
        </xsl:choose>
        <script type="text/javascript" src="resources/ajax.js"/>
        <script type="text/javascript" src="resources/popup.js"/>
        <script type="text/javascript" src="resources/drag.js"/>
        <script type="text/javascript" src="resources/standard.js"/>
      
        <meta http-equiv="Cache-Control" content="no-cache"/>
        <meta http-equiv="Pragma" content="no-cache"/>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
      </head>

      <body SCROLL="NO">
        <form action="/locale" method="post" name="changeLocale">
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="location" value="<xsl:value-of select="$location"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          <xsl:if test="$compliance508='TRUE'">
            <input type="hidden" name="compliance508" value="TRUE"/>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="location" value="<xsl:value-of select="$location"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:if>
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>table <xsl:if test="$compliance508!='TRUE'">width="320"</xsl:if><xsl:text disable-output-escaping="yes">&gt;</xsl:text><tr><td>
            <div class="contentSpacer">
              <xsl:if test="$cancel='' and $save=''">
                <h1><xsl:value-of select="extensions:getString('IDS_CHANGE_LOCALE_HEADER')" disable-output-escaping="yes"/></h1>
              </xsl:if>
              <p>
                <xsl:choose>
                  <xsl:when test="$changeLocaleReturn!=''">
                    <font color="#cc0000"><b>
                      <xsl:choose>
                        <xsl:when test="substring-after($changeLocaleReturn, ':') != ''">
                          <xsl:value-of select="substring-after($changeLocaleReturn, ':')"/>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="$changeLocaleReturn"/>
                        </xsl:otherwise>
                      </xsl:choose>
                    </b></font><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/p<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>p<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:when>
                  <xsl:when test="$cancel!='' or $save!=''">
                    <script language="javascript">
                      <xsl:if test="$save!=''">
                        createCookie('userLocale','<xsl:value-of select="$userLocale"/>', 365);
                        top.document.location.href = "/<xsl:value-of select="$location"/><xsl:if test="$compliance508='TRUE'">?compliance508=TRUE</xsl:if>";
                      </xsl:if>
                    </script>
                    
                    <xsl:variable name="args">
                      <xml>
                        <fnplm:args>
                          <xsl:attribute name="href">/<xsl:value-of select="$location"/><xsl:if test="$compliance508='TRUE'">?compliance508=TRUE</xsl:if></xsl:attribute>
                        </fnplm:args>
                      </xml>
                    </xsl:variable>
                    
                    <xsl:choose>
                      <xsl:when test="$cancel!=''">
                        <xsl:value-of select="extensions:getFormattedString('IDS_CANCEL_LOCALE_MESSAGE', exsl:node-set($args)/xml/*)" disable-output-escaping="yes"/>
                      </xsl:when>
                      <xsl:when test="$save!=''">
                        <xsl:value-of select="extensions:getFormattedString('IDS_CHANGE_LOCALE_MESSAGE', exsl:node-set($args)/xml/*)" disable-output-escaping="yes"/>
                      </xsl:when>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:when test="substring-after($changeLocaleReturn, 'ERROR_CONFIG_READ_ONLY:')!=''">
                    <font color="#cc0000"><b><xsl:value-of select="extensions:getString('ERROR_CONFIG_READ_ONLY')" disable-output-escaping="yes"/></b></font><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/p<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>p<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:when>
                </xsl:choose>
              </p>
              <xsl:if test="$cancel='' and $save=''">
                <xsl:value-of select="extensions:getLocaleList('xslt/localeSelectionDropDown.xsl')" disable-output-escaping="yes" />
                <p></p>
                <p></p>
                <p></p>
                
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Save" value="<xsl:value-of select="extensions:getString('IDS_SAVE_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                
                <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Cancel" value="<xsl:value-of select="extensions:getString('IDS_CANCEL_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" onClick="parent.GB_hidePassword();" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
              </xsl:if>
            </div>
          </td></tr><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/table<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </form>
        <script type="text/javascript">
          var userLocale = readCookie('userLocale');
          if (userLocale != null &amp;&amp; userLocale != "null") {
			if(document.changeLocale.userlocale != null) {
			  for (i = 0; i &lt; document.changeLocale.userlocale.options.length; i++) {
			    if (userLocale == document.changeLocale.userlocale.options[i].value) {
			      document.changeLocale.userlocale.options[i].selected = true;
			    }
			  }
            }
		  }
        </script>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>

