<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="text"/>

  <xsl:param name="envUserName">
    <xsl:value-of select="extensions:getEnv('username')" disable-output-escaping="yes"/>
  </xsl:param>
  <xsl:param name="userName">
    <xsl:choose>
      <xsl:when test="$envUserName != ''">
        <xsl:value-of select="extensions:getEnv('username')" disable-output-escaping="yes"/></xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="extensions:getCurrentUser('xslt/userName.xsl')" disable-output-escaping="yes" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:template match="/" name="expiredPassword">
     <xsl:apply-templates select="xml/fnplm:users" />
  </xsl:template>
  
  <xsl:template match="fnplm:users">
    <xsl:apply-templates select="fnplm:user[@id=$userName]" />
  </xsl:template>
  
  <xsl:template match="fnplm:user">
    <xsl:value-of select="./@passwordExpired"/>
  </xsl:template>
</xsl:stylesheet>

