<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:include href="header.xsl"/>
  <xsl:include href="headerNav.xsl"/>
  <xsl:include href="alertSummary.xsl"/>
  <xsl:include href="licenseSummary.xsl"/>
  <xsl:include href="footer.xsl"/>
  <xsl:variable name="help_id">HELP_IDS_DASHBOARD</xsl:variable>
  <xsl:param name="dashboard" select="'TRUE'"/>
  <xsl:param name="isAdmin"><xsl:value-of select="extensions:hasPrivilege('admin')" disable-output-escaping="yes" /></xsl:param>
  
  <xsl:template match="/" name="dashboard">
  <xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"&gt;</xsl:text>

    <html>
      <head>
        <xsl:call-template name="header"/>
        
      </head>
      <body>
        <script type="text/javascript">
          if (window.opener) {
	        currenturl = document.URL;
	        window.opener.location.replace(currenturl);
	        window.close();
          }
        </script>
        <div id="shell">
          <div id="wrapper">
            <div id="outerNoNav">
              <div id="centerNoNav">
                <div id="clearheadercenter"></div>
                <div id="containerCenter">
                  <div id="containerDualColumnNoNav">
                    <div id="leftContentThin">
                      <div class="content">
                        <xsl:call-template name="alertSummary"/>
    <noscript>
      <p class="importErrorText"><b><xsl:value-of select="extensions:getString('IDS_JAVASCRIPT_DISABLED')" disable-output-escaping="yes"/></b></p>
    </noscript>
                      </div>
                      <div id="containerCenterFooter"></div>
                      <div class="password">
                       <xsl:variable name="userType">
                         <xsl:value-of select="extensions:getCurrentUser('xslt/userType.xsl')" disable-output-escaping="yes" />
                       </xsl:variable>
                       <xsl:variable name="localeCount">
                          <xsl:value-of select="extensions:getLocaleList('xslt/localeCount.xsl')" disable-output-escaping="yes" />
                        </xsl:variable>
            
                        <xsl:choose>
                          <xsl:when test="$compliance508!='TRUE'">
                            <xsl:if test="$protectDashboard='true' or $isAdmin=''">
                              <xsl:if test="starts-with($userType, 'local')"> 
                                <a href="#" onClick=" mypanelPassword.show(); return GB_show('password', 'password', 270, 328);"><xsl:value-of select="extensions:getString('IDS_CHANGE_PASSWORD_LABEL')" disable-output-escaping="yes"/></a>
                              </xsl:if>
                            </xsl:if>
                            <xsl:if test="$localeCount > 1">
                              <a href="#" onClick=" mypanelPassword.show(); return GB_show('locale', 'locale?location=dashboard', 270, 328);"><xsl:value-of select="extensions:getString('IDS_CHANGE_LOCALE_LABEL')" disable-output-escaping="yes"/></a>
                            </xsl:if>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:if test="$protectDashboard='true' or $isAdmin=''">
                              <xsl:if test="starts-with($userType, 'local')"> 
                                 <a href="/password?compliance508=TRUE&amp;location=dashboard"><xsl:value-of select="extensions:getString('IDS_CHANGE_PASSWORD_LABEL')" disable-output-escaping="yes"/></a>
                              </xsl:if>
                            </xsl:if>
                            <xsl:if test="$localeCount > 1">
                              <a href="/locale?compliance508=TRUE&amp;location=dashboard"><xsl:value-of select="extensions:getString('IDS_CHANGE_LOCALE_LABEL')" disable-output-escaping="yes"/></a>
                            </xsl:if>
                          </xsl:otherwise>
                        </xsl:choose>
                      </div>
                    </div>
                      
                    <div id="containerSplitterNoNav"></div>
                    <div id="rightContentWide">
                      <div class="content">
                        <xsl:call-template name="licenseSummary"/>
                      </div>
                      <div id="containerCenterFooter"><xsl:value-of select="extensions:getString('IDS_ACRESSO_COPYRIGHT')" disable-output-escaping="yes"/></div>
                    </div>
                  </div>
                </div>
                  
                <div id="clearfootercenter"></div>
              </div>
              <div class="clear"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
            </div>
          </div>
          <xsl:call-template name="headerNav"/>
        </div>
        <xsl:call-template name="footer"/>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
