<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:template name="alertSummary">
      <xsl:variable name="alertsReturn">
        <xsl:value-of select="extensions:getAlerts('xslt/alertSummaryDetails.xsl')" disable-output-escaping="yes" />
      </xsl:variable>
      
      <xsl:choose>
        <xsl:when test="$login='TRUE'"></xsl:when>
        <xsl:when test="starts-with($alertsReturn, 'ERROR_EXPIRED_SESSION:')">
          <xsl:call-template name="sessionTimeout"/>
        </xsl:when>
        <xsl:when test="$alertsReturn != ''">
          <xsl:copy-of select="$alertsReturn"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:copy-of select="$alertsReturn"/>
        </xsl:otherwise>
      </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
