<?xml version="1.0" encoding="iso-8859-1"?>
<!-- Copyright (c) 2001-2005 DeltaXML Ltd. All rights reserved. -->
<!-- Use subject to the conditions in the included file: LICENSE.bsd -->
<!-- $Id: xml2pi.xsl 4592 2008-07-24 09:08:03Z tristanm $ -->
<!--
     This stylesheet puts XML elements that denote processing instructions, beginning pi:, into
     processing instructions. See also pi2xml.xsl which converts the other way.
  -->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:pi="http://www.deltaxml.com/ns/processing-instructions"
  xmlns:deltaxml="http://www.deltaxml.com/ns/well-formed-delta-v1">

  <xsl:output method="xml" indent="no"/>

  <xsl:param name="pi-modified-version" select="'new'"/>
  <xsl:param name="comment-modified-version" select="'new'"/>
 
  <!-- identity template -->
  <xsl:template match="node()|@*">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <!-- Convert processing instructions from XML element pi:* to a processing instruction -->
  <xsl:template match="pi:*">
    <xsl:choose>
      <xsl:when test="@deltaxml:delta = 'delete'">
        <!-- the pi has been deleted, don't include it -->
      </xsl:when>
      <xsl:when test="@deltaxml:delta = 'WFmodify'">
        <!-- the pi has been modified, insert one of two versions -->
        <xsl:processing-instruction name="{local-name()}">
          <xsl:choose>
            <xsl:when test="$pi-modified-version = 'new'">
              <xsl:value-of select="deltaxml:PCDATAmodify/deltaxml:PCDATAnew"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="deltaxml:PCDATAmodify/deltaxml:PCDATAold"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:processing-instruction>
      </xsl:when>
      <xsl:otherwise>
        <!-- The pi is unchanged or added. In either case, include it --> 
        <xsl:processing-instruction name="{local-name()}">
          <xsl:value-of select="."/>
        </xsl:processing-instruction>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
 
  <xsl:template match="deltaxml:comment">
    <xsl:choose>
      <xsl:when test="@deltaxml:delta = 'delete'">
        <!-- the comment has been deleted, don't include it -->
      </xsl:when>
      <xsl:when test="@deltaxml:delta = 'WFmodify'">
        <!-- the comment has been modified, insert one of two versions -->
        <xsl:comment>
          <xsl:choose>
            <xsl:when test="$comment-modified-version = 'new'">
              <xsl:value-of select="deltaxml:PCDATAmodify/deltaxml:PCDATAnew"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="deltaxml:PCDATAmodify/deltaxml:PCDATAold"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:comment>
      </xsl:when>
      <xsl:otherwise>
        <!-- The comment is unchanged or added. In either case, include it --> 
        <xsl:comment>
          <xsl:value-of select="."/>
        </xsl:comment>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
 
</xsl:stylesheet>

