<?xml version="1.0" encoding="iso-8859-1"?>
<!-- Copyright (c) 2003-2005 DeltaXML Ltd. All rights reserved -->
<!-- Use subject to the conditions in the included file: LICENSE.bsd -->
<!-- $Id: xhtml-outfilter.xsl 4527 2008-06-10 16:35:27Z nigelw $ -->
<!--
    This stylesheet takes an XHTML delta file, i.e. the result of
    comparing two XHTML files, and generates another standard XHTML
    file which shows the differences.

    This is an example only and may not work correctly for all input files.

    Based on XHTML Transitional.

    By changing this stylesheet, you can flag changes to the user in
    any way you wish. For example, if you do not want deleted images
    displayed then change the template that deals with deleted images.
  -->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns:deltaxml="http://www.deltaxml.com/ns/well-formed-delta-v1" exclude-result-prefixes="deltaxml">

  <!-- Output can be pretty-printed -->
  <!-- You could also add instructions for adding DOCTYPE info
       such as systemIds or publicIds here, the XML dec is not output
       as this has a tendency to put certain rendering engines such
       as IE into quirks-mode, not 'standards-mode'
       Also consider using non-standard xhtml output methods,
       such as saxon:xhtml depending upon pipeline/tooling -->

  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes" />

  <xsl:param name="includeButtons" select="'no'"/>
  
  <xsl:param name="old-color" select="'#FF5555'"/>
  <xsl:param name="new-color" select="'#90EE90'"/>
  
  <xsl:param name="old-style" select="concat('background:', $old-color)"/>
  <xsl:param name="new-style" select="concat('background:', $new-color)"/>
  <xsl:param name="old-img-style" select="'border: 2px solid red'"/>
  <xsl:param name="new-img-style" select="'border: 2px solid green'"/>
  
  <!-- There are basically four modes:
    - process unchanged data by copying to output
    - process added data by by copying to output, with text spanned using the
      deltaxml-new CSS class.
    - process deleted data by by copying to output, with text spanned using the
      deltaxml-old CSS class.
    - process modified data, treating each child to see which of the above apply

    The deltaxml-new and deltaxml-old CSS classes can be configured to
    style the changed text as desired.  Please see the head modification
    template below. 

    In paragraph and similar types of element we process the DeltaXML
    elements and output both the old and new data.  In some other elements
    this may result in incorrect data (eg. in the <style> element.  In these
    cases we have decided to simply use the data form the new file.  If this
    approach does not meet your needs please modify this script as
    appropriate.
  -->

  <!-- process any modified node (we do not need to check for mods as this applies to
  all nodes -->
  <xsl:template match="*">
   <xsl:variable name="element-name">
    <xsl:call-template name="find-element-name">
      <xsl:with-param name="element" select="."/>
    </xsl:call-template>
   </xsl:variable>
   <xsl:element name="{$element-name}" namespace="http://www.w3.org/1999/xhtml">
    <xsl:apply-templates select="@*"/>
    <xsl:apply-templates select="node()"/>
   </xsl:element>
  </xsl:template>

  <!-- The head modification template -->
  <xsl:template match="*[local-name()='head']">
    <xsl:element name="head" namespace="http://www.w3.org/1999/xhtml">
      <xsl:apply-templates select="@*"/>
      <xsl:comment>Generated by the DeltaXML.com xhtml-outfilter.xsl</xsl:comment>
      <xsl:comment>Using XSL Processor: <xsl:value-of select="system-property('xsl:vendor')"/></xsl:comment>
      <xsl:apply-templates select="node()"/>
      <xsl:element name="style" namespace="http://www.w3.org/1999/xhtml">
        <xsl:attribute name="type">text/css</xsl:attribute>
        body { margin-top: 50px }
        a.button { background: #DDD; border: 2px outset black; padding: 2px; margin: 2px; font-family: sans-serif; font-size: small;}
        a.button:hover { cursor:pointer; }
        a.button:active { border-style: inset; }
      </xsl:element>
      <xsl:element name="script" namespace="http://www.w3.org/1999/xhtml">
        <xsl:attribute name="type">text/javascript</xsl:attribute>
            function view(doc) {
              var allSpans=document.getElementsByTagName("span");
              if(doc=="old") {
                for(i=0;i!=allSpans.length;i++) {
                  var name=allSpans[i].className;
                  if(name=="deltaxml-new" || name=="deltaxml-new-img" || name=="deltaxml-new-format") {
                    allSpans[i].style.display="none";
                  } else if (name=="deltaxml-old" || name=="deltaxml-old-img" || name=="deltaxml-old-format") {
                    allSpans[i].style.display="inline";
                    allSpans[i].style.background="#FFF";
                    //need to take border off images
                    var allImgs=allSpans[i].getElementsByTagName("img");
                    for(j=0;j!=allImgs.length;j++) {
                      allImgs[j].style.border="none";
                    }
                  }
                }
              } else if(doc=="new") {
                for(i=0;i!=allSpans.length;i++) {
                  var name=allSpans[i].className;
                  if(name=="deltaxml-new" || name=="deltaxml-new-img" || name=="deltaxml-new-format") {
                    allSpans[i].style.display="inline";
                    allSpans[i].style.background="#FFF";
                    //need to take border off images
                    var allImgs=allSpans[i].getElementsByTagName("img");
                    for(j=0;j!=allImgs.length;j++) {
                      allImgs[j].style.border="none";
                    }
                  } else if (name=="deltaxml-old" || name=="deltaxml-old-img" || name=="deltaxml-old-format") {
                    allSpans[i].style.display="none";
                   }
                }
              } else if(doc=="both") {
                for(i=0;i!=allSpans.length;i++) {
                  var name=allSpans[i].className;
                  if(name=="deltaxml-new" || name=="deltaxml-new-format" || name=="deltaxml-new-img") {
                    allSpans[i].style.display="inline";
                    allSpans[i].style.background="<xsl:value-of select="$new-color"/>";
                    //need to add border to images
                    var allImgs=allSpans[i].getElementsByTagName("img");
                    for(j=0;j!=allImgs.length;j++) {
                      allImgs[j].style.border="2px solid green";
                    }
                  } else if(name=="deltaxml-old" || name=="deltaxml-old-format" || name=="deltaxml-old-img") {
                    allSpans[i].style.display="inline";
                    allSpans[i].style.background="<xsl:value-of select="$old-color"/>";
                    //need to add border to images
                    var allImgs=allSpans[i].getElementsByTagName("img");
                    for(j=0;j!=allImgs.length;j++) {
                      allImgs[j].style.border="2px solid red";
                    }
                  }
                }
              } else if(doc=="both-no-format") {
                for(i=0;i!=allSpans.length;i++) {
                  var name=allSpans[i].className;
                  if(name=="deltaxml-new" || name=="deltaxml-new-img") {
                    allSpans[i].style.display="inline";
                    allSpans[i].style.background="<xsl:value-of select="$new-color"/>";
                    //need to add border to images
                    var allImgs=allSpans[i].getElementsByTagName("img");
                    for(j=0;j!=allImgs.length;j++) {
                      allImgs[j].style.border="2px solid green";
                    }
                  } else if(name=="deltaxml-old" || name=="deltaxml-old-img") {
                    allSpans[i].style.display="inline";
                    allSpans[i].style.background="<xsl:value-of select="$old-color"/>";
                    //need to add border to images
                    var allImgs=allSpans[i].getElementsByTagName("img");
                    for(j=0;j!=allImgs.length;j++) {
                      allImgs[j].style.border="2px solid red";
                    }
                  } else if (name=="deltaxml-new-format") {
                    allSpans[i].style.display="inline";
                    allSpans[i].style.background="#FFF";
                  } else if(name=="deltaxml-old-format") {
                    allSpans[i].style.display="none";
                  }
                }
              }
            }

      </xsl:element>
    </xsl:element>
  </xsl:template>
  
  <!-- add buttons to the body -->
  <xsl:template match="*[local-name()='body']">
    <xsl:element name="body" namespace="http://www.w3.org/1999/xhtml">
      <xsl:apply-templates select="@*"/>
      
      
      <xsl:if test="$includeButtons='yes'">
        <xsl:element name="div" namespace="http://www.w3.org/1999/xhtml">
          <xsl:attribute name="style">position:fixed; clear:both; top:0px</xsl:attribute>
          <xsl:element name="p" namespace="http://www.w3.org/1999/xhtml">
            <xsl:element name="a" namespace="http://www.w3.org/1999/xhtml">
              <xsl:attribute name="class">button</xsl:attribute>
              <xsl:attribute name="onclick">view('old')</xsl:attribute>
              View Old
            </xsl:element>
            <xsl:element name="a" namespace="http://www.w3.org/1999/xhtml">
              <xsl:attribute name="class">button</xsl:attribute>
              <xsl:attribute name="onclick">view('new')</xsl:attribute>
              View New
            </xsl:element>
            <xsl:element name="a" namespace="http://www.w3.org/1999/xhtml">
              <xsl:attribute name="class">button</xsl:attribute>
              <xsl:attribute name="onclick">view('both')</xsl:attribute>
              View Both
            </xsl:element>
            <xsl:element name="a" namespace="http://www.w3.org/1999/xhtml">
              <xsl:attribute name="class">button</xsl:attribute>
              <xsl:attribute name="onclick">view('both-no-format')</xsl:attribute>
              View Both (Ignore Format-only Changes)
            </xsl:element>
          </xsl:element>
        </xsl:element>
      </xsl:if>
      
      <xsl:apply-templates select="*"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="text()">
    <xsl:copy-of select="."/>
  </xsl:template>

  <xsl:template match="deltaxml:PCDATAmodify">
   <xsl:if test="string-length(./deltaxml:PCDATAold/text())>0">
    <xsl:element name="span" namespace="http://www.w3.org/1999/xhtml">
      <xsl:attribute name="class" namespace="">deltaxml-old</xsl:attribute>
      <xsl:attribute name="style" namespace=""><xsl:value-of select="$old-style"/></xsl:attribute>
     <xsl:value-of select="./deltaxml:PCDATAold/text()"/>
    </xsl:element>
   </xsl:if>
   <xsl:if test="string-length(./deltaxml:PCDATAnew/text())>0">
    <xsl:element name="span" namespace="http://www.w3.org/1999/xhtml">
      <xsl:attribute name="class" namespace="">deltaxml-new</xsl:attribute>
      <xsl:attribute name="style" namespace=""><xsl:value-of select="$new-style"/></xsl:attribute>
     <xsl:value-of select="./deltaxml:PCDATAnew/text()"/>
    </xsl:element>
   </xsl:if>
  </xsl:template>

  <xsl:template match="deltaxml:exchange">
   <xsl:apply-templates select="deltaxml:old/node()" mode="deleted-data"/>
   <xsl:apply-templates select="deltaxml:new/node()" mode="added-data"/>
  </xsl:template>


  <!-- process any added node -->
  <xsl:template match="*[@deltaxml:delta='add']" priority="1">
   <xsl:apply-templates mode="added-data" select="."/>
  </xsl:template>
  
  <xsl:template match="*" mode="added-data">
   <xsl:variable name="element-name">
    <xsl:call-template name="find-element-name">
      <xsl:with-param name="element" select="."/>
    </xsl:call-template>
   </xsl:variable>
   <xsl:element name="{$element-name}" namespace="http://www.w3.org/1999/xhtml">
    <xsl:apply-templates select="@*" mode="added-data"/>
    <xsl:apply-templates select="node()" mode="added-data"/>
   </xsl:element>
  </xsl:template>

  <xsl:template match="text()" mode="added-data">
   <xsl:if test="string-length(.)>0">
    <xsl:element name="span" namespace="http://www.w3.org/1999/xhtml">
      <xsl:attribute name="class" namespace="">deltaxml-new</xsl:attribute>
      <xsl:attribute name="style" namespace=""><xsl:value-of select="$new-style"/></xsl:attribute>
     <xsl:value-of select="."/>
    </xsl:element>
   </xsl:if>
  </xsl:template>

  <!-- 
    select exchange elements where only change is a format change. Logic is :
    Format added = deltaxml:old has a text() child and deltaxml:new has a child with deltaxml:format="true" AND their text contents are precisely equal
    Format deleted = deltaxml:old has child with deltaxml:format="true" and deltaxml:new has text() child AND their text contents are precisely equal
    Format modified= deltaxml:old has a child with deltaxml:format="true" as does deltaxml:new AND their text contents are precisely equal
  -->
  <xsl:template match="deltaxml:exchange[child::deltaxml:old/child::*[@deltaxml:format='true'] and child::deltaxml:new/text() and child::deltaxml:new/descendant::text()=child::deltaxml:old/descendant::text()] |
                       deltaxml:exchange[child::deltaxml:old/text() and child::deltaxml:new/child::*[@deltaxml:format='true'] and child::deltaxml:new/descendant::text()=child::deltaxml:old/descendant::text()] |
                       deltaxml:exchange[child::deltaxml:old/child::*[@deltaxml:format='true'] and child::deltaxml:new/child::*[@deltaxml:format='true'] and child::deltaxml:new/descendant::text()=child::deltaxml:old/descendant::text()]">
    <xsl:apply-templates select="deltaxml:old/node()" mode="old-format"/>
    <xsl:apply-templates select="deltaxml:new/node()" mode="new-format"/>
  </xsl:template>

  
  
  <xsl:template match="*" mode="new-format">
    <xsl:variable name="element-name">
      <xsl:call-template name="find-element-name">
        <xsl:with-param name="element" select="."/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:element name="{$element-name}" namespace="http://www.w3.org/1999/xhtml">
      <xsl:apply-templates select="@*" mode="new-format"/>
      <xsl:apply-templates select="node()" mode="new-format"/>
    </xsl:element>
  </xsl:template>
  
  <xsl:template match="text()" mode="new-format">
    <xsl:if test="string-length(.)>0">
      <xsl:element name="span" namespace="http://www.w3.org/1999/xhtml">
        <xsl:attribute name="class" namespace="">deltaxml-new-format</xsl:attribute>
        <xsl:attribute name="style" namespace=""><xsl:value-of select="$new-style"/></xsl:attribute>
        <xsl:value-of select="."/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="*" mode="old-format">
    <xsl:variable name="element-name">
      <xsl:call-template name="find-element-name">
        <xsl:with-param name="element" select="."/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:element name="{$element-name}" namespace="http://www.w3.org/1999/xhtml">
      <xsl:apply-templates select="@*" mode="old-format"/>
      <xsl:apply-templates select="node()" mode="old-format"/>
    </xsl:element>
  </xsl:template>
  
  <xsl:template match="text()" mode="old-format">
    <xsl:if test="string-length(.)>0">
      <xsl:element name="span" namespace="http://www.w3.org/1999/xhtml">
        <xsl:attribute name="class" namespace="">deltaxml-old-format</xsl:attribute>
        <xsl:attribute name="style" namespace=""><xsl:value-of select="$old-style"/></xsl:attribute>
        <xsl:value-of select="."/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  
  <!-- Write out attributes -->
  <xsl:template match="@*" mode="added-data">
    <xsl:copy-of select="."/>
  </xsl:template>
  
  <xsl:template match="@*" mode="new-format">
    <xsl:choose>
      <xsl:when test="namespace-uri(.)!='http://www.deltaxml.com/ns/well-formed-delta-v1'">
        <xsl:copy-of select="."/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="@*" mode="old-format">
    <xsl:choose>
      <xsl:when test="namespace-uri(.)!='http://www.deltaxml.com/ns/well-formed-delta-v1'">
        <xsl:copy-of select="."/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <!-- Deal with any elements added where formatted text is not allowed -->
  
  <!-- For these elements, output changes delimited by [] or similar -->
  <xsl:template match="*[local-name()='textarea' or local-name()='title' or
                        local-name()='option']" mode="added-data">
   <xsl:variable name="element-name">
    <xsl:call-template name="find-element-name">
      <xsl:with-param name="element" select="."/>
    </xsl:call-template>
   </xsl:variable>
   <xsl:element name="{$element-name}" namespace="http://www.w3.org/1999/xhtml">
    <xsl:apply-templates select="@*"/>
    <xsl:text>+[[</xsl:text>
    <xsl:value-of select="text()"/>
    <xsl:text>]]+</xsl:text>
   </xsl:element>
  </xsl:template>

  <!-- For these elements, we output the new data and ignore old so that we
    ensure that the data is valid. So old data here is lost -->
  <xsl:template match="*[local-name()='script' or 
                         local-name()='style'] " mode="added-data">
   <xsl:variable name="element-name">
    <xsl:call-template name="find-element-name">
      <xsl:with-param name="element" select="."/>
    </xsl:call-template>
   </xsl:variable>
   <xsl:element name="{$element-name}" namespace="http://www.w3.org/1999/xhtml">
    <xsl:apply-templates select="@*"/>
     <xsl:value-of select="text()"/>
   </xsl:element>
  </xsl:template>
  
  <!-- process any deleted node -->
  <xsl:template match="*[@deltaxml:delta='delete']" priority="1">
   <xsl:apply-templates mode="deleted-data" select="."/>
  </xsl:template>

  <xsl:template match="*" mode="deleted-data">
   <xsl:variable name="element-name">
    <xsl:call-template name="find-element-name">
      <xsl:with-param name="element" select="."/>
    </xsl:call-template>
   </xsl:variable>
   <xsl:element name="{$element-name}" namespace="http://www.w3.org/1999/xhtml">
    <xsl:apply-templates select="@*"/>
     <xsl:apply-templates select="node()" mode="deleted-data"/>
   </xsl:element>
  </xsl:template>

  <xsl:template match="text()" mode="deleted-data">
   <xsl:if test="string-length(.)>0">
   <xsl:element name="span" namespace="http://www.w3.org/1999/xhtml">
     <xsl:attribute name="class" namespace="">deltaxml-old</xsl:attribute>
     <xsl:attribute name="style" namespace=""><xsl:value-of select="$old-style"/></xsl:attribute>
    <xsl:value-of select="."/>
   </xsl:element>
   </xsl:if>
  </xsl:template>

  <!-- For deleted images, just note they are deleted -->
  <xsl:template match="*[local-name()='img']" mode="deleted-data">
    <xsl:element name="span" namespace="http://www.w3.org/1999/xhtml">
      <xsl:attribute name="class">deltaxml-old-img</xsl:attribute>
      <xsl:element name="img" namespace="http://www.w3.org/1999/xhtml">
        <xsl:attribute name="style" namespace=""><xsl:value-of select="$old-img-style"/></xsl:attribute>
        <xsl:apply-templates select="@*"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  
  <xsl:template match="*[local-name()='img']" mode="added-data">
    <xsl:element name="span" namespace="http://www.w3.org/1999/xhtml">
      <xsl:attribute name="class">deltaxml-new-img</xsl:attribute>
      <xsl:element name="img" namespace="http://www.w3.org/1999/xhtml">
        <xsl:attribute name="style" namespace=""><xsl:value-of select="$new-img-style"/></xsl:attribute>
        <xsl:apply-templates select="@*"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <!-- Deal with any elements deleted where formatted text is not allowed -->
  
  <!-- For these elements, output changes delimited by [] or similar -->
  <xsl:template match="*[local-name()='textarea' or local-name()='title' or
                        local-name()='option']" mode="deleted-data">
   <xsl:variable name="element-name">
    <xsl:call-template name="find-element-name">
      <xsl:with-param name="element" select="."/>
    </xsl:call-template>
   </xsl:variable>
   <xsl:element name="{$element-name}" namespace="http://www.w3.org/1999/xhtml">
    <xsl:apply-templates select="@*"/>
    <xsl:text>-[[</xsl:text>
    <xsl:value-of select="text()"/>
    <xsl:text>]]-</xsl:text>
   </xsl:element>
  </xsl:template>

  <!-- For these elements, we output the new data and ignore old so that we
    ensure that the data is valid. So old data here is lost -->
  <xsl:template match="*[local-name()='script' or 
                         local-name()='style' or
                         local-name()='area' or
                         local-name()='base' or
                         local-name()='basefont' or
                         local-name()='br' or
                         local-name()='hr' or
                         local-name()='input' or
                         local-name()='isindex' or
                         local-name()='link' or
                         local-name()='meta' or
                         local-name()='param'] " mode="deleted-data">
  </xsl:template>


  <!-- Deal with any elements where formatted text is not allowed -->
  
  <!-- For these elements, output changes delimited by [] or similar -->
  <xsl:template match="*[local-name()='textarea' or local-name()='title' or
                        local-name()='option']">
   <xsl:variable name="element-name">
    <xsl:call-template name="find-element-name">
      <xsl:with-param name="element" select="."/>
    </xsl:call-template>
   </xsl:variable>
   <xsl:element name="{$element-name}" namespace="http://www.w3.org/1999/xhtml">
    <xsl:apply-templates select="@*"/>
     <xsl:apply-templates select="node()" mode="delimited-text-only-data"/>
   </xsl:element>
  </xsl:template>

  <xsl:template match="text()" mode="delimited-text-only-data">
    <xsl:value-of select="."/>
  </xsl:template>
  
  <xsl:template match="deltaxml:PCDATAmodify" mode="delimited-text-only-data">
  <!-- output the old and new text with special text to separate them -->
    <xsl:text>-[[</xsl:text>
    <xsl:value-of select="./deltaxml:PCDATAold/text()"/>
    <xsl:text>]]- +[[</xsl:text>
    <xsl:value-of select="./deltaxml:PCDATAnew/text()"/>
    <xsl:text>]]+</xsl:text>
  </xsl:template>

  <!-- For these elements, we output the new data and ignore old so that we
    ensure that the data is valid. So old data here is lost -->
  <xsl:template match="*[local-name()='script' or 
                         local-name()='style'] ">
   <xsl:variable name="element-name">
    <xsl:call-template name="find-element-name">
      <xsl:with-param name="element" select="."/>
    </xsl:call-template>
   </xsl:variable>
   <xsl:element name="{$element-name}" namespace="http://www.w3.org/1999/xhtml">
    <xsl:apply-templates select="@*"/>
     <xsl:apply-templates select="node()" mode="new-text-only-data"/>
   </xsl:element>
  </xsl:template>

  <xsl:template match="deltaxml:comment">
    <xsl:comment>
      <xsl:apply-templates/>
    </xsl:comment>
  </xsl:template>
  
  <xsl:template match="deltaxml:comment" mode="new-text-only-data">
    <xsl:comment>
      <xsl:apply-templates/>
    </xsl:comment>
  </xsl:template>

  <xsl:template match="text()" mode="new-text-only-data">
    <xsl:value-of select="."/>
  </xsl:template>

  <xsl:template match="deltaxml:PCDATAmodify" mode="new-text-only-data">
  <!-- output the new text only -->
    <xsl:value-of select="./deltaxml:PCDATAnew/text()"/>
  </xsl:template>


  <!-- Finds and returns the correct element name, returing it without prefix
  if this is in XHTML namespace -->
  <xsl:template name="find-element-name">
   <xsl:param name="element"/>
   <xsl:choose>
    <xsl:when test="namespace-uri($element)='http://www.w3.org/1999/xhtml'">
      <xsl:value-of select="local-name($element)"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="name($element)"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:template>

  <!-- Attribute handling -->
  
  <!-- Write out new attribute values as the 'real' attributes -->
  <xsl:template match="@deltaxml:new-attributes">
    <xsl:call-template name="write-out-changed-attributes">
      <xsl:with-param name="changed-value-string" select="."/>
    </xsl:call-template>
  </xsl:template>

  <!-- Remove deltaxml:delta and other delta attributes for normal mode, added mode and deleted mode-->
  <xsl:template match="@deltaxml:delta |  @deltaxml:old-attributes |
                       @deltaxml:key | @deltaxml:ordered | 
                       @deltaxml:comment | @deltaxml:word-by-word | @deltaxml:format "/>
    
  <xsl:template match="@deltaxml:delta |  @deltaxml:old-attributes |
                       @deltaxml:key | @deltaxml:ordered | 
                       @deltaxml:comment | @deltaxml:word-by-word | @deltaxml:format" mode="deleted-data"/>
    
  <xsl:template match="@deltaxml:delta |  @deltaxml:old-attributes |
                       @deltaxml:key | @deltaxml:ordered | 
                       @deltaxml:comment | @deltaxml:word-by-word | @deltaxml:format" mode="added-data"/>

  <!-- Write out other attributes -->
  <xsl:template match="@*">
    <xsl:copy-of select="."/>
  </xsl:template>

  <!-- writes out any changed attributes, calling itself recursively to process
  the full list of attributes -->
  <xsl:template name="write-out-changed-attributes">
    <!-- the deltaxml:new-attributes or deltaxml:old-attributes changed values -->
    <xsl:param name="changed-value-string"/>
  
    <!-- structure of each attribute is "name1='value' name2=[value2[ ..." so delimiters
         may be any character -->
    <xsl:variable name="attribute-name" 
                  select="normalize-space(substring-before($changed-value-string, '='))"/>
    <xsl:variable name="attribute-value-delimiter" 
                  select="substring(substring-after($changed-value-string, '='),1,1)"/>
    <xsl:variable name="attribute-value-and-rest" 
                  select="substring-after($changed-value-string, $attribute-value-delimiter)"/>
    <xsl:variable name="first-value" 
                  select="substring-before($attribute-value-and-rest, $attribute-value-delimiter)"/>
    <xsl:variable name="rest" 
                  select="substring-after($attribute-value-and-rest, $attribute-value-delimiter)"/>
    <xsl:if test="string-length($attribute-name) > 0">
      <!-- then we have an attribute here, so write it out -->
      <xsl:attribute name="{$attribute-name}">
        <xsl:value-of select="$first-value"/>
      </xsl:attribute>
    </xsl:if>
    <!-- Now recurse to do the rest of the changed attributes -->
    <xsl:if test="string-length(normalize-space($rest)) > 0">
      <xsl:call-template name="write-out-changed-attributes">
        <xsl:with-param name="changed-value-string" select="$rest"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
