<?xml version="1.0" encoding="iso-8859-1"?>
<!-- Copyright (c) 2002, 2005 DeltaXML Ltd. All rights reserved -->
<!-- Use subject to the conditions in the included file: LICENSE.bsd -->
<!-- $Id: xhtml-infilter.xsl 4527 2008-06-10 16:35:27Z nigelw $ -->
<!--
    This stylesheet demonstrates how deltaxml:ordered and deltaxml:key
    attributes can be added to an XHTML document.

    Using this stylesheet to process XHTML files before they are
    compared with DeltaXML Markup will enable XHTML files to be
    compared intelligently. The filter also converts all ID attributes
    to keys so these are used to 'line up' corresponding items in the
    two files.

    See http://www.deltaxml.com/tech_details.html for a paper
    describing how these keys affect ordered and unordered comparison
    with DeltaXML.

    This code is offered as an example and may not be correct for
    handling all XHTML files.
  -->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns:deltaxml="http://www.deltaxml.com/ns/well-formed-delta-v1">
  
  <!-- Enable or disable extra whitespace on output -->
  <xsl:output method="xml" indent="no" />

  <!-- strip-space can be omitted if a single space in place of whitespace nodes is needed -->
  <xsl:strip-space elements="*"/>

  <!-- identity template -->
  <xsl:template match="node()|@*">
    <xsl:copy>
      <xsl:apply-templates select="node()|@*"/>
    </xsl:copy>
  </xsl:template>

  <!-- Handle specific element types here -->

  <!-- Add deltaxml:ordered="false" to unordered elements -->
  <xsl:template match="xhtml:head">
    <xsl:copy>
      <xsl:attribute name="deltaxml:ordered">false</xsl:attribute> 
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="xhtml:style|xhtml:pre">
    <xsl:copy>
      <xsl:attribute name="deltaxml:word-by-word">false</xsl:attribute>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="xhtml:style/comment()">
    <xsl:element name="deltaxml:comment">
      <xsl:value-of select="."/>
    </xsl:element>
  </xsl:template>

  <!--
    We have to delete the col and colgroup info because otherwise we could get
    incorrect XHTML out. This may lose some formatting info. Could do something more complex
    later, i.e. split into canonical form as <col> elements 
  -->
  <xsl:template match="xhtml:col | xhtml:colgroup"/>
  
  <!-- add a deltaxml:format attribute to all formatting elements -->
  <xsl:template match="xhtml:em | 
                       xhtml:strong | 
                       xhtml:dfn |
                       xhtml:code |
                       xhtml:samp |
                       xhtml:kbd |
                       xhtml:var |
                       xhtml:cite |
                       xhtml:abbr |
                       xhtml:acronym |
                       xhtml:q |
                       xhtml:sub |
                       xhtml:sup |
                       xhtml:tt |
                       xhtml:i |
                       xhtml:b |
                       xhtml:big |
                       xhtml:small |
                       xhtml:u |
                       xhtml:s |
                       xhtml:strike|
                       xhtml:span |
                       xhtml:basefont | 
                       xhtml:font">
    <xsl:copy>
      <xsl:attribute name="deltaxml:format">true</xsl:attribute>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  
  <!-- For every id attribute, use the value as a key. Also applies to @name in meta tag -->
  <xsl:template match="@id | xhtml:meta/@name">
    <!-- add a deltaxml:key="XX" attribute, with the same value as the id attribute,
         then copy the original attribute -->
    <xsl:attribute name="deltaxml:key">
      <xsl:value-of select="normalize-space(.)"/>
    </xsl:attribute>
    <xsl:attribute name="{name()}">
      <xsl:value-of select="."/>
    </xsl:attribute>
  </xsl:template>

</xsl:stylesheet>
