<?xml version="1.0" encoding="UTF-8"?>
<!-- $Id: remove-exchange.xsl 4592 2008-07-24 09:08:03Z tristanm $ -->
<!-- Copyright 2007 DeltaXML Ltd. All rights reserved -->
<!-- 
This stylesheet removes deltaxml:exchange elements and outputs their contents
appropriately, i.e. as added/deleted elements or deltaxml:PCDATAmodify elements.

More specifically, this filter will convert 
<deltaxml:exchange>
  <deltaxml:old>
    <a deltaxml:delta="delete"/>
  </deltaxml:old>
  <deltaxml:new>
    <b deltaxml:delta="add"/>
  </deltaxml:new>
</deltaxml:exchange>

into

<a deltaxml:delta="delete"/>
<b deltaxml:delta="add"/>

and 

  <deltaxml:exchange>
    <deltaxml:old>text</deltaxml:old>
    <deltaxml:new>
    <b deltaxml:delta="add"/>
    </deltaxml:new>
  </deltaxml:exchange>

into

<deltaxml:PCDATAmodify>
  <deltaxml:PCDATAold>text</deltaxml:PCDATAold>
  <deltaxml:PCDATAnew/>
</deltaxml:PCDATAmodify>
<b deltaxml:delta="add"/>

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:deltaxml="http://www.deltaxml.com/ns/well-formed-delta-v1"
                version="1.0">
  
  <!-- default match -->
  <xsl:template match="node()|@*">
    <xsl:copy>
      <xsl:apply-templates select="node()|@*"/>
    </xsl:copy>
  </xsl:template>
  
  <!-- match an element exchange -->
  <xsl:template match="deltaxml:exchange[deltaxml:old/*][deltaxml:new/*]">
    <xsl:apply-templates select="deltaxml:old/*"/>
    <xsl:apply-templates select="deltaxml:new/*"/>
  </xsl:template>
  
  <!-- match a text-element exchange -->
  <xsl:template match="deltaxml:exchange[not(deltaxml:old/*)][deltaxml:new/*]">
    <deltaxml:PCDATAmodify>
      <deltaxml:PCDATAold><xsl:value-of select="deltaxml:old"/></deltaxml:PCDATAold>
      <deltaxml:PCDATAnew/>
    </deltaxml:PCDATAmodify>
    <xsl:apply-templates select="deltaxml:new/*"/>
  </xsl:template>
  
  <!-- match an element-text exchange -->
  <xsl:template match="deltaxml:exchange[deltaxml:old/*][not(deltaxml:new/*)]">
    <xsl:apply-templates select="deltaxml:old/*"/>
    <deltaxml:PCDATAmodify>
      <deltaxml:PCDATAold/>
      <deltaxml:PCDATAnew><xsl:value-of select="deltaxml:new"/></deltaxml:PCDATAnew>
    </deltaxml:PCDATAmodify>
  </xsl:template>
  
  <!-- 
    If this filter runs after the WBW filters, it may have converted an element exchange,
    e.g word with punctuation, into a PCDATA only exchange. We need to handle that case 
    for completeness. However, this may cause a situation where we need to run WBWOut2 again
  -->
  
  <xsl:template match="deltaxml:exchange[not(deltaxml:old/*)][not(deltaxml:new/*)]">
    <deltaxml:PCDATAmodify>
      <deltaxml:PCDATAold><xsl:value-of select="deltaxml:old"/></deltaxml:PCDATAold>
      <deltaxml:PCDATAnew><xsl:value-of select="deltaxml:new"/></deltaxml:PCDATAnew>
    </deltaxml:PCDATAmodify>
  </xsl:template>
  
</xsl:stylesheet>
