<?xml version="1.0" encoding="iso-8859-1"?>
<!-- Copyright (c) 2004-2005 DeltaXML Ltd. All rights reserved. -->
<!-- Use subject to the conditions in the included file: LICENSE.bsd -->
<!-- $Id: normalize-space.xsl 4527 2008-06-10 16:35:27Z nigelw $ -->
<!--
    This stylesheet normalizes space in PCDATA and attributes in an
    XML file.  Unlike the standard definition of the XSLT
    normalize-space function, whitspace at the start or end of PCDATA
    nodes is replaced by a single space, and not removed altogether.

    By changing the xsl:strip-space and xsl:preserve-space values, the
    script can be changed to handle whitespace nodes (text nodes with
    all whitespace between successive elements) by replacing them with
    a single space.

    WARNING: This template attempts to adhere to xml:space='preserve'
    attribute settings in any data is processes.  According to our
    understanding of the XSLT specification xsl:space='preserve'
    should override any action of xsl:strip-space.  We have found this
    to be the case with the Saxon processor, but not with Xalan-J.
    Therefore we strongly recommend the use of Saxon when any input
    data uses xml:space attributes.
  -->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- No extra whitespace on output -->
  <xsl:output method="xml" indent="no" />
  
  <xsl:param name="normalizeAttValues" select="'true'"/>
  
  <!-- The presence of this declaration causes text-only whitespace
       (or 'whitespace between elements') to be completely removed
       before comparison.  If this declaration is not present
       then rather than being completely removed, text-only whitespace
       will be replaced by a single space (by the 2nd when branch
       of the text() template below).  Also see Saxon/Xalan warning above -->
  <xsl:strip-space elements="*"/>

  <!-- If element names are added to the attribute below, any text-only
       whitespace nodes which they contain will be replaced
       by a single space character prior to comparison. -->
  <!--xsl:preserve-space elements=""/-->

  <!-- identity template for elements, note separate template for @*, so not 
       default/standard identity template -->
  <xsl:template match="*">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>


  <xsl:template match="text()">
    <xsl:variable name="normalized-text" select="normalize-space()"/>
    <xsl:variable name="input-text" select="."/>
    <xsl:choose>
      <xsl:when test="ancestor-or-self::*[@xml:space][1][./@xml:space='preserve']">
        <!-- if a text node itself has, or has an ancestor with, xml:space attribute and
             if the nearest ancestor has the attribute with value 'preserve',
             output exact PCDATA node -->
        <xsl:copy-of select="."/>
      </xsl:when>
      <xsl:when test="string-length($normalized-text) = 0">
        <!-- The PCDATA is all whitespace, just output a single space -->
        <xsl:text> </xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <!-- mixed whitespace and text in PCDATA which is normalized, but with leading and trailing
             (single) whitespace preservation -->
        <xsl:if test="substring($normalized-text, 1, 1) != substring($input-text, 1, 1)">
          <!-- If the first character of the non-normalized text is different from the first character
               of the normalized version, then the non-normalized one must have started with whitespace -->
          <xsl:text> </xsl:text>
        </xsl:if>
        <xsl:value-of select="$normalized-text"/>
        <xsl:if test="substring($normalized-text, string-length($normalized-text), 1) !=
                      substring($input-text, string-length($input-text), 1)">
          <!-- If the last character of the non-normalized text is different from the last character
               of the normalized version, then the non-normalized one must have eneded with whitespace -->
          <xsl:text> </xsl:text>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- Normalize space on attributes -->
  <xsl:template match="@*">
    <xsl:variable name="attr-namespace" select="namespace-uri()"/>
    <xsl:choose> 
      <xsl:when test="$normalizeAttValues='true'">
        <xsl:choose>
          <xsl:when test="string-length($attr-namespace)>0">
            <xsl:attribute name="{local-name()}" namespace="{namespace-uri()}">
              <xsl:value-of select="normalize-space()"/>
            </xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="{local-name()}">
              <xsl:value-of select="normalize-space()"/>
            </xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
