<?xml version="1.0" encoding="iso-8859-1"?>
<!-- Copyright 2002-2007 DeltaXML Ltd. All rights reserved. 
     $Id: docbook-outfilter.xsl 4527 2008-06-10 16:35:27Z nigelw $ 
     
  This stylesheet takes a docbook delta file, i.e. the result of comparing two
  docbook files, and generates another standard docbook file which shows the 
  differences using the revisionflag attribute.
  
  This is an example only and may not work correctly for all input files.
  
  The output file will have 
  - elements added will have revisionflag="added"
  - elements deleted will have revisionflag="deleted"
  - elements that can contain modified text but NOT the <phrase> element will have revisionflag="changed"
  
  Any PCDATA item that is added or deleted is converted to a 'phrase' element because it has to be enclosed in a tag. This is in line with the intended use of phrase.
  
  We always write out attributes as per the new file.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:deltaxml="http://www.deltaxml.com/ns/well-formed-delta-v1" 
                version="1.0">
  
  <xsl:output method="xml"/>

  <xsl:variable name="program">Generated by docbook-outfilter.xsl</xsl:variable>
  
  <!-- When set to 'yes', whitspace-only changes are ignored where possible -->
  <xsl:param name="ignore-whitespace-only-changes" select="'yes'"/>
  
  <!-- When set to 'yes', changes in nodes that cannot contain a <phrase> element are ignored -->
  <xsl:param name="ignore-changes-in-non-phrase-elements" select="'yes'"/>
  
  <!-- Text used to prefix/suffix added/deleted text when <phrase> cannot be used  -->
  <xsl:param name="prefix-added-text" select="'+[['"/>
  <xsl:param name="suffix-added-text" select="']]+'"/>
  <xsl:param name="prefix-deleted-text" select="'-[['"/>
  <xsl:param name="suffix-deleted-text" select="']]-'"/>
  
  <!-- There are basically four modes:
  - process unchanged data by copying to output
  - process added data by copying to output, with revisionflag="added" added to the top element of the added tree.
  - process deleted data by copying to output, with revisionflag="deleted" added to the top element of the deleted tree.
  - process modified data, treating each child to see which of the above apply

-->
  <xsl:template match="/">
    <xsl:text>
</xsl:text>
    <xsl:comment>
      <xsl:value-of select="$program"/>
    </xsl:comment>
    <xsl:text>
</xsl:text>
    <xsl:comment>Using XSL Processor: <xsl:value-of select="system-property('xsl:vendor')"/></xsl:comment>
    <xsl:comment> This file has been produced by the DeltaXML.com toolset. Please visit http://www.deltaxml.com/ to learn more about these tools. </xsl:comment>
    <xsl:apply-templates/>
  </xsl:template>
  
  <!-- Basic transform is to do a copy -->
  <xsl:template match="*">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  
  <xsl:template match="text()">
    <xsl:copy-of select="."/>
  </xsl:template>
  
  <xsl:template match="*" mode="added-data">
    <xsl:copy>
      <xsl:attribute name="revisionflag" namespace="">added</xsl:attribute>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates select="node()"/>
    </xsl:copy>
  </xsl:template>
  
  <xsl:template match="*" mode="deleted-data">
    <xsl:copy>
      <xsl:attribute name="revisionflag" namespace="">deleted</xsl:attribute>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates select="node()"/>
    </xsl:copy>
  </xsl:template>
  
  <!-- items that are allowed PCDATA but not <phrase> elements should always be marked as changed -->
  <xsl:template match="*[@deltaxml:delta='WFmodify']
						            [local-name()='abbrev' or
                         local-name()='accel' or
                         local-name()='ackno' or
                         local-name()='acronym' or
                         local-name()='action' or 
                         local-name()='alt' or
                         local-name()='arg' or
                         local-name()='audiodata' or
                         local-name()='biblioid' or
                         local-name()='bibliomixed' or
                         local-name()='bibliomset' or
                         local-name()='biblioref' or 
                         local-name()='bibliorelation' or
                         local-name()='bibliosource' or
                         local-name()='caption' or
                         local-name()='city' or
                         local-name()='classname' or
                         local-name()='code' or
                         local-name()='command' or
                         local-name()='computeroutput' or
                         local-name()='confdates' or
                         local-name()='confnum' or
                         local-name()='confsponsor' or
                         local-name()='conftitle' or
                         local-name()='constant' or
                         local-name()='contractnum' or
                         local-name()='contractsponsor' or
                         local-name()='contrib' or
                         local-name()='coref' or
                         local-name()='corpauthor' or
                         local-name()='corpcredit' or
                         local-name()='corpname' or
                         local-name()='country' or
                         local-name()='database' or
                         local-name()='date' or
                         local-name()='edition' or
                         local-name()='email' or
                         local-name()='envar' or
                         local-name()='errorcode' or
                         local-name()='errorname' or
                         local-name()='errortext' or
                         local-name()='errortype' or
                         local-name()='exceptionname' or
                         local-name()='fax' or
                         local-name()='filename' or
                         local-name()='firstname' or
                         local-name()='footnoteref' or
                         local-name()='funcdef' or
                         local-name()='funcparams' or
                         local-name()='function' or
                         local-name()='graphic' or
                         local-name()='guibutton' or
                         local-name()='guiicon' or
                         local-name()='guilabel' or
                         local-name()='guimenu' or
                         local-name()='guimenuitem' or
                         local-name()='guisubmenu' or
                         local-name()='holder' or
                         local-name()='honorific' or
                         local-name()='imagedata' or
                         local-name()='initializer' or
                         local-name()='interface' or
                         local-name()='invpartnumber' or
                         local-name()='isbn' or
                         local-name()='issn' or
                         local-name()='issuenum' or
                         local-name()='jobtitle' or
                         local-name()='keycode' or
                         local-name()='keysym' or
                         local-name()='label' or
                         local-name()='lineage' or
                         local-name()='link' or
                         local-name()='literal' or
                         local-name()='manvolnum' or
                         local-name()='markup' or
                         local-name()='mathphrase' or
                         local-name()='medialabel' or
                         local-name()='methodname' or
                         local-name()='modifier' or
                         local-name()='mousebutton' or
                         local-name()='msglevel' or
                         local-name()='msgorig' or
                         local-name()='option' or
                         local-name()='orgdiv' or
                         local-name()='orgname' or
                         local-name()='otheraddr' or
                         local-name()='othername' or
                         local-name()='package' or
                         local-name()='pagenums' or
                         local-name()='paramdef' or
                         local-name()='parameter' or
                         local-name()='phone' or
                         local-name()='pob' or
                         local-name()='postcode' or
                         local-name()='productnumber' or
                         local-name()='prompt' or
                         local-name()='property' or
                         local-name()='pubdate' or
                         local-name()='publishername' or
                         local-name()='pubsnumber' or
                         local-name()='refclass' or
                         local-name()='refdescriptor' or
                         local-name()='refmiscinfo' or
                         local-name()='refname' or
                         local-name()='releaseinfo' or
                         local-name()='replaceable' or
                         local-name()='returnvalue' or
                         local-name()='seriesvolnums' or
                         local-name()='sgmltag' or
                         local-name()='shortaffil' or
                         local-name()='state' or 
                         local-name()='street' or
                         local-name()='structfield' or
                         local-name()='structname' or
                         local-name()='subscript' or
                         local-name()='superscript' or
                         local-name()='surname' or
                         local-name()='symbol' or
                         local-name()='systemitem' or
                         local-name()='textdata' or
                         local-name()='token' or
                         local-name()='trademark' or
                         local-name()='type' or
                         local-name()='ulink' or
                         local-name()='uri' or
                         local-name()='userinput' or
                         local-name()='varname' or
                         local-name()='videodata' or
                         local-name()='volumenum' or
                         local-name()='wordasword' or
                         local-name()='xref' or
                         local-name()='year'] "
                         priority="1">
    <xsl:copy>
      <xsl:attribute name="revisionflag" namespace="">changed</xsl:attribute>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates select="node()"/>
    </xsl:copy>
  </xsl:template>
  
  <!-- These are the places where phrase is allowed. -->
  <xsl:template match="deltaxml:line/deltaxml:PCDATAmodify |
                       application/deltaxml:PCDATAmodify |
                       attribution/deltaxml:PCDATAmodify |
                       bridgehead/deltaxml:PCDATAmodify |
                       citation/deltaxml:PCDATAmodify | 
                       citetitle/deltaxml:PCDATAmodify |
                       classsynopsisinfo/deltaxml:PCDATAmodify |
                       emphasis/deltaxml:PCDATAmodify |
                       entry/deltaxml:PCDATAmodify |
                       firstterm/deltaxml:PCDATAmodify |
                       foreignphrase/deltaxml:PCDATAmodify |
                       funcsynopsisinfo/deltaxml:PCDATAmodify |
                       glosssee/deltaxml:PCDATAmodify |
                       glossseealso/deltaxml:PCDATAmodify |
                       glossterm/deltaxml:PCDATAmodify |
                       button/deltaxml:PCDATAmodify |
                       label/deltaxml:PCDATAmodify |
                       link/deltaxml:PCDATAmodify |
                       literallayout/deltaxml:PCDATAmodify |
                       member/deltaxml:PCDATAmodify |
                       orgdiv/deltaxml:PCDATAmodify |
                       para/deltaxml:PCDATAmodify |
                       phrase/deltaxml:PCDATAmodify |
                       primary/deltaxml:PCDATAmodify |
                       primaryie/deltaxml:PCDATAmodify |
                       programlisting/deltaxml:PCDATAmodify |
                       quote/deltaxml:PCDATAmodify |
                       refdescriptor/deltaxml:PCDATAmodify |
                       refentrytitle/deltaxml:PCDATAmodify |
                       refname/deltaxml:PCDATAmodify |
                       refpurpose/deltaxml:PCDATAmodify |
                       screen/deltaxml:PCDATAmodify |
                       secondary/deltaxml:PCDATAmodify |
                       secondaryie/deltaxml:PCDATAmodify |
                       see/deltaxml:PCDATAmodify |
                       seealso/deltaxml:PCDATAmodify |
                       seealsoie/deltaxml:PCDATAmodify |
                       seeie/deltaxml:PCDATAmodify |
                       seg/deltaxml:PCDATAmodify |
                       segtitle/deltaxml:PCDATAmodify |
                       simpara/deltaxml:PCDATAmodify |
                       subtitle/deltaxml:PCDATAmodify |
                       synopsis/deltaxml:PCDATAmodify |
                       td/deltaxml:PCDATAmodify |
                       term/deltaxml:PCDATAmodify |
                       termdef/deltaxml:PCDATAmodify |
                       tertiary/deltaxml:PCDATAmodify |
                       tertiaryie/deltaxml:PCDATAmodify |
                       textobject/deltaxml:PCDATAmodify |
                       th/deltaxml:PCDATAmodify |
                       title/deltaxml:PCDATAmodify |
                       titleabbrev/deltaxml:PCDATAmodify |
                       tocentry/deltaxml:PCDATAmodify">
    <xsl:variable name="old-data" select="deltaxml:PCDATAold/text()"/>
    <xsl:variable name="new-data" select="deltaxml:PCDATAnew/text()"/>
    <xsl:choose>
      <xsl:when test="$ignore-whitespace-only-changes='yes' and (normalize-space($old-data) = normalize-space($new-data))">
        <xsl:value-of select="$new-data"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="string-length($old-data)>0">
          <xsl:element name="phrase" namespace="">
            <xsl:attribute name="revisionflag" namespace="">deleted</xsl:attribute>
            <xsl:value-of select="$old-data"/>
          </xsl:element>
        </xsl:if>
        
        <xsl:if test="string-length($new-data)>0">
          <xsl:element name="phrase" namespace="">
            <xsl:attribute name="revisionflag" namespace="">added</xsl:attribute>
            <xsl:value-of select="$new-data"/>
          </xsl:element>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- Here, <phrase> is not a permitted element, so only text allowed -->
  <xsl:template match="deltaxml:PCDATAmodify">
    <xsl:variable name="old-data" select="deltaxml:PCDATAold/text()"/>
    <xsl:variable name="new-data" select="deltaxml:PCDATAnew/text()"/>
    <xsl:choose>
      <xsl:when test="$ignore-whitespace-only-changes='yes' and (normalize-space($old-data) = normalize-space($new-data))">
        <xsl:value-of select="$new-data"/>
      </xsl:when>
      <xsl:when test="$ignore-changes-in-non-phrase-elements='yes'">
        <xsl:value-of select="$new-data"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="string-length($old-data)>0">
          <xsl:value-of select="$prefix-deleted-text"/>
          <xsl:value-of select="$old-data"/>
          <xsl:value-of select="$suffix-deleted-text"/>
        </xsl:if>
        
        <xsl:if test="string-length($new-data)>0">
          <xsl:value-of select="$prefix-added-text"/>
          <xsl:value-of select="$new-data"/>
          <xsl:value-of select="$suffix-added-text"/>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="deltaxml:exchange">
    <xsl:apply-templates select="deltaxml:old/node()" mode="deleted-data"/>
    <xsl:apply-templates select="deltaxml:new/node()" mode="added-data"/>
  </xsl:template>
  
  <!-- process any line-by-line data -->
  <xsl:template match="deltaxml:line[@deltaxml:delta='add']">
    <xsl:apply-templates mode="added-data" select="node()"/>
  </xsl:template>
  
  <xsl:template match="deltaxml:line[@deltaxml:delta='delete']">
    <xsl:apply-templates mode="deleted-data" select="node()"/>
  </xsl:template>
  
  <xsl:template match="deltaxml:line[@deltaxml:delta='WFmodify']">
    <xsl:apply-templates select="node()"/>
  </xsl:template>
  
  <xsl:template match="deltaxml:line[@deltaxml:delta='WFmodifyUnordered']">
    <xsl:apply-templates select="node()"/>
  </xsl:template>
  
  <xsl:template match="deltaxml:line[@deltaxml:delta='unchanged']">
    <xsl:apply-templates select="node()"/>
  </xsl:template>
  
  <xsl:template match="deltaxml:line[@deltaxml:delta][not(@deltaxml:delta='add' or @deltaxml:delta='delete'
         or @deltaxml:delta='WFmodify' or @deltaxml:delta='WFmodifyUnordered' or @deltaxml:delta='unchanged')]">
    <xsl:message terminate="yes"> Unknown value for deltaxml:delta: <xsl:value-of select="@deltaxml:delta"/>
    </xsl:message>
  </xsl:template>
  
  <xsl:template match="deltaxml:line[not(@deltaxml:delta)]">
    <xsl:apply-templates select="node()"/>
  </xsl:template>
  
  <xsl:template match="deltaxml:line" mode="added-data">
    <xsl:apply-templates select="node()" mode="added-data"/>
  </xsl:template>
  
  <xsl:template match="deltaxml:line" mode="deleted-data">
    <xsl:apply-templates select="node()" mode="deleted-data"/>
  </xsl:template>
  
  <!-- process any added node -->
  <xsl:template match="*[not(self::deltaxml:line)][@deltaxml:delta='add']">
    <xsl:apply-templates mode="added-data" select="."/>
  </xsl:template>
  
  <!-- Write out all attributes -->
  <xsl:template match="@*" mode="added-data">
    <xsl:copy-of select="."/>
  </xsl:template>
  
  <xsl:template match="text()" mode="added-data">
    <xsl:element name="phrase" namespace="">
      <xsl:attribute name="revisionflag" namespace="">added</xsl:attribute>
      <xsl:copy-of select="."/>
    </xsl:element>
  </xsl:template>
  
  <!-- Comments need to be put back as comments, no changes shown -->
  <xsl:template match="deltaxml:comment[@deltaxml:delta='delete']"/>
  
  <xsl:template match="deltaxml:comment[@deltaxml:delta='add']">
    <xsl:comment>
      <xsl:value-of select="text()"/>
    </xsl:comment>
  </xsl:template>
  
  <xsl:template match="deltaxml:comment[@deltaxml:delta='WFmodify']">
    <xsl:comment>
      <xsl:value-of select="text() | deltaxml:PCDATAmodify/deltaxml:PCDATAnew/text()"/>
    </xsl:comment>
  </xsl:template>
  
  <!-- process any deleted node -->
  <xsl:template match="*[not(self::deltaxml:line)][@deltaxml:delta='delete']">
    <xsl:apply-templates mode="deleted-data" select="."/>
  </xsl:template>
  
  <xsl:template match="text()" mode="deleted-data">
    <xsl:element name="phrase" namespace="">
      <xsl:attribute name="revisionflag" namespace="">deleted</xsl:attribute>
      <xsl:copy-of select="."/>
    </xsl:element>
  </xsl:template>
  
  <!-- Process other elements with deltaxml:delta attribute -->
  <xsl:template match="*[not(self::deltaxml:line)]
                        [@deltaxml:delta='unchanged' or 
                         @deltaxml:delta='WFmodify' or
                         @deltaxml:delta='WFmodifyUnordered']">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  
  <!-- Attribute handling -->
  <!-- Write out new attribute values as the 'real' attributes -->
  <xsl:template match="@deltaxml:new-attributes">
    <xsl:call-template name="write-out-changed-attributes">
      <xsl:with-param name="changed-value-string" select="."/>
    </xsl:call-template>
  </xsl:template>
  
  <!-- Remove deltaxml:delta and other delta attributes -->
  <xsl:template match="@deltaxml:delta |  @deltaxml:old-attributes |
                       @deltaxml:key | @deltaxml:ordered | 
                       @deltaxml:comment | @deltaxml:word-by-word "/>
                     
  <!-- Write out other attributes -->
  <xsl:template match="@*">
    <xsl:copy-of select="."/>
  </xsl:template>
  
  <!-- writes out any changed attributes, calling itself recursively to process
       the full list of attributes -->
  <xsl:template name="write-out-changed-attributes">
    <!-- the deltaxml:new-attributes or deltaxml:old-attributes changed values -->
    <xsl:param name="changed-value-string"/>
    <!-- structure of each attribute is "name1='value' name2=[value2[ ..." so delimiters
         may be any character -->
    <xsl:variable name="attribute-name" select="normalize-space(substring-before($changed-value-string, '='))"/>
    <xsl:variable name="attribute-value-delimiter" select="substring(substring-after($changed-value-string, '='),1,1)"/>
    <xsl:variable name="attribute-value-and-rest" select="substring-after($changed-value-string, $attribute-value-delimiter)"/>
    <xsl:variable name="first-value" select="substring-before($attribute-value-and-rest, $attribute-value-delimiter)"/>
    <xsl:variable name="rest" select="substring-after($attribute-value-and-rest, $attribute-value-delimiter)"/>
    <xsl:if test="string-length($attribute-name) > 0">
      <!-- then we have an attribute here, so write it out -->
      <xsl:attribute name="{$attribute-name}">
        <xsl:value-of select="$first-value"/>
      </xsl:attribute>
    </xsl:if>
    <!-- Now recurse to do the rest of the changed attributes -->
    <xsl:if test="string-length(normalize-space($rest)) > 0">
      <xsl:call-template name="write-out-changed-attributes">
        <xsl:with-param name="changed-value-string" select="$rest"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
</xsl:stylesheet>
