<?xml version="1.0" encoding="iso-8859-1"?>
<!-- Copyright (c) 2001-2005 DeltaXML Ltd. All rights reserved -->
<!-- Use subject to the conditions in the included file: LICENSE.bsd -->
<!-- $Id: deltaxml-merge.xsl 4527 2008-06-10 16:35:27Z nigelw $ -->

<!--
This stylesheet converts a full delta file, produced by deltaXML programs,
into a merged file. The merged file will have all the elements and attributes
from both input files. In cases where this is not desired, the stylesheet can be
modified. PCDATA is written out with a delimiter to show old and new data, and
again this can be changed as needed in specific circumstances.

Note that this is a simple merge of two files. It is NOT a 3-way merge, which
is much more complex but is also possible usiing DeltaXML.
-->

<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:deltaxml="http://www.deltaxml.com/ns/well-formed-delta-v1"
  xmlns:dxwarn="http://www.deltaxml.com/ns/warning-for-2-way-merge">

<!-- change indent to "yes" for pretty-printed output where white space is not critical,
or to "no" if white space is critical and you do not want any added -->
<xsl:output method="xml" indent="no"
	encoding="UTF-8" />

<xsl:variable name="program">Generated by deltaxml-2way-merge.xsl</xsl:variable>

<!-- this variable is used to indicate no value for an attribute was found -->
<xsl:variable name="no-attribute-value-found">http://www.deltaxml.com/no-attribute-value-found</xsl:variable>

<xsl:template match="/">
 <xsl:text>
</xsl:text>
<xsl:comment> <xsl:value-of select="$program"/> </xsl:comment>
 <xsl:text>
</xsl:text>
<xsl:comment> This file has been produced by the DeltaXML.com toolset.
     Please visit http://www.deltaxml.com/ to learn more about these tools.
</xsl:comment>
 <xsl:apply-templates/>
</xsl:template>

<!-- Basic transform is to do a copy -->
<xsl:template match="@* | *">
 <xsl:copy>
  <xsl:apply-templates select="@*"/>
  <xsl:apply-templates/>
 </xsl:copy>
</xsl:template>

	
<!-- deal with modified elements -->
<xsl:template match="*[@deltaxml:delta='WFmodify'] | *[@deltaxml:delta='WFmodifyUnordered']">
 <xsl:call-template name="process-changed-node"/>
</xsl:template>

<!-- comments are removed -->
<xsl:template match="comment()">
</xsl:template>


<!-- Processes any node where the attributes may have changed -->
<xsl:template name="process-changed-node">
 <xsl:call-template name="process-changed-node-internal">
  <xsl:with-param name="new-attributes" select="@deltaxml:new-attributes"/>
  <xsl:with-param name="old-attributes" select="@deltaxml:old-attributes"/>
 </xsl:call-template>
</xsl:template>

<!-- Processes any node where the attributes may have changed -->
<xsl:template name="process-changed-node-internal">
 <xsl:param name="new-attributes" select="@deltaxml:new-attributes"/>
 <xsl:param name="old-attributes" select="@deltaxml:old-attributes"/>
 <xsl:copy>
  <!-- write all unchanged attributes out -->
  <xsl:apply-templates select="@*"/>
  <!-- now write out merged attributes -->
  <xsl:if test="$new-attributes | $old-attributes">
    <xsl:call-template name="write-merged-attributes">
     <xsl:with-param name="new-attributes" select="$new-attributes"/>
     <xsl:with-param name="old-attributes" select="$old-attributes"/>
    </xsl:call-template>
  </xsl:if>
  <!-- now write out the contents -->
  <xsl:apply-templates select="node()"/>
 </xsl:copy>
</xsl:template>

<!-- ATTRIBUTE handling
We have deltaxml:new-attributes and deltaxml:old-attributes
We need to write out any attributes that are in either but not both,
then we need to write out any that are in both noting a conflict.

The logic is as follows:
- find names of attributes in new-attributes, new-names
- find names of attributes in old-attributes, old-names
- write out all attributes in deltaxml:new-attributes
- find names of attributes in old-names but not in new-names, added-attributes
- write these out using values from deltaxml:old-attributes
- find names of attributes in old-names and in new-names, conflict-attributes
- write out these conflict values in dxwarn:old-attributes

Conflicts can be handled in two dxwarn attributes:
dxwarn:old-attributes which are attrs added in file1 which have a different value in file 2


-->
<!-- Processes any node where the attributes may have changed -->
<xsl:template name="write-merged-attributes">
 <xsl:param name="new-attributes" select="@deltaxml:new-attributes"/>
 <xsl:param name="old-attributes" select="@deltaxml:old-attributes"/>
 <xsl:variable name="new-names">
   <xsl:call-template name="all-attribute-names">
    <xsl:with-param name="delta-attribute-string" select="$new-attributes"/>
   </xsl:call-template>
 </xsl:variable>
 <xsl:variable name="old-names">
   <xsl:call-template name="all-attribute-names">
    <xsl:with-param name="delta-attribute-string" select="$old-attributes"/>
   </xsl:call-template>
 </xsl:variable>
  <!-- Now we can write out all of the attributes from new-attributes -->
 <xsl:call-template name="write-attribute-values">
 	<xsl:with-param name="delta-attribute-string" select="$new-attributes"/>
 	<xsl:with-param name="attribute-names" select="$new-names"/>
 </xsl:call-template>

 <xsl:variable name="added-attributes"> 
   <xsl:call-template name="nmtokens-set-difference">
    <xsl:with-param name="first-string" select="$old-names"/>
    <xsl:with-param name="second-string" select="$new-names"/>
   </xsl:call-template>
 </xsl:variable>
  <!-- Now we can write out these attributes from old-attributes -->
 <xsl:call-template name="write-attribute-values">
 	<xsl:with-param name="delta-attribute-string" select="$old-attributes"/>
 	<xsl:with-param name="attribute-names" select="$added-attributes"/>
 </xsl:call-template>
 
 <!-- note that any attribute in both must have different values in each,
 otherwise they would not appear at all in either new-attributes or old-attributes -->
 <xsl:variable name="conflict-attributes"> 
   <xsl:call-template name="nmtokens-set-intersection">
    <xsl:with-param name="first-string" select="$old-names"/>
    <xsl:with-param name="second-string" select="$new-names"/>
   </xsl:call-template>
 </xsl:variable>

 
  <xsl:if test="string-length(translate($conflict-attributes,' ',''))>0">
   <xsl:attribute name="dxwarn:old-attributes"
    namespace="http://www.deltaxml.com/ns/warning-for-2-way-merge">
    <xsl:call-template name="replace-attribute-name-with-name-and-value">
      <xsl:with-param name="delta-attribute-string" select="$old-attributes"/>
      <xsl:with-param name="attribute-name-string" 
					select="$conflict-attributes"/>
	</xsl:call-template>
	</xsl:attribute>
  </xsl:if>

</xsl:template>



<!-- elements with an 'add', 'delete' or unchanged attribute are copied out -->
<xsl:template 
  match="*[@deltaxml:delta='add'] | 
         *[@deltaxml:delta='delete'] |
         *[@deltaxml:delta='unchanged']">
 <xsl:copy>
  <xsl:apply-templates select="@*"/>
  <xsl:apply-templates/>
 </xsl:copy>
</xsl:template>



<!-- for an exchange element, the new and old item(s) are copied to the output, 
     unless the node is text and the parent indicates an update -->
<xsl:template match="deltaxml:exchange | deltaxml:old | deltaxml:new">
 <xsl:apply-templates/>
</xsl:template>


<!-- for PCDATAmodify, the new or old text is copied across to the output -->
<xsl:template match="deltaxml:PCDATAmodify">
   <!-- this means both elements ahd PCDATA present but different, so add warning here -->
   <dxwarn:PCDATAold><xsl:value-of select="deltaxml:PCDATAold/text()"/></dxwarn:PCDATAold>
 	<xsl:value-of select="deltaxml:PCDATAnew/text()"/>
</xsl:template>



<!-- This template keeps deltaxml:ordered and deltaxml:key attributes
     If you want them deleted, remove or comment out the body of this template -->
<xsl:template match="@deltaxml:ordered | @deltaxml:key">
	<xsl:copy-of select="."/>
</xsl:template>

<!-- This template ensures that the deltaxml: attributes are not written out because
     they are processed in other ways, or fixed -->
<xsl:template match="@*[starts-with(name(), 'deltaxml:')]"/>

<!-- This template keeps deltaxml:ordered and deltaxml:key attributes
     If you want them deleted, remove or comment out the body of this template -->
<xsl:template match="@deltaxml:ordered | @deltaxml:key" priority="1">
	<xsl:copy-of select="."/>
</xsl:template>


<!-- Attribute manipulation templates -->

<!-- Returns a string of all the attribute names in the delta-attribute-string -->
<xsl:template name="all-attribute-names">
 <xsl:param name="delta-attribute-string"/>
 <!-- find the name of the first attribute -->
  <xsl:variable name="first-attribute-name"
   select="normalize-space(substring-before($delta-attribute-string,'='))"/>
  <xsl:if test="string-length($first-attribute-name)>0">
   <xsl:variable name="attribute-value-delimiter"
    select="substring
                (substring-after($delta-attribute-string,'='),
                1,1)"/>
   <xsl:variable name="attribute-value-and-rest"
     select="substring-after($delta-attribute-string, $attribute-value-delimiter)"/>
   <xsl:variable name="other-attributes">
    <xsl:call-template name="all-attribute-names">
     <xsl:with-param name="delta-attribute-string"
       select="substring-after($attribute-value-and-rest, $attribute-value-delimiter)"/>
    </xsl:call-template>
   </xsl:variable>
   <xsl:value-of select="concat($first-attribute-name, ' ', $other-attributes)"/>
  </xsl:if>
</xsl:template>


<!-- Writes out the name and value of attributes whose names are in attribute-names,
taking the values from delta-attribute-string -->
<xsl:template name="write-attribute-values">
 <xsl:param name="delta-attribute-string"/>
 <xsl:param name="attribute-names"/>
 <!-- find the name of the first attribute -->
 <xsl:variable name="first-attribute-name"
   select="substring-before($attribute-names,' ')"/>
 <xsl:if test="string-length($first-attribute-name)>0">
 <xsl:variable name="first-attribute-namespace"
   select="substring-before($first-attribute-name,':')"/>
 <xsl:variable name="first-attribute-localname"
   select="substring-after($first-attribute-name,':')"/>
 <xsl:variable name="first-attribute-value">
   <xsl:call-template name="find-attribute-value">
    <xsl:with-param name="delta-attribute-string" select="$delta-attribute-string"/>
    <xsl:with-param name="attribute-name" select="$first-attribute-name"/>
   </xsl:call-template>
 </xsl:variable>
 
 <!-- Only write it out if a value was found. Note "" is a valid value -->
 <xsl:if test="not($first-attribute-value=$no-attribute-value-found)">
 <xsl:choose>
   <xsl:when test="string-length($first-attribute-namespace)>0">
     <xsl:attribute name="{$first-attribute-localname}" 
      namespace="{namespace::*[name()=$first-attribute-namespace]}">
	   <xsl:value-of select="$first-attribute-value"/>
     </xsl:attribute>
   </xsl:when>
   <xsl:otherwise>
     <xsl:attribute name="{$first-attribute-name}">
	   <xsl:value-of select="$first-attribute-value"/>
     </xsl:attribute>
   </xsl:otherwise>
 </xsl:choose>
 </xsl:if>
 
 <xsl:variable name="other-attribute-names"
   select="substring-after($attribute-names,' ')"/>
 <xsl:call-template name="write-attribute-values">
    <xsl:with-param name="delta-attribute-string" select="$delta-attribute-string"/>
    <xsl:with-param name="attribute-names" select="$other-attribute-names"/>
 </xsl:call-template>
 </xsl:if>
</xsl:template>

<!-- Returns a string denoting the value of attribute-name from delta-attribute-string -->
<xsl:template name="find-attribute-value">
 <xsl:param name="delta-attribute-string"/>
 <xsl:param name="attribute-name"/>
 <!-- find the name of the first attribute -->
  <xsl:variable name="first-attribute-name"
   select="substring-before($delta-attribute-string,'=')"/>
  <xsl:choose>
  <xsl:when test="string-length($first-attribute-name)>0">
   <xsl:variable name="attribute-value-delimiter"
    select="substring
                (substring-after($delta-attribute-string,'='),
                1,1)"/>
   <xsl:variable name="attribute-value-and-rest"
     select="substring-after($delta-attribute-string, $attribute-value-delimiter)"/>
   <xsl:choose>
    <xsl:when test="$attribute-name=$first-attribute-name">
    <!-- then we get the value and return it -->
     <xsl:value-of
      select="substring-before(
               $attribute-value-and-rest,
               $attribute-value-delimiter)"/>
    </xsl:when>
    <xsl:otherwise>
    <xsl:call-template name="find-attribute-value">
     <xsl:with-param name="delta-attribute-string"
       select="substring(substring-after($attribute-value-and-rest, $attribute-value-delimiter),2)"/>
     <xsl:with-param name="attribute-name" select="$attribute-name"/>
    </xsl:call-template>
   </xsl:otherwise>
   </xsl:choose>
  </xsl:when>
  <xsl:otherwise>
    <xsl:value-of select="$no-attribute-value-found"/>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Returns a string extracted from delta-attribute-string with the attribute name and value in it -->
<xsl:template name="find-attribute-name-and-value">
 <xsl:param name="delta-attribute-string"/>
 <xsl:param name="attribute-name"/>
 <!-- find the name of the first attribute -->
  <xsl:variable name="first-attribute-name"
   select="substring-before($delta-attribute-string,'=')"/>
  <xsl:choose>
  <xsl:when test="string-length($first-attribute-name)>0">
   <xsl:variable name="attribute-value-delimiter"
    select="substring
                (substring-after($delta-attribute-string,'='),
                1,1)"/>
   <xsl:variable name="attribute-value-and-rest"
     select="substring-after($delta-attribute-string, $attribute-value-delimiter)"/>
   <xsl:choose>
    <xsl:when test="$attribute-name=$first-attribute-name">
    <!-- then we get the value and return it -->
     <xsl:value-of
      select="concat($attribute-name,
                     '=',
                     $attribute-value-delimiter,
                     substring-before(
                      $attribute-value-and-rest,
                      $attribute-value-delimiter),
                     $attribute-value-delimiter)"/>
    </xsl:when>
    <xsl:otherwise>
    <xsl:call-template name="find-attribute-name-and-value">
     <xsl:with-param name="delta-attribute-string"
       select="substring(substring-after($attribute-value-and-rest, $attribute-value-delimiter),2)"/>
     <xsl:with-param name="attribute-name" select="$attribute-name"/>
    </xsl:call-template>
   </xsl:otherwise>
   </xsl:choose>
  </xsl:when>
  <xsl:otherwise>
    <xsl:value-of select="$no-attribute-value-found"/>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Takes a string which is a list of attribute names and returns a string with each one replace with name and value --> 
<xsl:template name="replace-attribute-name-with-name-and-value">
 <xsl:param name="delta-attribute-string"/>
 <xsl:param name="attribute-name-string"/>
 <!-- find the name of the first attribute -->
  <xsl:variable name="first-attribute-name"
   select="substring-before($attribute-name-string,' ')"/>
  <xsl:if test="string-length($first-attribute-name)>0">
   <xsl:variable name="other-attribute-names"
   select="substring-after($attribute-name-string,' ')"/>
   <xsl:variable name="first-attribute-name-and-value">
    <xsl:call-template name="find-attribute-name-and-value">
     <xsl:with-param name="delta-attribute-string"
       select="$delta-attribute-string"/>
     <xsl:with-param name="attribute-name" select="$first-attribute-name"/>
    </xsl:call-template>
   </xsl:variable>
   <xsl:variable name="other-attribute-name-and-value">
    <xsl:call-template name="replace-attribute-name-with-name-and-value">
     <xsl:with-param name="delta-attribute-string"
       select="$delta-attribute-string"/>
     <xsl:with-param name="attribute-name-string" select="$other-attribute-names"/>
    </xsl:call-template>
  </xsl:variable>

  <xsl:value-of
      select="concat($first-attribute-name-and-value,
                     ' ',
                     $other-attribute-name-and-value)"/>
 </xsl:if>
</xsl:template>


<!-- Set manipulation templates -->

<xsl:template name="nmtokens-set-difference">
 <xsl:param name="first-string"/>
 <xsl:param name="second-string"/>
 <xsl:call-template name="nmtokens-set-function">
   <xsl:with-param name="first-string"
      select="concat(normalize-space($first-string), ' ')"/>
   <xsl:with-param name="second-string" select="$second-string"/>
   <xsl:with-param name="function" select="string('difference')"/>
 </xsl:call-template>
</xsl:template>

<xsl:template name="nmtokens-set-intersection">
 <xsl:param name="first-string"/>
 <xsl:param name="second-string"/>
 <xsl:call-template name="nmtokens-set-function">
   <xsl:with-param name="first-string"
       select="concat(normalize-space($first-string), ' ')"/>
   <xsl:with-param name="second-string" select="$second-string"/>
   <xsl:with-param name="function" select="string('intersection')"/>
 </xsl:call-template>
</xsl:template>

<!-- Returns a string containing the values of NMTOKENS in first-string but not in second-string
if function='difference' or values in both strings if function='intersection'
Note that there must be no space before the first token and there must be one space at the end,
i.e. after the last token. This is for efficiency to save repeated normalization-->
<xsl:template name="nmtokens-set-function">
 <xsl:param name="first-string"/>
 <xsl:param name="second-string"/>
 <xsl:param name="function"/>
 <!-- find the name of the first token -->
  <xsl:variable name="first-token"
   select="concat(substring-before($first-string,' '), ' ')"/>
 <!-- space is needed above so that we do not find nmtokens that are substrings of other tokens -->

   <xsl:if test="string-length($first-token)>1">
     <xsl:if test="($function='intersection' and contains($second-string, $first-token))
                  or
                  ($function='difference' and not(contains($second-string, $first-token)))">
      <xsl:value-of select="$first-token"/>
    </xsl:if>

    <xsl:variable name="the-rest"
     select="substring-after($first-string, ' ')"/>
    <xsl:if test="string-length($the-rest)>1">
      <xsl:call-template name="nmtokens-set-function">
       <xsl:with-param name="first-string" select="$the-rest"/>
       <xsl:with-param name="second-string" select="$second-string"/>
       <xsl:with-param name="function" select="$function"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:if>
</xsl:template>


</xsl:stylesheet>


