/*
 * Decompiled with CFR 0.152.
 */
package com.deltaxml.pipe.filters;

import com.deltaxml.pipe.XMLFilterImpl2;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class WordByWordInfilter
extends XMLFilterImpl2 {
    private final String DELTAXML_NS = "http://www.deltaxml.com/ns/well-formed-delta-v1";
    private final String DELTAXML_PREFIX = "deltaxml";
    private final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    private final String XML_SPACE_LOCAL_NAME = "space";
    private final String WBW_LOCAL_NAME = "word-by-word";
    private final String PUNCTUATION_LOCAL_NAME = "punctuation";
    private final String FORMAT_LOCAL_NAME = "format";
    private Stack xmlSpaceStack = new Stack();
    private Stack wordByWordStack = new Stack();
    private Stack formatStack = new Stack();
    private Stack punctuationCharsStack = new Stack();
    private StringBuffer storedChars = new StringBuffer();
    private List currentFormat = new ArrayList();
    private String defaultPunctuation = "";
    private char[] delimiters = new char[]{'\"', '\'', '|', '~', '%', '^', '+', '_', '`', '/', '\\', '$', '?', ',', ';', '!'};
    private boolean isCharacterByCharacter = false;

    public void setisCharacterByCharacter(boolean cbc) {
        this.isCharacterByCharacter = cbc;
    }

    public boolean getisCharacterByCharacter() {
        return this.isCharacterByCharacter;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.storedChars.length() > 0) {
            this.outputCharacters();
        }
        super.startPrefixMapping(prefix, uri);
    }

    public void endDocument() throws SAXException {
        super.endPrefixMapping("deltaxml");
        super.endDocument();
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        super.startPrefixMapping("deltaxml", "http://www.deltaxml.com/ns/well-formed-delta-v1");
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String punctuation;
        String wordByWordVal;
        String xmlSpaceVal;
        List punctuationChars;
        boolean wordByWord;
        boolean preserve;
        if (this.storedChars.length() > 0) {
            this.outputCharacters();
        }
        try {
            preserve = (Boolean)this.xmlSpaceStack.peek();
        }
        catch (EmptyStackException e) {
            preserve = false;
        }
        try {
            wordByWord = (Boolean)this.wordByWordStack.peek();
        }
        catch (EmptyStackException e) {
            wordByWord = true;
        }
        try {
            punctuationChars = (List)this.punctuationCharsStack.peek();
        }
        catch (EmptyStackException e) {
            punctuationChars = this.parsePunctuationString(this.defaultPunctuation);
        }
        int index = atts.getIndex("http://www.w3.org/XML/1998/namespace", "space");
        if (index != -1 && (xmlSpaceVal = atts.getValue(index)) != null) {
            if (xmlSpaceVal.equals("preserve")) {
                preserve = true;
            } else if (xmlSpaceVal.equals("default")) {
                preserve = false;
            }
        }
        if ((wordByWordVal = atts.getValue("http://www.deltaxml.com/ns/well-formed-delta-v1", "word-by-word")) != null) {
            if (wordByWordVal.equals("false")) {
                wordByWord = false;
            } else if (wordByWordVal.equals("true")) {
                wordByWord = true;
            }
        }
        if ((punctuation = atts.getValue("http://www.deltaxml.com/ns/well-formed-delta-v1", "punctuation")) != null) {
            punctuationChars = this.parsePunctuationString(punctuation);
        }
        this.xmlSpaceStack.push(new Boolean(preserve));
        this.wordByWordStack.push(new Boolean(wordByWord));
        this.punctuationCharsStack.push(punctuationChars);
        if ("true".equals(atts.getValue("http://www.deltaxml.com/ns/well-formed-delta-v1", "format")) && wordByWord) {
            this.formatStack.push(new Boolean(true));
            this.currentFormat.add(new FormatEntry(uri, localName, qName, atts));
        } else {
            this.formatStack.push(new Boolean(false));
            super.startElement(uri, localName, qName, atts);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean format;
        if (this.storedChars.length() > 0) {
            this.outputCharacters();
        }
        try {
            this.xmlSpaceStack.pop();
            this.wordByWordStack.pop();
            this.punctuationCharsStack.pop();
        }
        catch (EmptyStackException e) {
            throw new SAXException("Internal Error: Empty Stack in " + ((Object)((Object)this)).getClass().getName());
        }
        try {
            format = (Boolean)this.formatStack.pop();
        }
        catch (EmptyStackException e) {
            format = false;
        }
        if (format) {
            this.currentFormat.remove(this.currentFormat.size() - 1);
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.storedChars.append(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.storedChars.length() > 0) {
            this.outputCharacters();
        }
    }

    private void outputCharacters() throws SAXException {
        if (!((Boolean)this.xmlSpaceStack.peek()).booleanValue() && ((Boolean)this.wordByWordStack.peek()).booleanValue()) {
            StringBuffer whiteSpace = new StringBuffer();
            StringBuffer content = new StringBuffer();
            StringBuffer punctuation = new StringBuffer();
            for (int i = 0; i < this.storedChars.length(); ++i) {
                char currentChar = this.storedChars.charAt(i);
                if (currentChar == ' ' || currentChar == '\t' || currentChar == '\r' || currentChar == '\n') {
                    if (content.length() > 0) {
                        this.output(content, "word");
                        content = new StringBuffer();
                    } else if (punctuation.length() > 0) {
                        this.output(punctuation, "punctuation");
                        punctuation = new StringBuffer();
                    }
                    whiteSpace.append(currentChar);
                    continue;
                }
                if (this.isCharacter(i)) {
                    if (content.length() > 0) {
                        this.output(content, "word");
                        content = new StringBuffer();
                    } else if (whiteSpace.length() > 0) {
                        this.output(whiteSpace, "space");
                        whiteSpace = new StringBuffer();
                    }
                    punctuation.append(currentChar);
                    continue;
                }
                if (whiteSpace.length() > 0) {
                    this.output(whiteSpace, "space");
                    whiteSpace = new StringBuffer();
                } else if (punctuation.length() > 0) {
                    this.output(punctuation, "punctuation");
                    punctuation = new StringBuffer();
                }
                if (this.isCharacterByCharacter) {
                    content.append(currentChar);
                    if (content.length() != 1) {
                        throw new SAXException("Internal Error:  CBC mode logical error - found multiple characters when single expected");
                    }
                    this.output(content, "word");
                    content = new StringBuffer();
                    continue;
                }
                content.append(currentChar);
            }
            if (content.length() > 0) {
                this.output(content, "word");
            }
            if (whiteSpace.length() > 0) {
                this.output(whiteSpace, "space");
            }
            if (punctuation.length() > 0) {
                this.output(punctuation, "punctuation");
            }
        } else {
            char[] copy = new char[this.storedChars.length()];
            this.storedChars.getChars(0, this.storedChars.length(), copy, 0);
            super.characters(copy, 0, copy.length);
        }
        this.storedChars = new StringBuffer();
    }

    private boolean isCharacter(int i) {
        char currentChar = this.storedChars.charAt(i);
        List currentPunctuationList = (List)this.punctuationCharsStack.peek();
        if (currentPunctuationList.contains(new Character(currentChar))) {
            int puncBegin = i;
            int puncEnd = i;
            while (puncBegin - 1 >= 0 && currentPunctuationList.contains(new Character(this.storedChars.charAt(puncBegin - 1)))) {
                --puncBegin;
            }
            while (puncEnd + 1 < this.storedChars.length() && currentPunctuationList.contains(new Character(this.storedChars.charAt(puncEnd + 1)))) {
                ++puncEnd;
            }
            if (puncBegin == 0 || puncEnd == this.storedChars.length() - 1) {
                return true;
            }
            char beforeChar = this.storedChars.charAt(puncBegin - 1);
            char afterChar = this.storedChars.charAt(puncEnd + 1);
            if (beforeChar == ' ' || beforeChar == '\t' || beforeChar == '\r' || beforeChar == '\n') {
                return true;
            }
            if (afterChar == ' ' || afterChar == '\t' || afterChar == '\r' || afterChar == '\n') {
                return true;
            }
        }
        return false;
    }

    private void output(StringBuffer sb, String elemType) throws SAXException {
        char[] chars = new char[sb.length()];
        sb.getChars(0, sb.length(), chars, 0);
        AttributesImpl atts = new AttributesImpl();
        if (this.currentFormat.size() > 0) {
            HashSet formatSet = new HashSet();
            for (int i = this.currentFormat.size() - 1; i >= 0; --i) {
                formatSet.add(this.currentFormat.get(i));
            }
            for (FormatEntry fe : formatSet) {
                atts.addAttribute(fe.getUri(), fe.getLocalName(), fe.getQName(), "CDATA", fe.getEncodedAtts());
            }
        }
        super.startElement("http://www.deltaxml.com/ns/well-formed-delta-v1", elemType, "deltaxml:" + elemType, (Attributes)atts);
        super.characters(chars, 0, chars.length);
        super.endElement("http://www.deltaxml.com/ns/well-formed-delta-v1", elemType, "deltaxml:" + elemType);
    }

    private List parsePunctuationString(String defaultPunctuation) {
        ArrayList<Character> punctuationList = new ArrayList<Character>();
        StringTokenizer charsST = new StringTokenizer(defaultPunctuation);
        while (charsST.hasMoreTokens()) {
            String charToken = charsST.nextToken();
            if (charToken.length() != 1) continue;
            punctuationList.add(new Character(charToken.charAt(0)));
        }
        return punctuationList;
    }

    private class FormatEntry {
        private String uri;
        private String localName;
        private String qName;
        private AttributesImpl atts;

        FormatEntry(String uri, String localName, String qName, Attributes atts) {
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            this.atts = new AttributesImpl(atts);
        }

        String getLocalName() {
            return this.localName;
        }

        void setLocalName(String localName) {
            this.localName = localName;
        }

        String getUri() {
            return this.uri;
        }

        void setUri(String namespace) {
            this.uri = namespace;
        }

        String getQName() {
            return this.qName;
        }

        void setQName(String name) {
            this.qName = name;
        }

        String getEncodedAtts() throws SAXException {
            int index = this.atts.getIndex("deltaxml:format");
            if (index != -1) {
                this.atts.removeAttribute(index);
            }
            String attString = "";
            for (int i = 0; i < this.atts.getLength(); ++i) {
                char delimiter;
                String qName = this.atts.getQName(i);
                String value = this.atts.getValue(i);
                int j = 0;
                boolean found = false;
                do {
                    delimiter = WordByWordInfilter.this.delimiters[j];
                    ++j;
                    boolean bl = found = value.indexOf(delimiter) == -1;
                } while (!found && i < WordByWordInfilter.this.delimiters.length);
                if (!found) {
                    throw new SAXException("ERROR: Could not find a delimiter for encoding the attribute value '" + value + "'");
                }
                attString = attString + qName + "=" + delimiter + value + delimiter + " ";
            }
            return attString;
        }

        public int hashCode() {
            return this.uri.hashCode() | this.localName.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof FormatEntry) {
                FormatEntry fe = (FormatEntry)other;
                return this.uri.equals(fe.uri) && this.localName.equals(fe.localName);
            }
            return false;
        }
    }
}

