/*
 * Decompiled with CFR 0.152.
 */
package com.deltaxml.pipe.filters;

import com.deltaxml.pipe.XMLFilterImpl2;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class OrphanedWordOutfilter
extends XMLFilterImpl2 {
    private static final String DELTAXML_NS = "http://www.deltaxml.com/ns/well-formed-delta-v1";
    private static final String DXML_PREFIX = "deltaxml";
    private static final String SPACE_LOCAL_NAME = "space";
    private static final String WORD_LOCAL_NAME = "word";
    private static final String PUNCTUATION_LOCAL_NAME = "punctuation";
    private static final String PCDATA_MODIFY_LOCAL = "PCDATAmodify";
    private static final String PCDATA_MODIFY = "deltaxml:PCDATAmodify";
    private static final String PCDATA_OLD_LOCAL = "PCDATAold";
    private static final String PCDATA_OLD = "deltaxml:PCDATAold";
    private static final String PCDATA_NEW_LOCAL = "PCDATAnew";
    private static final String PCDATA_NEW = "deltaxml:PCDATAnew";
    private static final String DELTA_LOCAL_NAME = "delta";
    private static final String MODIFY = "WFmodify";
    private static final String ADD = "add";
    private static final String DELETE = "delete";
    public static final int DEFAULT_ORPHANED_WORD_LIMIT = 2;
    public static final int DEFAULT_ORPHANED_THRESHOLD_PERCENTAGE = 20;
    private int preceedingOrphanedWordCount = 0;
    private int countOrphaned = 0;
    private int followingOrphanedWordCount = 0;
    private String currentLocalName;
    private Attributes currentAttributes;
    private boolean currentModified;
    private boolean currentAdd;
    private boolean currentDelete;
    private String currentNewPCData;
    private String currentOldPCData;
    private boolean currentPCData;
    private ArrayList orphanedList = new ArrayList();
    private ArrayList pendingList = new ArrayList();
    private boolean outputCurrentElement = false;
    private boolean inWord = false;
    private boolean inSpace = false;
    private boolean inPunctuation = false;
    private boolean inPCDataModified = false;
    private boolean inPCDataNew = false;
    private boolean inPCDataOld = false;
    private boolean previousWordModified = false;
    private boolean possiblyOrphaned = false;
    private boolean followingPossiblyOrphaned = false;
    protected int orphanedLengthLimit = 2;
    protected int orphanedThresholdPercentage = 20;

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.orphanedLengthLimit == 0) {
            super.startElement(uri, localName, qName, atts);
            return;
        }
        this.outputCurrentElement = false;
        if (uri.equals(DELTAXML_NS)) {
            if (localName.equals(WORD_LOCAL_NAME) || localName.equals(PUNCTUATION_LOCAL_NAME) || localName.equals(SPACE_LOCAL_NAME)) {
                this.currentLocalName = localName;
                this.currentAttributes = new AttributesImpl(atts);
                this.currentModified = false;
                this.currentNewPCData = "";
                this.currentOldPCData = "";
                this.currentPCData = false;
                if (atts.getValue(DELTAXML_NS, DELTA_LOCAL_NAME) != null) {
                    this.currentModified = atts.getValue(DELTAXML_NS, DELTA_LOCAL_NAME).equals(MODIFY);
                    this.currentAdd = atts.getValue(DELTAXML_NS, DELTA_LOCAL_NAME).equals(ADD);
                    this.currentDelete = atts.getValue(DELTAXML_NS, DELTA_LOCAL_NAME).equals(DELETE);
                }
                this.inWord = localName.equals(WORD_LOCAL_NAME);
                this.inPunctuation = localName.equals(PUNCTUATION_LOCAL_NAME);
                this.inSpace = localName.equals(SPACE_LOCAL_NAME);
            } else if (localName.equals(PCDATA_MODIFY_LOCAL)) {
                this.inPCDataModified = true;
                this.currentPCData = this.currentModified;
            } else if (localName.equals(PCDATA_OLD_LOCAL) || localName.equals(PCDATA_NEW_LOCAL)) {
                this.inPCDataNew = localName.equals(PCDATA_NEW_LOCAL);
                this.inPCDataOld = localName.equals(PCDATA_OLD_LOCAL);
            } else {
                this.outputCurrentElement = true;
            }
        } else {
            this.outputCurrentElement = true;
        }
        if (this.outputCurrentElement) {
            this.judgeOrphaned();
            super.startElement(uri, localName, qName, atts);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.orphanedLengthLimit == 0) {
            super.endElement(uri, localName, qName);
            return;
        }
        this.outputCurrentElement = false;
        if (uri.equals(DELTAXML_NS)) {
            if (localName.equals(WORD_LOCAL_NAME) || localName.equals(PUNCTUATION_LOCAL_NAME) || localName.equals(SPACE_LOCAL_NAME)) {
                if (!this.possiblyOrphaned) {
                    this.outputCurrent();
                }
                this.inWord = false;
                this.inSpace = false;
                this.inPunctuation = false;
            } else if (localName.equals(PCDATA_MODIFY_LOCAL)) {
                this.inPCDataModified = false;
            } else if (localName.equals(PCDATA_NEW_LOCAL) || localName.equals(PCDATA_OLD_LOCAL)) {
                this.inPCDataNew = false;
                this.inPCDataOld = false;
            } else {
                this.outputCurrentElement = true;
            }
        } else {
            this.outputCurrentElement = true;
        }
        if (this.outputCurrentElement) {
            this.judgeOrphaned();
            super.endElement(uri, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.orphanedLengthLimit == 0) {
            super.characters(ch, start, length);
            return;
        }
        if (!(!this.inWord && !this.inPunctuation || this.inPCDataModified || this.currentAdd || this.currentDelete || !this.previousWordModified || this.possiblyOrphaned && !this.followingPossiblyOrphaned)) {
            this.judgeOrphaned();
            this.possiblyOrphaned = true;
            this.followingPossiblyOrphaned = false;
            this.previousWordModified = false;
        } else if ((this.inWord || this.inPunctuation) && (this.inPCDataModified || this.currentAdd || this.currentDelete) && this.possiblyOrphaned) {
            this.followingPossiblyOrphaned = true;
            this.previousWordModified = true;
        }
        if (this.outputCurrentElement) {
            super.characters(ch, start, length);
        } else if (!this.possiblyOrphaned) {
            this.notPossiblyOrphanedCharacters(ch, start, length);
        } else if (this.followingPossiblyOrphaned) {
            this.followingPossiblyOrphanedCharacters(ch, start, length);
        } else if (this.possiblyOrphaned) {
            this.possiblyOrphanedCharacters(ch, start, length);
        }
    }

    private void notPossiblyOrphanedCharacters(char[] ch, int start, int length) {
        if (this.inPCDataOld) {
            if (this.inWord || this.inPunctuation) {
                ++this.followingOrphanedWordCount;
                this.previousWordModified = true;
            }
            this.currentOldPCData = this.currentOldPCData + new String(ch, start, length);
        } else if (this.inPCDataNew) {
            if (this.inWord || this.inPunctuation) {
                this.previousWordModified = true;
            }
            this.currentNewPCData = this.currentNewPCData + new String(ch, start, length);
        } else if (this.currentDelete) {
            if (this.inWord || this.inPunctuation) {
                ++this.followingOrphanedWordCount;
                this.previousWordModified = true;
            }
            this.currentOldPCData = this.currentOldPCData + new String(ch, start, length);
        } else if (this.currentAdd) {
            if (this.inWord || this.inPunctuation) {
                ++this.followingOrphanedWordCount;
                this.previousWordModified = true;
            }
            this.currentNewPCData = this.currentNewPCData + new String(ch, start, length);
        } else {
            if (this.inWord || this.inPunctuation) {
                this.previousWordModified = false;
            }
            this.currentOldPCData = this.currentOldPCData + new String(ch, start, length);
        }
    }

    private void followingPossiblyOrphanedCharacters(char[] ch, int start, int length) {
        if (this.inPCDataOld) {
            DeltaElement current = null;
            if (this.inWord) {
                ++this.followingOrphanedWordCount;
                current = new DeltaWordElement(1, this.currentAttributes);
            } else if (this.inSpace) {
                current = new DeltaSpaceElement(1, this.currentAttributes);
            } else if (this.inPunctuation) {
                current = new DeltaPunctuationElement(1, this.currentAttributes);
            }
            this.pendingList.add(current);
            current.setOldValue(new String(ch, start, length));
        } else if (this.inPCDataNew) {
            ((DeltaElement)this.pendingList.get(this.pendingList.size() - 1)).setNewValue(new String(ch, start, length));
        } else if (this.currentAdd) {
            DeltaElement current = null;
            if (this.inWord) {
                ++this.followingOrphanedWordCount;
                current = new DeltaWordElement(2, this.currentAttributes);
            } else if (this.inSpace) {
                current = new DeltaSpaceElement(2, this.currentAttributes);
            } else if (this.inPunctuation) {
                current = new DeltaPunctuationElement(2, this.currentAttributes);
            }
            this.pendingList.add(current);
            current.setNewValue(new String(ch, start, length));
        } else if (this.currentDelete) {
            DeltaElement current = null;
            if (this.inWord) {
                ++this.followingOrphanedWordCount;
                current = new DeltaWordElement(3, this.currentAttributes);
            } else if (this.inSpace) {
                current = new DeltaSpaceElement(3, this.currentAttributes);
            } else if (this.inPunctuation) {
                current = new DeltaPunctuationElement(3, this.currentAttributes);
            }
            this.pendingList.add(current);
            current.setOldValue(new String(ch, start, length));
        } else {
            DeltaSpaceElement current = null;
            if (this.inSpace) {
                current = new DeltaSpaceElement(0, this.currentAttributes);
            }
            this.pendingList.add(current);
            current.setUnchangedValue(new String(ch, start, length));
        }
    }

    private void possiblyOrphanedCharacters(char[] ch, int start, int length) {
        DeltaElement current = null;
        if (this.inWord) {
            ++this.countOrphaned;
            current = new DeltaWordElement(0, this.currentAttributes);
            current.setUnchangedValue(new String(ch, start, length));
            this.orphanedList.add(current);
        } else if (this.inPunctuation) {
            ++this.countOrphaned;
            current = new DeltaPunctuationElement(0, this.currentAttributes);
            current.setUnchangedValue(new String(ch, start, length));
            this.orphanedList.add(current);
        } else if (this.inSpace) {
            if (this.inPCDataOld) {
                current = new DeltaSpaceElement(1, this.currentAttributes);
                current.setOldValue(new String(ch, start, length));
                this.orphanedList.add(current);
            } else if (this.inPCDataNew) {
                ((DeltaElement)this.orphanedList.get(this.orphanedList.size() - 1)).setNewValue(new String(ch, start, length));
            } else if (this.currentAdd) {
                current = new DeltaSpaceElement(2, this.currentAttributes);
                current.setNewValue(new String(ch, start, length));
                this.orphanedList.add(current);
            } else if (this.currentDelete) {
                current = new DeltaSpaceElement(3, this.currentAttributes);
                current.setOldValue(new String(ch, start, length));
                this.orphanedList.add(current);
            } else {
                current = new DeltaSpaceElement(0, this.currentAttributes);
                current.setUnchangedValue(new String(ch, start, length));
                this.orphanedList.add(current);
            }
        }
    }

    private void outputCurrent() throws SAXException {
        super.startElement(DELTAXML_NS, this.currentLocalName, "deltaxml:" + this.currentLocalName, this.currentAttributes);
        if (this.currentModified && this.currentPCData) {
            super.startElement(DELTAXML_NS, PCDATA_MODIFY_LOCAL, PCDATA_MODIFY, (Attributes)new AttributesImpl());
            super.startElement(DELTAXML_NS, PCDATA_OLD_LOCAL, PCDATA_OLD, (Attributes)new AttributesImpl());
            if (this.currentOldPCData.length() != 0) {
                super.characters(this.currentOldPCData.toCharArray(), 0, this.currentOldPCData.length());
            }
            super.endElement(DELTAXML_NS, PCDATA_OLD_LOCAL, PCDATA_OLD);
            super.startElement(DELTAXML_NS, PCDATA_NEW_LOCAL, PCDATA_NEW, (Attributes)new AttributesImpl());
            if (this.currentNewPCData.length() != 0) {
                super.characters(this.currentNewPCData.toCharArray(), 0, this.currentNewPCData.length());
            }
            super.endElement(DELTAXML_NS, PCDATA_NEW_LOCAL, PCDATA_NEW);
            super.endElement(DELTAXML_NS, PCDATA_MODIFY_LOCAL, PCDATA_MODIFY);
        } else if (this.currentAdd) {
            if (this.currentNewPCData.length() != 0) {
                super.characters(this.currentNewPCData.toCharArray(), 0, this.currentNewPCData.length());
            }
        } else if (this.currentDelete) {
            if (this.currentOldPCData.length() != 0) {
                super.characters(this.currentOldPCData.toCharArray(), 0, this.currentOldPCData.length());
            }
        } else if (this.currentOldPCData.length() != 0) {
            super.characters(this.currentOldPCData.toCharArray(), 0, this.currentOldPCData.length());
        }
        super.endElement(DELTAXML_NS, this.currentLocalName, "deltaxml:" + this.currentLocalName);
    }

    private void judgeOrphaned() throws SAXException {
        int totalCount = this.preceedingOrphanedWordCount + this.followingOrphanedWordCount + this.countOrphaned;
        int percentage = (int)((double)this.countOrphaned / (double)totalCount * 100.0);
        boolean orphaned = this.countOrphaned > 0 && this.preceedingOrphanedWordCount > 0 && this.followingOrphanedWordCount > 0 && percentage <= this.orphanedThresholdPercentage && this.countOrphaned <= this.orphanedLengthLimit;
        this.outputBuffer(orphaned);
        this.previousWordModified = false;
        this.possiblyOrphaned = false;
        this.followingPossiblyOrphaned = false;
        this.preceedingOrphanedWordCount = this.followingOrphanedWordCount;
        this.countOrphaned = 0;
        this.followingOrphanedWordCount = 0;
        this.pendingList = new ArrayList();
        this.orphanedList = new ArrayList();
    }

    private void outputBuffer(boolean orphaned) throws SAXException {
        Iterator orphanedIterator = this.orphanedList.iterator();
        while (orphanedIterator.hasNext()) {
            this.outputOrphaned((DeltaElement)orphanedIterator.next(), orphaned);
        }
        Iterator pendingIterator = this.pendingList.iterator();
        while (pendingIterator.hasNext()) {
            this.outputPending((DeltaElement)pendingIterator.next());
        }
    }

    private void outputPending(DeltaElement element) throws SAXException {
        AttributesImpl atts = element.getAttributes();
        String localName = element.getLocalName();
        if (element.getType() == 1) {
            atts.setValue(atts.getIndex(DELTAXML_NS, DELTA_LOCAL_NAME), MODIFY);
        } else if (element.getType() == 2) {
            atts.setValue(atts.getIndex(DELTAXML_NS, DELTA_LOCAL_NAME), ADD);
        } else if (element.getType() == 3) {
            atts.setValue(atts.getIndex(DELTAXML_NS, DELTA_LOCAL_NAME), DELETE);
        }
        super.startElement(DELTAXML_NS, localName, "deltaxml:" + localName, (Attributes)atts);
        if (element.getType() == 1) {
            String oldString = element.getOldValue();
            String newString = element.getNewValue();
            super.startElement(DELTAXML_NS, PCDATA_MODIFY_LOCAL, PCDATA_MODIFY, (Attributes)new AttributesImpl());
            super.startElement(DELTAXML_NS, PCDATA_OLD_LOCAL, PCDATA_OLD, (Attributes)new AttributesImpl());
            if (oldString != null && oldString.length() != 0) {
                super.characters(oldString.toCharArray(), 0, oldString.length());
            }
            super.endElement(DELTAXML_NS, PCDATA_OLD_LOCAL, PCDATA_OLD);
            super.startElement(DELTAXML_NS, PCDATA_NEW_LOCAL, PCDATA_NEW, (Attributes)new AttributesImpl());
            if (newString != null && newString.length() != 0) {
                super.characters(newString.toCharArray(), 0, newString.length());
            }
            super.endElement(DELTAXML_NS, PCDATA_NEW_LOCAL, PCDATA_NEW);
            super.endElement(DELTAXML_NS, PCDATA_MODIFY_LOCAL, PCDATA_MODIFY);
        } else if (element.getType() == 2) {
            String newString = element.getNewValue();
            super.characters(newString.toCharArray(), 0, newString.length());
        } else if (element.getType() == 3) {
            String oldString = element.getOldValue();
            super.characters(oldString.toCharArray(), 0, oldString.length());
        } else {
            String unchangedString = element.getUnchangedValue();
            if (unchangedString.length() != 0) {
                super.characters(unchangedString.toCharArray(), 0, unchangedString.length());
            }
        }
        super.endElement(DELTAXML_NS, localName, "deltaxml:" + localName);
    }

    private void outputOrphaned(DeltaElement element, boolean orphaned) throws SAXException {
        AttributesImpl atts = element.getAttributes();
        String localName = element.getLocalName();
        if (element.getType() == 1 || (localName.equals(WORD_LOCAL_NAME) || localName.equals(PUNCTUATION_LOCAL_NAME)) && orphaned) {
            atts.setValue(atts.getIndex(DELTAXML_NS, DELTA_LOCAL_NAME), MODIFY);
        } else if (element.getType() == 2) {
            atts.setValue(atts.getIndex(DELTAXML_NS, DELTA_LOCAL_NAME), ADD);
        } else if (element.getType() == 3) {
            atts.setValue(atts.getIndex(DELTAXML_NS, DELTA_LOCAL_NAME), DELETE);
        }
        super.startElement(DELTAXML_NS, localName, "deltaxml:" + localName, (Attributes)atts);
        if (element.getType() == 1 || (localName.equals(WORD_LOCAL_NAME) || localName.equals(PUNCTUATION_LOCAL_NAME)) && orphaned) {
            String newString;
            String oldString;
            if ((localName.equals(WORD_LOCAL_NAME) || localName.equals(PUNCTUATION_LOCAL_NAME)) && orphaned) {
                newString = oldString = element.getUnchangedValue();
            } else {
                oldString = element.getOldValue();
                newString = element.getNewValue();
            }
            super.startElement(DELTAXML_NS, PCDATA_MODIFY_LOCAL, PCDATA_MODIFY, (Attributes)new AttributesImpl());
            super.startElement(DELTAXML_NS, PCDATA_OLD_LOCAL, PCDATA_OLD, (Attributes)new AttributesImpl());
            if (oldString.length() != 0) {
                super.characters(oldString.toCharArray(), 0, oldString.length());
            }
            super.endElement(DELTAXML_NS, PCDATA_OLD_LOCAL, PCDATA_OLD);
            super.startElement(DELTAXML_NS, PCDATA_NEW_LOCAL, PCDATA_NEW, (Attributes)new AttributesImpl());
            if (newString.length() != 0) {
                super.characters(newString.toCharArray(), 0, newString.length());
            }
            super.endElement(DELTAXML_NS, PCDATA_NEW_LOCAL, PCDATA_NEW);
            super.endElement(DELTAXML_NS, PCDATA_MODIFY_LOCAL, PCDATA_MODIFY);
        } else if (element.getType() == 2) {
            String newString = element.getNewValue();
            super.characters(newString.toCharArray(), 0, newString.length());
        } else if (element.getType() == 3) {
            String oldString = element.getOldValue();
            super.characters(oldString.toCharArray(), 0, oldString.length());
        } else {
            String unchangedString = element.getUnchangedValue();
            if (unchangedString.length() != 0) {
                super.characters(unchangedString.toCharArray(), 0, unchangedString.length());
            }
        }
        super.endElement(DELTAXML_NS, localName, "deltaxml:" + localName);
    }

    public void setorphanedLengthLimit(String orphanedLengthLimit) throws SAXException {
        try {
            int orphanedLengthLimitInt = Integer.parseInt(orphanedLengthLimit);
            if (orphanedLengthLimitInt < 0) {
                this.orphanedLengthLimit = 2;
                throw new SAXException("Invalid value for orphanedLengthLimit (it can't be less than 0), using default of 2");
            }
            this.orphanedLengthLimit = orphanedLengthLimitInt;
        }
        catch (NumberFormatException nfe) {
            this.orphanedLengthLimit = 2;
            SAXException se = new SAXException("Invalid value for orphanedLengthLimit, using default of 2", nfe);
            se.initCause(nfe);
            throw se;
        }
    }

    public void setorphanedThresholdPercentage(String orphanedThresholdPercentage) throws SAXException {
        try {
            int orphanedThresholdPercentageInt = Integer.parseInt(orphanedThresholdPercentage);
            if (orphanedThresholdPercentageInt < 0) {
                this.orphanedThresholdPercentage = 20;
                throw new SAXException("Invalid value for orpanedLengthLimit (it can't be less than 0), using default of 2");
            }
            this.orphanedThresholdPercentage = orphanedThresholdPercentageInt;
        }
        catch (NumberFormatException nfe) {
            this.orphanedThresholdPercentage = 20;
            throw new SAXException("Invalid value for orphanedThresholdPercentage, using default of 20%", nfe);
        }
    }

    private class DeltaPunctuationElement
    extends DeltaElement {
        public DeltaPunctuationElement(byte type, Attributes attributes) {
            super(type, attributes);
        }

        public String getLocalName() {
            return OrphanedWordOutfilter.PUNCTUATION_LOCAL_NAME;
        }
    }

    private class DeltaSpaceElement
    extends DeltaElement {
        public DeltaSpaceElement(byte type, Attributes attributes) {
            super(type, attributes);
        }

        public String getLocalName() {
            return OrphanedWordOutfilter.SPACE_LOCAL_NAME;
        }
    }

    private class DeltaWordElement
    extends DeltaElement {
        public DeltaWordElement(byte type, Attributes attributes) {
            super(type, attributes);
        }

        public String getLocalName() {
            return OrphanedWordOutfilter.WORD_LOCAL_NAME;
        }
    }

    private abstract class DeltaElement {
        public static final byte UNCHANGED = 0;
        public static final byte MODIFY = 1;
        public static final byte ADD = 2;
        public static final byte DELETE = 3;
        private byte type;
        private String oldValue;
        private String newValue;
        private String unchangedValue;
        private AttributesImpl attributes;

        public DeltaElement(byte type, Attributes attributes) {
            this.type = type;
            this.attributes = new AttributesImpl(attributes);
        }

        public byte getType() {
            return this.type;
        }

        public void setType(byte type) {
            this.type = type;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public void setOldValue(String oldValue) {
            this.oldValue = oldValue;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public void setNewValue(String newValue) {
            this.newValue = newValue;
        }

        public AttributesImpl getAttributes() {
            return this.attributes;
        }

        public void setAttributes(AttributesImpl attributes) {
            this.attributes = attributes;
        }

        public String getUnchangedValue() {
            return this.unchangedValue;
        }

        public void setUnchangedValue(String unchangedValue) {
            this.unchangedValue = unchangedValue;
        }

        public abstract String getLocalName();
    }
}

